/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportBizService;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.spread.export.excel.impl.AbsReportFormsExportExcel;
import kd.tmc.fpm.business.spread.export.utils.ReportPlanSearchHeaderHelper;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;

public class ReportPlanSearchAnalyseFormsExportImpl
extends AbsReportFormsExportExcel {
    private DimensionRepository dimensionRepository;
    private IAnalysisReportBizService bizService;
    private AnalysisHeader headerInfo;
    private AnalysisHeader copyHeaderInfo;
    private ReportModel reportModel;
    private FundPlanSystem system;
    private FormShowParameter viewParameter;

    public ReportPlanSearchAnalyseFormsExportImpl(AnalysisHeader headerInfo, FormShowParameter viewParameter) {
        this.headerInfo = headerInfo;
        this.dimensionRepository = new DimensionRepository();
        this.bizService = new AnalysisReportBizService();
        this.copyHeaderInfo = (AnalysisHeader)FpmSerializeUtil.deepCopy((Object)headerInfo, AnalysisHeader.class);
        this.viewParameter = viewParameter;
    }

    @Override
    protected void getOriginalData() {
        this.system = this.dimensionRepository.loadSystem(this.headerInfo.getBodySystemId());
        this.headerInfo.setAnalysisReportType(AnalysisReportType.LINK_SEARCH_ANALYSE);
        FpmOperateResult<Report> reportFpmOperateResult = this.bizService.loadReport(this.headerInfo, this.system);
        Report report = reportFpmOperateResult.getData();
        if (report.getExchangeRateTableId() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7f16\u62a5\u671f\u95f4\u5747\u65e0\u7f16\u62a5\u6570\u636e\uff0c\u65e0\u6570\u636e\u5bfc\u51fa", (String)"SynthesisReportFormsExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        this.headerInfo.setOrg(this.copyHeaderInfo.getOrg());
        this.headerInfo.setCurrency(this.copyHeaderInfo.getCurrency());
        this.headerInfo.setExchangeRateTableId((Long)this.viewParameter.getCustomParam("exratetable"));
        this.headerInfo.setExchangeRateDate(DateUtils.stringToDate((String)((String)this.viewParameter.getCustomParam("exchangeratedate")), (String)"yyyy-MM-dd"));
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportPlanSearchAnalyseExecutor(this.system, report);
        this.reportModel = reportExecutor.executeAction();
    }

    @Override
    protected String exportParamsPrepare(Map<String, Sheet> sheetMap) {
        List<ReportCalcModel> reportCalcModels = this.reportModel.getReportCalcModelList();
        if (EmptyUtil.isEmpty(reportCalcModels)) {
            return String.format(ResManager.loadKDString((String)"\u7a7a\u62a5\u8868_%1$s.xlsx", (String)"SynthesisReportFormsExportImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        }
        String caption = this.viewParameter.getCaption();
        String excelName = String.format("%s_%s.xlsx", caption, DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        for (ReportCalcModel reportCalcModel : reportCalcModels) {
            String sheetName = "";
            new DAGFormulaManager(reportCalcModel, null);
            ReportPlanSearchHeaderHelper.addExcelReportHeader(this.headerInfo, this.system, reportCalcModel, this.viewParameter);
            Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(reportCalcModel);
            sheetMap.put(sheetName, book.getSheet());
        }
        return excelName;
    }
}

