/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportBizService;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactory;
import kd.tmc.fpm.business.spread.export.excel.impl.AbsReportFormsExportExcel;
import kd.tmc.fpm.business.spread.export.utils.SumSubReportHeaderHelper;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;

public class SumSubReportFormsExportImpl
extends AbsReportFormsExportExcel {
    private IDimensionRepository iDimensionRepository;
    private IAnalysisReportBizService bizService;
    private AnalysisHeader headerInfo;
    private ReportModel reportModel;
    private FundPlanSystem system;
    private IFpmPageCacheService cacheService;

    public SumSubReportFormsExportImpl(AnalysisHeader headerInfo, IFpmPageCacheService cacheService) {
        this.headerInfo = headerInfo;
        this.iDimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
        this.bizService = new AnalysisReportBizService();
        this.cacheService = cacheService;
    }

    @Override
    protected void getOriginalData() {
        this.system = this.iDimensionRepository.loadSystem(this.headerInfo.getBodySystemId());
        FpmOperateResult<Report> reportFpmOperateResult = this.bizService.loadSumPlanSubReport(this.headerInfo, this.system, this.cacheService);
        Report report = reportFpmOperateResult.getData();
        if (report.getExchangeRateTableId() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7f16\u62a5\u671f\u95f4\u5747\u65e0\u7f16\u62a5\u6570\u636e\uff0c\u65e0\u6570\u636e\u5bfc\u51fa", (String)"SynthesisReportFormsExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        this.headerInfo.setPeriodId(Collections.singletonList(Long.valueOf(this.cacheService.get("reportperiod"))));
        String currencyRangeJson = this.cacheService.get("currencyrange");
        List currencyRange = (List)JSON.parseObject((String)currencyRangeJson, List.class);
        this.headerInfo.setCurrency(currencyRange);
        this.reportModel = ReportDataManagerFactory.createAnalysisSumPlanSubReportModel(this.system, report);
    }

    @Override
    protected String exportParamsPrepare(Map<String, Sheet> sheetMap) {
        List<ReportCalcModel> reportCalcModels = this.reportModel.getReportCalcModelList();
        String labelType = ResManager.loadKDString((String)"\u8054\u67e5\u4e0b\u7ea7", (String)"SumSubReportFormsExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        String sumReportOrgName = this.system.getMainDimensionByDimType(DimensionType.ORG).getDimMemberById(this.headerInfo.getSumReportOrg()).getName();
        String reportPeriodName = this.system.getMainDimensionByDimType(DimensionType.PERIOD).getDimMemberById(Long.valueOf(this.cacheService.get("reportperiod"))).getName();
        String excelName = String.format("%s_%s_%s.xlsx", labelType, sumReportOrgName, reportPeriodName);
        if (EmptyUtil.isEmpty(reportCalcModels)) {
            return excelName;
        }
        for (ReportCalcModel reportCalcModel : reportCalcModels) {
            String sheetName = "";
            SumSubReportHeaderHelper.addExcelReportHeader(this.headerInfo, this.system, reportCalcModel);
            Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(reportCalcModel);
            sheetMap.put(sheetName, book.getSheet());
        }
        return excelName;
    }
}

