/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportBizService;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.spread.export.excel.impl.AbsReportFormsExportExcel;
import kd.tmc.fpm.business.spread.export.utils.SynthesisReportHeaderHelper;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;

public class SynthesisReportFormsExportImpl
extends AbsReportFormsExportExcel {
    private DimensionRepository dimensionRepository;
    private IAnalysisReportBizService bizService;
    private AnalysisHeader headerInfo;
    private AnalysisHeader copyHeaderInfo;
    private ReportModel reportModel;
    private FundPlanSystem system;

    public SynthesisReportFormsExportImpl(AnalysisHeader headerInfo) {
        this.headerInfo = headerInfo;
        this.dimensionRepository = new DimensionRepository();
        this.bizService = new AnalysisReportBizService();
        this.copyHeaderInfo = (AnalysisHeader)FpmSerializeUtil.deepCopy((Object)headerInfo, AnalysisHeader.class);
    }

    @Override
    protected void getOriginalData() {
        this.system = this.dimensionRepository.loadSystem(this.headerInfo.getBodySystemId());
        this.headerInfo.setAnalysisReportType(AnalysisReportType.SYNTHESIS);
        FpmOperateResult<Report> reportFpmOperateResult = this.bizService.loadReport(this.headerInfo, this.system);
        Report report = reportFpmOperateResult.getData();
        if (report.getExchangeRateTableId() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7f16\u62a5\u671f\u95f4\u5747\u65e0\u7f16\u62a5\u6570\u636e\uff0c\u65e0\u6570\u636e\u5bfc\u51fa", (String)"SynthesisReportFormsExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        ReportModel reportModel = new ReportModel();
        this.headerInfo.setOrg(this.copyHeaderInfo.getOrg());
        this.headerInfo.setCurrency(this.copyHeaderInfo.getCurrency());
        this.headerInfo.setExchangeRateTableId(report.getExchangeRateTableId());
        this.headerInfo.setExchangeRateDate(report.getExchangeRateDate());
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getSynthesisAnalysisReportExecutor(this.system, report);
        reportExecutor.executeAction(reportModel);
        this.reportModel = reportModel;
    }

    @Override
    protected String exportParamsPrepare(Map<String, Sheet> sheetMap) {
        List<ReportCalcModel> reportCalcModels = this.reportModel.getReportCalcModelList();
        if (EmptyUtil.isEmpty(reportCalcModels)) {
            return String.format(ResManager.loadKDString((String)"\u7a7a\u62a5\u8868_%1$s.xlsx", (String)"SynthesisReportFormsExportImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        }
        String tebleType = ResManager.loadKDString((String)"\u7efc\u5408\u7edf\u8ba1\u67e5\u8be2", (String)"SynthesisReportFormsExportImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
        String excelName = String.format("%s_%s.xlsx", tebleType, DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        for (int i = 0; i < reportCalcModels.size(); ++i) {
            String sheetName = "";
            ReportCalcModel reportCalcModel = reportCalcModels.get(i);
            new DAGFormulaManager(reportCalcModel, null);
            SynthesisReportHeaderHelper.addExcelReportHeader(this.headerInfo, this.system, reportCalcModel);
            Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(reportCalcModel);
            sheetMap.put(sheetName, book.getSheet());
        }
        return excelName;
    }
}

