/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.unit;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fpm.business.spread.export.excel.unit.IEntityUnit;
import kd.tmc.fpm.business.spread.export.utils.ColorUtils;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CellStyleUnit
implements IEntityUnit<XSSFCellStyle, Cell> {
    private Map<String, XSSFCellStyle> units = null;
    private XSSFWorkbook xssfWB = null;
    private XSSFCellStyle defaultCellStyle = null;

    public CellStyleUnit(XSSFWorkbook xssfWB) {
        this.xssfWB = xssfWB;
        this.units = new HashMap<String, XSSFCellStyle>(16);
        this.defaultCellStyle = xssfWB.createCellStyle();
    }

    @Override
    public XSSFCellStyle obtainEntityUnit(Cell cell) {
        String key = this.generateGroupKey(cell);
        XSSFCellStyle xssfCellStyle = this.units.get(key);
        if (xssfCellStyle != null) {
            return xssfCellStyle;
        }
        XSSFCellStyle newCellStyle = this.defaultCellStyle.copy();
        this.createCommonCellStyle(cell, newCellStyle);
        this.units.put(key, newCellStyle);
        return newCellStyle;
    }

    private XSSFCellStyle createCommonCellStyle(Cell cell, XSSFCellStyle style) {
        CellStyleInfo styleInfo = cell.getStyleInfo();
        int[] bkcRGB = ColorUtils.toRGB(styleInfo.getBkc());
        if (bkcRGB != null && bkcRGB.length == 3) {
            XSSFColor color = new XSSFColor(new Color(bkcRGB[0], bkcRGB[1], bkcRGB[2]), (IndexedColorMap)new DefaultIndexedColorMap());
            style.setFillForegroundColor(color);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        int[] frcRGB = ColorUtils.toRGB(styleInfo.getFrc());
        XSSFFont font = this.xssfWB.createFont();
        if (frcRGB != null && frcRGB.length == 3) {
            XSSFColor color = new XSSFColor(new Color(frcRGB[0], frcRGB[1], frcRGB[2]), (IndexedColorMap)new DefaultIndexedColorMap());
            font.setColor(color);
        }
        font.setFontName(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"CellStyleUnit_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        font.setFontHeightInPoints((short)10);
        style.setFont((Font)font);
        style.setLocked(cell.isLock().booleanValue());
        int va = styleInfo.getHa();
        style.setAlignment(HorizontalAlignment.forInt((int)(va + 1)));
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFDataFormat dataFormat = this.xssfWB.createDataFormat();
        if (cell.getCellType() == CellTypeEnum.AMOUNT) {
            style.setDataFormat(dataFormat.getFormat("#,##0.00"));
            style.setAlignment(HorizontalAlignment.RIGHT);
        }
        if (cell.getLevel() > 0) {
            style.setIndention((short)cell.getLevel());
            style.setAlignment(HorizontalAlignment.LEFT);
        }
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        XSSFColor color = new XSSFColor();
        color.setRGB(new byte[]{-78, -78, -78});
        style.setTopBorderColor(color);
        style.setBottomBorderColor(color);
        style.setLeftBorderColor(color);
        style.setRightBorderColor(color);
        return style;
    }

    private String generateGroupKey(Cell cell) {
        ArrayList<String> flags = new ArrayList<String>(6);
        CellStyleInfo styleInfo = cell.getStyleInfo();
        int[] bkcRGBArrays = ColorUtils.toRGB(styleInfo.getBkc());
        String bkcRGB = "000";
        if (null != bkcRGBArrays) {
            bkcRGB = String.format("%1$d%2$d%3$d", bkcRGBArrays[0], bkcRGBArrays[1], bkcRGBArrays[2]);
        }
        flags.add(bkcRGB);
        int[] frcRGBArrays = ColorUtils.toRGB(styleInfo.getFrc());
        String frcRGB = "000";
        if (null != frcRGBArrays) {
            frcRGB = String.format("%1$d%2$d%3$d", frcRGBArrays[0], frcRGBArrays[1], frcRGBArrays[2]);
        }
        flags.add(frcRGB);
        if (cell.isLock().booleanValue()) {
            flags.add("lock");
        } else {
            flags.add("unlock");
        }
        int va = styleInfo.getHa();
        flags.add(String.format("%1$d", va));
        if (cell.getLevel() > 0) {
            flags.add("indent");
            flags.add(Integer.toString(cell.getLevel()));
        } else {
            flags.add("unindent");
        }
        if (cell.getCellType() == CellTypeEnum.AMOUNT) {
            flags.add("amount");
        }
        return flags.stream().collect(Collectors.joining("_"));
    }
}

