/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;
import kd.tmc.fpm.common.enums.PlanAmtVersionEnum;

public class PlanExecReportHeaderHelper
extends HeaderCreateHelper {
    private static final List<String> HEADER = new ArrayList<String>(7);

    public static void addExcelReportHeader(AnalysisHeader headerInfo, FundPlanSystem system, ReportCalcModel currReportCalcModel) {
        Optional<Dimension> settlementDimOpt;
        ReportValueType textType = PlanExecReportHeaderHelper.getValType(ReportCellType.TEXT, null);
        Map<Long, DimMember> dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(HEADER.size());
        for (int i = 0; i < HEADER.size(); ++i) {
            headerDescCalcVals.add(PlanExecReportHeaderHelper.createCalcVal(HEADER.get(i), textType, 0, i, false));
        }
        int row = 1;
        int col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(HEADER.size());
        ReportCalcVal systemCalcVal = PlanExecReportHeaderHelper.createCalcVal(system.getName(), textType, row, col++, true);
        headerValCalcVals.add(systemCalcVal);
        String currencyStr = "-";
        if (EmptyUtil.isNoEmpty(headerInfo.getCurrency())) {
            currencyStr = PlanExecReportHeaderHelper.getMemberStr(headerInfo.getCurrency(), dimMemberMap);
        }
        ReportCalcVal currencyCalcVal = PlanExecReportHeaderHelper.createCalcVal(currencyStr, textType, row, col++, true);
        headerValCalcVals.add(currencyCalcVal);
        String plannversion = headerInfo.getPlannversion().replaceAll(",", "");
        ReportCalcVal planVerCalcVal = PlanExecReportHeaderHelper.createCalcVal(PlanAmtVersionEnum.getNameByVal((String)plannversion), textType, row, col++, true);
        headerValCalcVals.add(planVerCalcVal);
        Long exchangeRateTableId = headerInfo.getExchangeRateTableId();
        String exchangeRateTableStr = "-";
        if (EmptyUtil.isNoEmpty((Long)exchangeRateTableId)) {
            DynamicObject exchangeRateTable = QueryServiceHelper.queryOne((String)"bd_exratetable", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)exchangeRateTableId)});
            exchangeRateTableStr = Optional.ofNullable(exchangeRateTable).map(o -> o.getString("name")).orElseGet(() -> "-");
        }
        ReportCalcVal exchangeRateTableCalcVal = PlanExecReportHeaderHelper.createCalcVal(exchangeRateTableStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateTableCalcVal);
        Date exchangeRateDate = headerInfo.getExchangeRateDate();
        String exchangeRateDateStr = Optional.ofNullable(exchangeRateDate).map(o -> DateUtils.formatString((Date)o, (String)"yyyy-MM-dd")).orElseGet(() -> "-");
        ReportCalcVal exchangeRateDateCalcVal = PlanExecReportHeaderHelper.createCalcVal(exchangeRateDateStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateDateCalcVal);
        AmountUnit amountUnit = headerInfo.getAmountUnit();
        ReportCalcVal amountUnitCalcVal = PlanExecReportHeaderHelper.createCalcVal(amountUnit.getName(), textType, row, col++, true);
        headerValCalcVals.add(amountUnitCalcVal);
        Optional<Dimension> companyDimOpt = PlanExecReportHeaderHelper.seekDim(DimensionType.COMPANY, system);
        if (companyDimOpt.isPresent()) {
            headerDescCalcVals.add(PlanExecReportHeaderHelper.createCalcVal(companyDimOpt.get().getName(), textType, 0, headerDescCalcVals.size(), false));
            String companyStr = "-";
            if (EmptyUtil.isNoEmpty(headerInfo.getCompany())) {
                companyStr = PlanExecReportHeaderHelper.getMemberStr(headerInfo.getCompany(), dimMemberMap);
            }
            ReportCalcVal companyCalcVal = PlanExecReportHeaderHelper.createCalcVal(companyStr, textType, row, col++, true);
            headerValCalcVals.add(companyCalcVal);
        }
        if ((settlementDimOpt = PlanExecReportHeaderHelper.seekDim(DimensionType.SETTLEMENT_TYPE, system)).isPresent()) {
            headerDescCalcVals.add(PlanExecReportHeaderHelper.createCalcVal(settlementDimOpt.get().getName(), textType, 0, headerDescCalcVals.size(), false));
            String settlementStr = "-";
            if (EmptyUtil.isNoEmpty(headerInfo.getSettlementMethod())) {
                settlementStr = PlanExecReportHeaderHelper.getMemberStr(headerInfo.getSettlementMethod(), dimMemberMap);
            }
            ReportCalcVal settlementCalcVal = PlanExecReportHeaderHelper.createCalcVal(settlementStr, textType, row, col++, true);
            headerValCalcVals.add(settlementCalcVal);
        }
        PlanExecReportHeaderHelper.addCustomCalcVals(headerDescCalcVals, headerValCalcVals, row, col, system, headerInfo, dimMemberMap);
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + 3));
        extValList.addAll(headerDescCalcVals);
        extValList.addAll(headerValCalcVals);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        currReportCalcModel.setRowOffset(currReportCalcModel.getRowOffset() + 3);
    }

    static {
        HEADER.add(ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"PlanExecFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"PlanExecFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u8ba1\u5212\u989d\u5ea6\u7248\u672c", (String)"PlanExecFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"PlanExecFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f", (String)"PlanExecFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"PlanExecFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
    }
}

