/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;

public class SumPlanHeaderHelper
extends HeaderCreateHelper {
    private static final String[] HEADER = new String[]{ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"SumPlanReportFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b", (String)"SumPlanReportFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53", (String)"SumPlanReportFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u62a5\u671f\u95f4", (String)"SumPlanReportFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u586b\u62a5\u4eba", (String)"SumPlanReportFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"SumPlanReportFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"SumPlanReportFormsExportAction_6", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62b5\u6d88\u72b6\u6001", (String)"SumPlanReportFormsExportAction_7", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807", (String)"SumPlanReportFormsExportAction_8", (String)"tmc-fpm-business", (Object[])new Object[0])};

    public static void addExcelReportHeader(Report report, FundPlanSystem system, ReportCalcModel currReportCalcModel) {
        Map<Long, DimMember> dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        SumPlanReport rep = (SumPlanReport)report;
        ReportTemplate template = rep.getTemplate();
        ReportValueType valType = SumPlanHeaderHelper.getValType(ReportCellType.TEXT, null);
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(HEADER.length);
        for (int i = 0; i < HEADER.length; ++i) {
            headerDescCalcVals.add(SumPlanHeaderHelper.createCalcVal(HEADER[i], valType, 0, i, false));
        }
        int row = 1;
        int col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(HEADER.length);
        ReportCalcVal reportNameCalcVal = SumPlanHeaderHelper.createCalcVal(template.getName(), valType, row, col++, true);
        headerValCalcVals.add(reportNameCalcVal);
        boolean mainTable = template.isMainTable();
        String reportTypeStr = mainTable ? ResManager.loadKDString((String)"\u4e3b\u8868", (String)"SumPlanReportFormsExportAction_9", (String)"tmc-fpm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b50\u8868", (String)"SumPlanReportFormsExportAction_10", (String)"tmc-fpm-business", (Object[])new Object[0]);
        ReportCalcVal reportTypeCalcVal = SumPlanHeaderHelper.createCalcVal(reportTypeStr, valType, row, col++, true);
        headerValCalcVals.add(reportTypeCalcVal);
        List<OrgMember> companyMemberLst = rep.getCompanyMemberList();
        String mainBody = "-";
        if (EmptyUtil.isNoEmpty(companyMemberLst)) {
            mainBody = companyMemberLst.get(0).getName();
        }
        ReportCalcVal mainBodyCalcVal = SumPlanHeaderHelper.createCalcVal(mainBody, valType, row, col++, true);
        headerValCalcVals.add(mainBodyCalcVal);
        List<PeriodMember> periodMemberLst = rep.getPeriodMemberList();
        String periodStr = "-";
        if (EmptyUtil.isNoEmpty(periodMemberLst)) {
            periodStr = periodMemberLst.get(0).getName();
        }
        ReportCalcVal periodCalcVal = SumPlanHeaderHelper.createCalcVal(periodStr, valType, row, col++, true);
        headerValCalcVals.add(periodCalcVal);
        String informant = rep.getInformanStr();
        ReportCalcVal informantCalcVal = SumPlanHeaderHelper.createCalcVal(informant, valType, row, col++, true);
        headerValCalcVals.add(informantCalcVal);
        String amountUnit = template.getAmountUnit().getName();
        ReportCalcVal amountUnitCalcVal = SumPlanHeaderHelper.createCalcVal(amountUnit, valType, row, col++, true);
        headerValCalcVals.add(amountUnitCalcVal);
        String status = String.format("%s/%s", rep.getProcessStatus().getName(), rep.getReportStatus().getName());
        ReportCalcVal statusCalcVal = SumPlanHeaderHelper.createCalcVal(status, valType, row, col++, true);
        headerValCalcVals.add(statusCalcVal);
        boolean innerOffset = rep.isInnerOffset();
        String innerOffsetName = innerOffset ? ResManager.loadKDString((String)"\u62b5\u6d88\u540e", (String)"SumPlanReportFormsExportAction_11", (String)"tmc-fpm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62b5\u6d88\u524d", (String)"SumPlanReportFormsExportAction_12", (String)"tmc-fpm-business", (Object[])new Object[0]);
        ReportCalcVal innerOffsetCalcVal = SumPlanHeaderHelper.createCalcVal(innerOffsetName, valType, row, col++, true);
        headerValCalcVals.add(innerOffsetCalcVal);
        List<Long> metricMemberIds = template.getMetricTplDim().getMemberScope();
        String metricMemberStr = SumPlanHeaderHelper.getMemberStr(metricMemberIds, dimMemberMap);
        ReportCalcVal metricMemberVal = SumPlanHeaderHelper.createCalcVal(metricMemberStr, valType, row, col++, true);
        headerValCalcVals.add(metricMemberVal);
        ArrayList<ReportCalcVal> tempHeaderDescCalcValLst = new ArrayList<ReportCalcVal>(headerDescCalcVals);
        ArrayList<ReportCalcVal> tempHeaderValCalcValLst = new ArrayList<ReportCalcVal>(headerValCalcVals);
        List<ReportCalcVal> pageDims = currReportCalcModel.getPageDimValList();
        if (EmptyUtil.isNoEmpty(pageDims)) {
            for (ReportCalcVal pageDim : pageDims) {
                tempHeaderDescCalcValLst.add(SumPlanHeaderHelper.createCalcVal(pageDim.getDimensionName(), valType, 0, col, false));
                tempHeaderValCalcValLst.add(SumPlanHeaderHelper.createCalcVal(pageDim.getDisplayVal(), valType, 1, col, true));
                ++col;
            }
        }
        tempHeaderDescCalcValLst.add(SumPlanHeaderHelper.createCalcVal(ResManager.loadKDString((String)"\u6298\u7b97\u5e01", (String)"PlanReportFormsExportAction_10", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, 0, col, false));
        String currencyName = system.getCurrencyName();
        ReportCalcVal currencyNameVal = SumPlanHeaderHelper.createCalcVal(currencyName, valType, row, col, true);
        tempHeaderValCalcValLst.add(currencyNameVal);
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + 3));
        extValList.addAll(tempHeaderDescCalcValLst);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + 3));
        dataValList.addAll(tempHeaderValCalcValLst);
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
    }
}

