/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;

public class SumSubReportHeaderHelper
extends HeaderCreateHelper {
    private static final List<String> HEADER = new ArrayList<String>(7);

    public static void addExcelReportHeader(AnalysisHeader headerInfo, FundPlanSystem system, ReportCalcModel currReportCalcModel) {
        ReportValueType textType = SumSubReportHeaderHelper.getValType(ReportCellType.TEXT, null);
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(HEADER.size());
        for (int i = 0; i < HEADER.size(); ++i) {
            headerDescCalcVals.add(SumSubReportHeaderHelper.createCalcVal(HEADER.get(i), textType, 0, i, false));
        }
        int row = 1;
        int col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(HEADER.size());
        String sumReportOrgName = system.getMainDimensionByDimType(DimensionType.ORG).getDimMemberById(headerInfo.getSumReportOrg()).getName();
        ReportCalcVal sumReportOrgNameCalcVal = SumSubReportHeaderHelper.createCalcVal(sumReportOrgName, textType, row, col++, true);
        headerValCalcVals.add(sumReportOrgNameCalcVal);
        Long reportPeriodId = headerInfo.getPeriodId().get(0);
        String reportPeriodName = system.getMainDimensionByDimType(DimensionType.PERIOD).getDimMemberById(reportPeriodId).getName();
        ReportCalcVal reportPeriodNameCalcVal = SumSubReportHeaderHelper.createCalcVal(reportPeriodName, textType, row, col++, true);
        headerValCalcVals.add(reportPeriodNameCalcVal);
        List<Long> currencyIds = headerInfo.getCurrency();
        String currencyStr = "-";
        if (EmptyUtil.isNoEmpty(currencyIds)) {
            List<DimMember> allCurrencyMemberList = system.getMainDimensionByDimType(DimensionType.CURRENCY).getAllDimMemberList();
            HashSet<Long> currencyIdSet = new HashSet<Long>(currencyIds);
            currencyStr = allCurrencyMemberList.stream().filter(member -> currencyIdSet.contains(member.getId())).map(DimMember::getName).collect(Collectors.joining(";"));
        }
        ReportCalcVal currencyCalcVal = SumSubReportHeaderHelper.createCalcVal(currencyStr, textType, row, col++, true);
        headerValCalcVals.add(currencyCalcVal);
        String conversionCurrencyName = system.getCurrencyName();
        ReportCalcVal conversionCurrencyCalcVal = SumSubReportHeaderHelper.createCalcVal(conversionCurrencyName, textType, row, col++, true);
        headerValCalcVals.add(conversionCurrencyCalcVal);
        Long exchangeRateTableId = headerInfo.getExchangeRateTableId();
        String exchangeRateTableStr = "-";
        if (EmptyUtil.isNoEmpty((Long)exchangeRateTableId)) {
            DynamicObject exchangeRateTable = TmcDataServiceHelper.loadSingleFromCache((Object)exchangeRateTableId, (String)"bd_exratetable");
            exchangeRateTableStr = Optional.ofNullable(exchangeRateTable).map(o -> o.getString("name")).orElseGet(() -> "-");
        }
        ReportCalcVal exchangeRateTableCalcVal = SumSubReportHeaderHelper.createCalcVal(exchangeRateTableStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateTableCalcVal);
        Date exchangeRateDate = headerInfo.getExchangeRateDate();
        String exchangeRateDateStr = Optional.ofNullable(exchangeRateDate).map(o -> DateUtils.formatString((Date)o, (String)"yyyy-MM-dd")).orElseGet(() -> "-");
        ReportCalcVal exchangeRateDateCalcVal = SumSubReportHeaderHelper.createCalcVal(exchangeRateDateStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateDateCalcVal);
        AmountUnit amountUnit = headerInfo.getAmountUnit();
        ReportCalcVal amountUnitCalcVal = SumSubReportHeaderHelper.createCalcVal(amountUnit.getName(), textType, row, col++, true);
        headerValCalcVals.add(amountUnitCalcVal);
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + 3));
        extValList.addAll(headerDescCalcVals);
        extValList.addAll(headerValCalcVals);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
    }

    static {
        HEADER.add(ResManager.loadKDString((String)"\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53", (String)"SumSubReportHeaderHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u7f16\u62a5\u671f\u95f4", (String)"SumSubReportHeaderHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u6c47\u603b\u5e01\u79cd", (String)"SumSubReportHeaderHelper_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u6298\u7b97\u5e01", (String)"SumSubReportHeaderHelper_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"SumSubReportHeaderHelper_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f", (String)"SumSubReportHeaderHelper_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER.add(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"SumSubReportHeaderHelper_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
    }
}

