/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;
import kd.tmc.fpm.common.enums.PlanAmtVersionEnum;

public class SummaryReportHeaderHelper
extends HeaderCreateHelper {
    private static List<String> REPORT_SUMMARY_HEADER = new ArrayList<String>(){
        {
            this.add(ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"SummaryFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u8ba1\u5212\u79d1\u76ee", (String)"SummaryFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"SummaryFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u8ba1\u5212\u989d\u5ea6\u7248\u672c", (String)"SummaryFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"SummaryFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f", (String)"SummaryFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"SummaryFormsExportAction_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    };

    public static void addExcelSummaryReportHeader(ReportCalcModel currReportCalcModel, FundPlanSystem system, AnalysisHeader headerInfo) {
        Optional<Dimension> settlementOP;
        Integer n;
        Serializable currencyDim;
        Serializable subjectDim;
        ReportValueType textType = SummaryReportHeaderHelper.getValType(ReportCellType.TEXT, null);
        Map<Long, DimMember> dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(REPORT_SUMMARY_HEADER.size());
        for (int i2 = 0; i2 < REPORT_SUMMARY_HEADER.size(); ++i2) {
            headerDescCalcVals.add(SummaryReportHeaderHelper.createCalcVal(REPORT_SUMMARY_HEADER.get(i2), textType, 0, i2, false));
        }
        Integer row = 1;
        Integer col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(REPORT_SUMMARY_HEADER.size());
        Integer n2 = col;
        Integer n3 = col = Integer.valueOf(col + 1);
        ReportCalcVal systemCalcVal = SummaryReportHeaderHelper.createCalcVal(system.getName(), textType, row, n2, true);
        headerValCalcVals.add(systemCalcVal);
        List<Long> acctIds = headerInfo.getSubjects();
        String acctInfoStr = "-";
        if (EmptyUtil.isNoEmpty(acctIds)) {
            HashSet<Long> idSet = new HashSet<Long>(acctIds);
            subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            acctInfoStr = ((Dimension)subjectDim).getAllDimMemberList().stream().filter(i -> idSet.contains(i.getId())).map(DimMember::getName).collect(Collectors.joining(","));
        }
        subjectDim = col;
        Integer n4 = col = Integer.valueOf(col + 1);
        ReportCalcVal acctInfoCalcVal = SummaryReportHeaderHelper.createCalcVal(acctInfoStr, textType, row, (Integer)subjectDim, true);
        headerValCalcVals.add(acctInfoCalcVal);
        List<Long> currencyIds = headerInfo.getCurrency();
        String currencyStr = "-";
        if (EmptyUtil.isNoEmpty(currencyIds)) {
            HashSet<Long> idSet = new HashSet<Long>(currencyIds);
            currencyDim = system.getMainDimensionByDimType(DimensionType.CURRENCY);
            currencyStr = ((Dimension)currencyDim).getAllDimMemberList().stream().filter(i -> idSet.contains(i.getId())).map(DimMember::getName).collect(Collectors.joining(","));
        }
        currencyDim = col;
        Integer n5 = col = Integer.valueOf(col + 1);
        ReportCalcVal currencyCalcVal = SummaryReportHeaderHelper.createCalcVal(currencyStr, textType, row, (Integer)currencyDim, true);
        headerValCalcVals.add(currencyCalcVal);
        String plannversion = headerInfo.getPlannversion().replaceAll(",", "");
        Integer n6 = col;
        Integer n7 = col = Integer.valueOf(col + 1);
        ReportCalcVal planVerCalcVal = SummaryReportHeaderHelper.createCalcVal(PlanAmtVersionEnum.getNameByVal((String)plannversion), textType, row, n6, true);
        headerValCalcVals.add(planVerCalcVal);
        Long exchangeRateTableId = headerInfo.getExchangeRateTableId();
        String exchangeRateTableStr = "-";
        if (EmptyUtil.isNoEmpty((Long)exchangeRateTableId)) {
            DynamicObject exchangeRateTable = TmcDataServiceHelper.loadSingle((String)"bd_exratetable", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)exchangeRateTableId)});
            exchangeRateTableStr = Optional.ofNullable(exchangeRateTable).map(o -> o.getString("name")).orElseGet(() -> "-");
        }
        Integer n8 = col;
        Integer n9 = col = Integer.valueOf(col + 1);
        ReportCalcVal exchangeRateTableCalcVal = SummaryReportHeaderHelper.createCalcVal(exchangeRateTableStr, textType, row, n8, true);
        headerValCalcVals.add(exchangeRateTableCalcVal);
        Date exchangeRateDate = headerInfo.getExchangeRateDate();
        String exchangeRateDateStr = Optional.ofNullable(exchangeRateDate).map(o -> DateUtils.formatString((Date)o, (String)"yyyy-MM-dd")).orElseGet(() -> "-");
        Integer n10 = col;
        Integer n11 = col = Integer.valueOf(col + 1);
        ReportCalcVal exchangeRateDateCalcVal = SummaryReportHeaderHelper.createCalcVal(exchangeRateDateStr, textType, row, n10, true);
        headerValCalcVals.add(exchangeRateDateCalcVal);
        AmountUnit amountUnit = headerInfo.getAmountUnit();
        Integer n12 = col;
        Integer n13 = col = Integer.valueOf(col + 1);
        ReportCalcVal amountUnitCalcVal = SummaryReportHeaderHelper.createCalcVal(amountUnit.getName(), textType, row, n12, true);
        headerValCalcVals.add(amountUnitCalcVal);
        Optional<Dimension> companyDimOP = SummaryReportHeaderHelper.seekDim(DimensionType.COMPANY, system);
        if (companyDimOP.isPresent()) {
            String companyStr = "-";
            Dimension companyDimension = companyDimOP.get();
            headerDescCalcVals.add(SummaryReportHeaderHelper.createCalcVal(companyDimension.getName(), textType, 0, headerDescCalcVals.size(), false));
            if (EmptyUtil.isNoEmpty(headerInfo.getCompany())) {
                companyStr = SummaryReportHeaderHelper.getMemberStr(headerInfo.getCompany(), dimMemberMap);
            }
            Integer n14 = col;
            n = col = Integer.valueOf(col + 1);
            ReportCalcVal companyCalcVal = SummaryReportHeaderHelper.createCalcVal(companyStr, textType, row, n14, true);
            headerValCalcVals.add(companyCalcVal);
        }
        if ((settlementOP = SummaryReportHeaderHelper.seekDim(DimensionType.SETTLEMENT_TYPE, system)).isPresent()) {
            Dimension settlementDimension = settlementOP.get();
            headerDescCalcVals.add(SummaryReportHeaderHelper.createCalcVal(settlementDimension.getName(), textType, 0, headerDescCalcVals.size(), false));
            String settlementStr = "-";
            if (EmptyUtil.isNoEmpty(headerInfo.getSettlementMethod())) {
                settlementStr = SummaryReportHeaderHelper.getMemberStr(headerInfo.getSettlementMethod(), dimMemberMap);
            }
            n = col;
            Integer n15 = col = Integer.valueOf(col + 1);
            ReportCalcVal settlementCalcVal = SummaryReportHeaderHelper.createCalcVal(settlementStr, textType, row, n, true);
            headerValCalcVals.add(settlementCalcVal);
        }
        SummaryReportHeaderHelper.addCustomCalcVals(headerDescCalcVals, headerValCalcVals, row, col, system, headerInfo, dimMemberMap);
        SummaryReportHeaderHelper.addToExtraValueList(currReportCalcModel, headerDescCalcVals, headerValCalcVals);
    }

    private static void addToExtraValueList(ReportCalcModel currReportCalcModel, List<ReportCalcVal> headerDescCalcVals, List<ReportCalcVal> headerValCalcVals) {
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + 3));
        extValList.addAll(headerDescCalcVals);
        extValList.addAll(headerValCalcVals);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
    }
}

