/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.mvc.repository.IReportPlanRepository;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaCalculatorFactory;
import kd.tmc.fpm.business.spread.formula.IFormulaCalculator;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ReCalculateNodeVisitListener
implements DAGNodeVisitListener<String> {
    private static final Log logger = LogFactory.getLog(ReCalculateNodeVisitListener.class);
    private Set<ReportCalcVal> reCalcValSet;
    private IFormulaCalculator calculator = FormulaCalculatorFactory.createFormulaCalculator();
    private IReportPlanRepository repository;
    private List<ReportCalcVal> reportCalcValList;
    private Map<String, ReportCalcVal> reportCalcValMap;

    private ReCalculateNodeVisitListener() {
        this.reCalcValSet = new HashSet<ReportCalcVal>(10);
    }

    public ReCalculateNodeVisitListener(IReportPlanRepository repository) {
        this();
        this.repository = repository;
    }

    public ReCalculateNodeVisitListener(IReportPlanRepository repository, List<ReportCalcVal> reportCalcValList) {
        this();
        this.repository = repository;
        this.reportCalcValList = reportCalcValList;
        this.reportCalcValMap = reportCalcValList.stream().collect(Collectors.toMap(rd -> rd.getRow() + "_" + rd.getCol(), Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public void visit(DAGNode<String> node) {
        String crood = node.getVal();
        if (NumberUtils.isNumber((String)crood)) {
            return;
        }
        int col = ExcelUtils.pos2X((String)crood);
        int row = ExcelUtils.pos2Y((String)crood);
        ReportCalcVal reportCalcVal = this.reportCalcValMap == null || this.reportCalcValMap.isEmpty() ? this.repository.getCurrRowColData(row, col) : this.reportCalcValMap.get(row + "_" + col);
        if (reportCalcVal != null) {
            Formula formula = reportCalcVal.getFormula();
            if (formula != null) {
                BigDecimal val = null;
                val = CollectionUtils.isEmpty(this.reportCalcValList) ? this.calculator.calculate(formula, this.repository) : this.calculator.calculate(formula, this.reportCalcValMap);
                reportCalcVal.setValue(val);
                reportCalcVal.setDisplayVal(val == null ? null : val.toString());
                if (this.repository != null) {
                    this.repository.updateReportCalcVal(Collections.singletonList(reportCalcVal));
                }
                this.reCalcValSet.add(reportCalcVal);
            }
        } else {
            logger.info(String.format("%s \u5355\u5143\u683c\u7684\u4e8c\u7ef4\u6a21\u578b ReportCalcVal = null\uff0c\u65e0\u6cd5\u53c2\u4e0e\u516c\u5f0f\u8ba1\u7b97\u3002", crood));
        }
    }

    public Set<ReportCalcVal> getReCalcValSet() {
        return this.reCalcValSet;
    }
}

