/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.IDAGVisit;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;
import kd.tmc.fpm.business.spread.formula.impl.DAGVisit;

public class CacheDAGVisit<T>
implements IDAGVisit<T>,
Serializable {
    private IDAGVisit<T> dagVisit;
    private Set<String> cacheKeySet;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("CacheDAGVisit");
    private String serializeKey;

    public CacheDAGVisit() {
    }

    public CacheDAGVisit(IDAGManager<T> dagManager) {
        this.dagVisit = new DAGVisit<T>(dagManager);
        this.serializeKey = System.currentTimeMillis() + "";
        this.cacheKeySet = new HashSet<String>();
        this.cacheVertexMap();
    }

    @Override
    public void addNodeVisitListener(DAGNodeVisitListener<T> listener) {
        this.dagVisit.addNodeVisitListener(listener);
    }

    @Override
    public void visitNode(DAGNode<T> startNode, boolean isFirstVisit) {
        this.dagVisit.visitNode(startNode, isFirstVisit);
    }

    @Override
    public void orderVisitNode(DAGNode<T> startNode) {
        this.dagVisit.orderVisitNode(startNode);
    }

    @Override
    public void orderVisitNode(DAGNode<T> startNode, boolean ignoreCurrentNode) {
        this.dagVisit.orderVisitNode(startNode, ignoreCurrentNode);
    }

    @Override
    public void visitAllNodes(boolean isFirstVisit) {
        this.dagVisit.visitAllNodes(isFirstVisit);
    }

    @Override
    public DAGNode<T> get(T val) {
        DAGNode<T> node = this.dagVisit.get(val);
        return node;
    }

    private void cacheVertexMap() {
    }

    private void addCacheField(Map.Entry<String, List<String>> next) {
        cache.addList(next.getKey(), next.getValue().toArray(new String[0]), CacheKeyUtil.getPageCacheKeyTimeout());
    }

    private int getVertexMapIndex(T key) {
        int hashCode = key.hashCode();
        return hashCode % 10;
    }

    private String getVertexMapCacheKey(T key) {
        int vertexMapIndex = this.getVertexMapIndex(key);
        String currCacheKey = String.format("%s#%s", this.serializeKey, vertexMapIndex);
        this.cacheKeySet.add(currCacheKey);
        return currCacheKey;
    }

    public IDAGVisit<T> getDagVisit() {
        return this.dagVisit;
    }

    public void setDagVisit(IDAGVisit<T> dagVisit) {
        this.dagVisit = dagVisit;
    }

    public Set<String> getCacheKeySet() {
        return this.cacheKeySet;
    }

    public void setCacheKeySet(Set<String> cacheKeySet) {
        this.cacheKeySet = cacheKeySet;
    }

    public static DistributeSessionlessCache getCache() {
        return cache;
    }

    public static void setCache(DistributeSessionlessCache cache) {
        CacheDAGVisit.cache = cache;
    }

    public String getSerializeKey() {
        return this.serializeKey;
    }

    public void setSerializeKey(String serializeKey) {
        this.serializeKey = serializeKey;
    }

    @Override
    public void destroy() {
        cache.remove(this.cacheKeySet.toArray(new String[0]));
    }
}

