/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.mvc.repository.IReportPlanRepository;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.IDAGVisit;
import kd.tmc.fpm.business.spread.formula.IFormulaCalculator;
import kd.tmc.fpm.business.spread.formula.IFormulaManager;
import kd.tmc.fpm.business.spread.formula.ReCalculateNodeVisitListener;
import kd.tmc.fpm.business.spread.formula.impl.CacheDAGManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGVisit;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.utils.ExcelUtils;

public class DAGFormulaManager
implements IFormulaManager,
Serializable {
    private IDAGManager<String> dagManager;
    private transient IDAGVisit<String> dagVisit;
    private transient IFormulaCalculator calculator;

    private DAGFormulaManager() {
    }

    public DAGFormulaManager(ReportCalcModel reportCalcModel, IReportPlanRepository repository) {
        this();
        this.batchCacheHandle(reportCalcModel, repository);
    }

    public final void batchCacheHandle(ReportCalcModel reportCalcModel, IReportPlanRepository repository) {
        CacheDAGManager<String> cacheDAGManager = new CacheDAGManager<String>();
        this.dagManager = cacheDAGManager;
        this.initFormulaDAGGraphPrivate(reportCalcModel, repository);
        cacheDAGManager.batchCacheHandle();
    }

    @Override
    public List<ReportCalcVal> updateData(ReportCalcVal updateVal, IReportPlanRepository repository) {
        String coord = ExcelUtils.xy2Pos((int)updateVal.getCol(), (int)updateVal.getRow());
        if (this.dagManager instanceof CacheDAGManager) {
            ((CacheDAGManager)this.dagManager).rebuild();
        }
        this.dagVisit = new DAGVisit<String>(this.dagManager);
        DAGNode<String> changeNode = this.dagManager.get(coord);
        if (changeNode == null) {
            return null;
        }
        ReportCalcVal currRowColData = repository.getCurrRowColData(updateVal.getRow(), updateVal.getCol());
        currRowColData.setValue(updateVal.getValue());
        repository.updateReportCalcVal(Collections.singletonList(currRowColData));
        ReCalculateNodeVisitListener listener = new ReCalculateNodeVisitListener(repository);
        this.dagVisit.addNodeVisitListener(listener);
        this.dagVisit.orderVisitNode(changeNode);
        Set<ReportCalcVal> reCalcValSet = listener.getReCalcValSet();
        return new ArrayList<ReportCalcVal>(reCalcValSet);
    }

    @Override
    public String serialize() {
        return FpmSerializeUtil.serialize((Object)this);
    }

    @Override
    public void destroy() {
        this.dagManager.destroy();
    }

    @Override
    public void updateAllData(ReportCalcModel reportCalcModel, IReportPlanRepository repository) {
        this.dagVisit = new DAGVisit<String>(this.dagManager);
        ReCalculateNodeVisitListener listener = new ReCalculateNodeVisitListener(repository, reportCalcModel.getDataValList());
        this.dagVisit.addNodeVisitListener(listener);
        this.dagVisit.visitAllNodes(false);
    }

    public void initFormulaDAGGraph(ReportCalcModel reportCalcModel, IReportPlanRepository repository) {
        this.initFormulaDAGGraphPrivate(reportCalcModel, repository);
    }

    private void initFormulaDAGGraphPrivate(ReportCalcModel reportCalcModel, IReportPlanRepository repository) {
        List<ReportCalcVal> dataValList = this.getReportCalcValList(reportCalcModel);
        this.dagVisit = new DAGVisit<String>(this.dagManager);
        ReCalculateNodeVisitListener listener = new ReCalculateNodeVisitListener(repository, dataValList);
        this.dagVisit.addNodeVisitListener(listener);
        this.dagVisit.visitAllNodes(false);
    }

    protected List<ReportCalcVal> getReportCalcValList(ReportCalcModel reportCalcModel) {
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        for (ReportCalcVal reportCalcVal : dataValList) {
            if (reportCalcVal.getFormula() == null) continue;
            this.initOrUpdateFormulaDAGGraphRelation(reportCalcVal);
        }
        return dataValList;
    }

    protected void initOrUpdateFormulaDAGGraphRelation(ReportCalcVal reportCalcVal) {
        if (reportCalcVal.getFormula() == null) {
            return;
        }
        Formula formula = reportCalcVal.getFormula();
        FormulaOperationVal leftOperation = formula.getLeftVal();
        List<FormulaOperationVal> rightOperationLst = formula.getRightValList();
        String leftOperationName = leftOperation.getName();
        for (FormulaOperationVal formulaOperation : rightOperationLst) {
            this.dagManager.get(leftOperationName).addEdge(new DAGEdge<String>(this.dagManager.get(formulaOperation.getName())));
        }
    }

    public IFormulaCalculator getCalculator() {
        return this.calculator;
    }

    public void setCalculator(IFormulaCalculator calculator) {
        this.calculator = calculator;
    }

    public IDAGManager<String> getDagManager() {
        return this.dagManager;
    }

    public void setDagManager(IDAGManager<String> dagManager) {
        this.dagManager = dagManager;
    }

    public IDAGVisit<String> getDagVisit() {
        return this.dagVisit;
    }

    public void setDagVisit(IDAGVisit<String> dagVisit) {
        this.dagVisit = dagVisit;
    }

    public static void visitAll(ReportCalcModel calcModel, IReportPlanRepository repository) {
        DAGFormulaManager dagFormulaManager = new DAGFormulaManager();
        dagFormulaManager.batchCacheHandle(calcModel, repository);
    }
}

