/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.formula.CalculateCellDataVisitListener;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.IDAGVisit;
import kd.tmc.fpm.business.spread.formula.IFormulaCalculator;
import kd.tmc.fpm.business.spread.formula.IFormulaManagerV2;
import kd.tmc.fpm.business.spread.formula.ReCalculateNodeVisitListenerV2;
import kd.tmc.fpm.business.spread.formula.impl.CacheDAGManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGVisit;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.utils.ExcelUtils;

public class DAGFormulaManagerV2
implements IFormulaManagerV2,
Serializable {
    private IDAGManager<String> dagManager;
    private transient IDAGVisit<String> dagVisit;
    private transient IFormulaCalculator calculator;

    private DAGFormulaManagerV2() {
    }

    public DAGFormulaManagerV2(ReportCalcModel reportCalcModel) {
        this(reportCalcModel, true);
    }

    public DAGFormulaManagerV2(ReportCalcModel reportCalcModel, Boolean visitAllNode) {
        this();
        this.batchCacheHandle(reportCalcModel, visitAllNode);
    }

    public final void batchCacheHandle(ReportCalcModel reportCalcModel, Boolean visitAllNode) {
        CacheDAGManager<String> cacheDAGManager = new CacheDAGManager<String>();
        this.dagManager = cacheDAGManager;
        this.initFormulaDAGGraphPrivate(reportCalcModel, visitAllNode);
        cacheDAGManager.batchCacheHandle();
    }

    @Override
    public List<CacheCell> updateData(CacheCell cacheCell, CellDataSource dataSource) {
        String coord = ExcelUtils.xy2Pos((int)cacheCell.getCol(), (int)cacheCell.getRow());
        if (this.dagManager instanceof CacheDAGManager) {
            ((CacheDAGManager)this.dagManager).rebuild();
        }
        this.dagVisit = new DAGVisit<String>(this.dagManager);
        DAGNode<String> changeNode = this.dagManager.get(coord);
        if (changeNode == null) {
            return null;
        }
        CacheCell cell = dataSource.getCell(cacheCell.getRow(), cacheCell.getCol());
        cell.setValue(cacheCell.getValue());
        CalculateCellDataVisitListener listener = new CalculateCellDataVisitListener(dataSource);
        this.dagVisit.addNodeVisitListener(listener);
        this.dagVisit.orderVisitNode(changeNode);
        Set<CacheCell> reCacheCellSet = listener.getReCacheCellSet();
        return new ArrayList<CacheCell>(reCacheCellSet);
    }

    @Override
    public String serialize() {
        return FpmSerializeUtil.serializeJson((Object)this);
    }

    @Override
    public void destroy() {
        this.dagManager.destroy();
    }

    private void initFormulaDAGGraphPrivate(ReportCalcModel reportCalcModel, Boolean visitAllNode) {
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        for (ReportCalcVal reportCalcVal : dataValList) {
            if (reportCalcVal.getFormula() == null) continue;
            this.initOrUpdateFormulaDAGGraphRelation(reportCalcVal);
        }
        this.dagVisit = new DAGVisit<String>(this.dagManager);
        ReCalculateNodeVisitListenerV2 listener = new ReCalculateNodeVisitListenerV2(reportCalcModel, visitAllNode == false);
        this.dagVisit.addNodeVisitListener(listener);
        this.dagVisit.visitAllNodes(false);
    }

    private void initOrUpdateFormulaDAGGraphRelation(ReportCalcVal reportCalcVal) {
        if (reportCalcVal.getFormula() == null) {
            return;
        }
        Formula formula = reportCalcVal.getFormula();
        FormulaOperationVal leftOperation = formula.getLeftVal();
        List<FormulaOperationVal> rightOperationLst = formula.getRightValList();
        String leftOperationName = leftOperation.getName();
        for (FormulaOperationVal formulaOperation : rightOperationLst) {
            this.dagManager.get(leftOperationName).addEdge(new DAGEdge<String>(this.dagManager.get(formulaOperation.getName())));
        }
        if (!formula.isSummary()) {
            this.dagManager.get(leftOperationName).setFormula(formula);
        }
    }

    public IFormulaCalculator getCalculator() {
        return this.calculator;
    }

    public void setCalculator(IFormulaCalculator calculator) {
        this.calculator = calculator;
    }

    public IDAGManager<String> getDagManager() {
        return this.dagManager;
    }

    public void setDagManager(IDAGManager<String> dagManager) {
        this.dagManager = dagManager;
    }

    public IDAGVisit<String> getDagVisit() {
        return this.dagVisit;
    }

    public void setDagVisit(IDAGVisit<String> dagVisit) {
        this.dagVisit = dagVisit;
    }

    public static void visitAll(ReportCalcModel calcModel) {
        DAGFormulaManagerV2 dagFormulaManagerV2 = new DAGFormulaManagerV2();
        dagFormulaManagerV2.batchCacheHandle(calcModel, true);
    }
}

