/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGCircleException;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGVisit;

public class DAGManager<T>
implements IDAGManager<T>,
Serializable {
    private Set<DAGNode<T>> headSet;
    private transient Set<DAGNode<T>> revertHeadSet;
    private transient Map<T, DAGNode<T>> vertexMap;
    private transient Map<T, DAGNode<T>> reversedMap;
    private transient List<DAGNode<T>> orderedList;
    private transient boolean reset = false;

    public DAGManager() {
        this.vertexMap = new HashMap<T, DAGNode<T>>(8);
        this.headSet = new HashSet<DAGNode<T>>(8);
    }

    public DAGManager(Map<T, DAGNode<T>> vertexMap) {
        this.vertexMap = vertexMap;
        this.headSet = new HashSet<DAGNode<T>>(8);
    }

    @Override
    public void rebuild(Set<DAGNode<T>> headSet) {
        for (DAGNode<T> head : headSet) {
            this.putAllNodes(head);
        }
        this.reset();
    }

    private void putAllNodes(DAGNode<T> node) {
        this.vertexMap.put(node.getVal(), node);
        for (DAGEdge<T> edge : node.getEdges()) {
            this.putAllNodes(edge.getDestNode());
        }
        this.reset = true;
    }

    @Override
    public void put(DAGNode<T> node) {
        this.vertexMap.put(node.getVal(), node);
        this.reset = true;
    }

    @Override
    public DAGNode<T> get(T val) {
        DAGNode<T> node = this.vertexMap.get(val);
        if (node == null) {
            node = new DAGNode<T>(val);
            this.vertexMap.put(node.getVal(), node);
            this.reset = true;
        }
        return node;
    }

    @Override
    public boolean exist(T val) {
        DAGNode<T> node = this.vertexMap.get(val);
        boolean exist = true;
        if (node == null) {
            exist = false;
        }
        return exist;
    }

    @Override
    public Map<T, DAGNode<T>> getVertexMap() {
        this.reset();
        return Collections.unmodifiableMap(this.vertexMap);
    }

    @Override
    public Map<T, DAGNode<T>> getRevertMap() {
        this.reset();
        if (this.reversedMap == null) {
            this.reverseMap();
        }
        return Collections.unmodifiableMap(this.reversedMap);
    }

    @Override
    public List<DAGNode<T>> getOrderedList() {
        this.reset();
        if (this.orderedList == null) {
            this.orderMap();
        }
        return Collections.unmodifiableList(this.orderedList);
    }

    @Override
    public DAGNode<T> getByRevertMap(T val) {
        return this.getRevertMap().get(val);
    }

    private void reset() {
        if (!this.reset) {
            return;
        }
        this.reset = false;
        this.headSet.clear();
        for (DAGNode<T> node : this.vertexMap.values()) {
            Set<DAGEdge<T>> edges = node.getEdges();
            if (edges == null || edges.size() == 0) continue;
            this.headSet.add(node);
        }
        this.checkCycle();
        HashSet visitedSet = new HashSet();
        for (DAGNode<T> node : this.vertexMap.values()) {
            this.calcNodeWeightAndEdgeLen(node, visitedSet);
        }
    }

    private void checkCycle() {
        HashSet<DAGNode<T>> memSet = new HashSet<DAGNode<T>>(8);
        for (DAGNode<T> head : this.headSet) {
            this.checkCycle(head, memSet);
        }
    }

    private void checkCycle(DAGNode<T> headNode, Set<DAGNode<T>> memSet) {
        if (memSet.contains(headNode)) {
            return;
        }
        this.checkCycle(new HashSet<DAGNode<T>>(8), memSet, headNode);
    }

    private void checkCycle(Set<DAGNode<T>> visitedNodeSet, Set<DAGNode<T>> memSet, DAGNode<T> node) {
        if (visitedNodeSet.contains(node)) {
            throw new DAGCircleException(Objects.toString(node.getVal()));
        }
        visitedNodeSet.add(node);
        for (DAGEdge<T> edge : node.getEdges()) {
            this.checkCycle(visitedNodeSet, memSet, edge.getDestNode());
        }
        visitedNodeSet.remove(node);
        memSet.add(node);
    }

    private void calcNodeWeightAndEdgeLen(DAGNode<T> node, HashSet<T> visitedSet) {
        if (visitedSet.contains(node.getVal())) {
            return;
        }
        Set<DAGEdge<T>> edges = node.getEdges();
        int edgeLenSum = 0;
        for (DAGEdge<T> edge : edges) {
            DAGNode<T> destNode = edge.getDestNode();
            this.calcNodeWeightAndEdgeLen(destNode, visitedSet);
            edge.setLen(destNode.getWeight() + 1);
            edgeLenSum += edge.getLen();
        }
        node.setWeight(edgeLenSum);
        visitedSet.add(node.getVal());
    }

    private void orderMap() {
        this.orderedList = new ArrayList<DAGNode<T>>();
        DAGVisit visit = new DAGVisit(this);
        visit.addNodeVisitListener(node -> this.orderedList.add(node));
        visit.visitAllNodes(false);
    }

    private void reverseMap() {
        DAGVisit visit = new DAGVisit(this);
        DAGManager manager = new DAGManager();
        visit.addNodeVisitListener(node -> {
            manager.get(node.getVal());
            for (DAGEdge edge : node.getEdges()) {
                DAGNode destNode = edge.getDestNode();
                manager.get(destNode.getVal()).addEdge(new DAGEdge(manager.get(node.getVal())));
            }
        });
        visit.visitAllNodes(false);
        this.reversedMap = manager.getVertexMap();
        this.revertHeadSet = manager.getHeadSet();
    }

    public void setVertexMap(Map<T, DAGNode<T>> vertexMap) {
        this.vertexMap = vertexMap;
    }

    public Map<T, DAGNode<T>> getReversedMap() {
        return this.reversedMap;
    }

    public void setReversedMap(Map<T, DAGNode<T>> reversedMap) {
        this.reversedMap = reversedMap;
    }

    public void setOrderedList(List<DAGNode<T>> orderedList) {
        this.orderedList = orderedList;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    @Override
    public Set<DAGNode<T>> getHeadSet() {
        this.reset();
        return this.headSet;
    }

    public void setHeadSet(Set<DAGNode<T>> headSet) {
        this.headSet = headSet;
    }

    public Set<DAGNode<T>> getRevertHeadSet() {
        return this.revertHeadSet;
    }

    public void setRevertHeadSet(Set<DAGNode<T>> revertHeadSet) {
        this.revertHeadSet = revertHeadSet;
    }
}

