/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.List;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.service.AdjustFixReportDataToCalcValStrategy;
import kd.tmc.fpm.business.spread.generator.actions.service.DetailReportDataToCalcValStrategy;
import kd.tmc.fpm.business.spread.generator.actions.service.IReportDataToCalcValStrategy;

public class AdjustReportDataProcessAction
implements IReportDataProcessAction {
    private ReportDataSource report;
    private FundPlanSystem system;

    public AdjustReportDataProcessAction(FundPlanSystem system, ReportDataSource report) {
        this.report = report;
        this.system = system;
    }

    @Override
    public void execute(ReportModel reportModel) {
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            IReportDataToCalcValStrategy strategy = this.getIReportDataToCalcValStrategy();
            strategy.transfer(this.report, reportCalcModel);
        }
    }

    public IReportDataToCalcValStrategy getIReportDataToCalcValStrategy() {
        TemplateType templateType = this.report.getTemplate().getTemplateType();
        return templateType.isDetail() ? new DetailReportDataToCalcValStrategy(this.system, null) : new AdjustFixReportDataToCalcValStrategy(this.system, this.report);
    }
}

