/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricDataType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.enums.SpecialColorEnum;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class DetailTotalRowBuildAction
implements IReportDataProcessAction {
    private FundPlanSystem system;
    private ReportDataSource report;
    private Map<Object, DimMember> dimMemberMap;

    public DetailTotalRowBuildAction(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
        this.dimMemberMap = this.system.getMainDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, o -> o, (a, b) -> a));
    }

    @Override
    public void execute(ReportModel reportModel) {
        if (this.report.getTemplate().getTemplateType() != TemplateType.DETAIL) {
            return;
        }
        ReportTemplate template = this.report.getTemplate();
        boolean enableCombine = TemplateInfoHelper.hasEnableCombine(template);
        if (!enableCombine) {
            return;
        }
        this.buildTotalRows(reportModel);
    }

    private void buildTotalRows(ReportModel reportModel) {
        if (CollectionUtils.isEmpty(reportModel.getReportCalcModelList())) {
            this.doBuild(reportModel.getTemplateModel());
        } else {
            for (ReportCalcModel reportCalcModel : reportModel.getReportCalcModelList()) {
                this.doBuild(reportCalcModel);
            }
        }
    }

    private void doBuild(ReportCalcModel templateModel) {
        List<ReportCalcVal> totalRow = this.buildTotalRow(templateModel);
        List<ReportCalcVal> subjectTotalRow = this.buildSubjectFlowTotalRow(templateModel, totalRow);
        if (CollectionUtils.isNotEmpty(totalRow)) {
            templateModel.getDataValList().addAll(totalRow);
        }
        if (CollectionUtils.isNotEmpty(subjectTotalRow)) {
            templateModel.getDataValList().addAll(subjectTotalRow);
        }
    }

    private List<ReportCalcVal> buildSubjectFlowTotalRow(ReportCalcModel reportCalcModel, List<ReportCalcVal> totalRows) {
        ReportTemplate template = this.report.getTemplate();
        if (!TemplateInfoHelper.hasEnableSubjectFlowCombine(template)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        Dimension subjectDim = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        FpmAssertUtil.isNotNull((Object)subjectDim, (String)"system subject dim is null");
        List<AccountMember> allDimMemberList = subjectDim.getAllDimMemberList(AccountMember.class);
        FpmAssertUtil.isNotEmpty(allDimMemberList, (String)"system subject member is null");
        Map<Long, FlowType> flowTypeMap = allDimMemberList.stream().collect(Collectors.toMap(DimMember::getId, AccountMember::getFlowType));
        EnumSet<FlowType> flowTypeEnumSet = EnumSet.noneOf(FlowType.class);
        List subjectDimIdList = template.getAllTemplateDim().stream().filter(item -> item.getDimType().isSubjectDim()).map(TemplateDim::getMemberScope).flatMap(Collection::stream).collect(Collectors.toList());
        for (Long subjectId : subjectDimIdList) {
            FlowType flowType = flowTypeMap.get(subjectId);
            if (!Objects.nonNull((Object)flowType)) continue;
            flowTypeEnumSet.add(flowType);
        }
        if (TemplateInfoHelper.hasEnableNetInFlowTotalRow(template, subjectDim)) {
            flowTypeEnumSet.add(FlowType.NETINFLOW);
        }
        List sortFlowTypeList = flowTypeEnumSet.stream().sorted(Comparator.comparing(FlowType::getOrder)).collect(Collectors.toList());
        Map flowNameMap = Arrays.stream(FlowEnum.values()).collect(Collectors.toMap(FlowEnum::getValue, Functions.identity()));
        int index = 0;
        ArrayList<ReportCalcVal> totalRowList = new ArrayList<ReportCalcVal>(16);
        Map<Integer, List<ReportCalcVal>> totalRowMap = totalRows.stream().collect(Collectors.groupingBy(ReportCalcVal::getRow));
        int normalMaxTotalRows = totalRows.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).orElse(0);
        for (Map.Entry<Integer, List<ReportCalcVal>> row : totalRowMap.entrySet()) {
            Integer currentRow = row.getKey();
            List<ReportCalcVal> colList = row.getValue();
            FlowType firstFlowType = (FlowType)((Object)sortFlowTypeList.get(0));
            FlowEnum flowEnum = (FlowEnum)flowNameMap.get(firstFlowType.getNumber());
            if (index == 0) {
                index = currentRow;
            }
            this.updateSubjectCellVal(colList, flowEnum, firstFlowType, index);
            ++index;
            for (FlowType flowType : sortFlowTypeList) {
                if (flowType == firstFlowType) continue;
                List<ReportCalcVal> reportCalcVals = this.copyRow(colList);
                this.updateSubjectCellVal(reportCalcVals, (FlowEnum)flowNameMap.get(flowType.getNumber()), flowType, index);
                totalRowList.addAll(reportCalcVals);
                ++index;
            }
        }
        if (NumberUtils.equalsZero((Integer)index) || NumberUtils.equalsZero((Integer)(index - normalMaxTotalRows))) {
            return totalRowList;
        }
        int toBeOffset = index - normalMaxTotalRows - 1;
        this.updateOffset(reportCalcModel, toBeOffset);
        if (template.getTemplateUse().isStatistic()) {
            this.report.getReportDataList().forEach(r -> r.setRow(r.getRow() + toBeOffset));
        }
        return totalRowList;
    }

    private void updateSubjectCellVal(List<ReportCalcVal> colList, FlowEnum flowEnum, FlowType flowType, int row) {
        for (ReportCalcVal reportCalcVal : colList) {
            reportCalcVal.setRow(row);
            if (reportCalcVal.isVirtualCell()) {
                reportCalcVal.setValue(flowType.getVirtualId());
                reportCalcVal.setDisplayVal(flowEnum.getName());
            }
            SpecialColorEnum specialColor = flowType == FlowType.NETINFLOW ? SpecialColorEnum.NET_IN_FLOW_TOTAL_COLUMN_COLOR : SpecialColorEnum.TOTAL_COLUMN_COLOR;
            reportCalcVal.setSpecialColor(specialColor);
        }
    }

    private void updateOffset(ReportCalcModel reportCalcModel, int offset) {
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        dataValList.forEach(r -> r.setRow(r.getRow() + offset));
    }

    private List<ReportCalcVal> buildTotalRow(ReportCalcModel reportCalcModel) {
        ReportTemplate template = this.report.getTemplate();
        List<Long> needTotalColDimList = template.getColDimList().stream().filter(templateDim -> templateDim.isExpand() || templateDim.isTotalRow()).map(TemplateDim::getDimensionId).collect(Collectors.toList());
        Integer rowStartIndex = reportCalcModel.getColDimValList().stream().map(ReportCalcVal::getRow).max(Integer::compareTo).get();
        List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList().stream().filter(reportCalcVal -> reportCalcVal.getColSpan() == 1 && reportCalcVal.getRow() + reportCalcVal.getRowSpan() - 1 == rowStartIndex).collect(Collectors.toList());
        int colRow = colDimValList.stream().max(Comparator.comparing(ReportCalcVal::getRow)).map(ReportCalcVal::getRow).orElse(0);
        ArrayList<ReportCalcVal> totalRowList = new ArrayList<ReportCalcVal>(colDimValList.size());
        int countOfRow = 0;
        Optional<TemplateDim> currencyOptional = template.getColDimList().stream().filter(templateDim -> templateDim.getDimType() == DimensionType.CURRENCY).findFirst();
        if (currencyOptional.isPresent()) {
            TemplateDim currencyDim = currencyOptional.get();
            if (currencyDim.isExpand()) {
                needTotalColDimList.add(currencyDim.getDimensionId());
                totalRowList.addAll(this.rowHandleForCurrencyExpand(colDimValList, needTotalColDimList, colRow + 1));
                ++countOfRow;
            } else {
                for (int i = 0; i < currencyDim.getMemberScope().size(); ++i) {
                    Long currMem = currencyDim.getMemberScope().get(i);
                    totalRowList.addAll(this.rowHandleForCurrencyNotExpand(colDimValList, needTotalColDimList, currencyDim, i + colRow + 1, currMem));
                    ++countOfRow;
                }
            }
        } else {
            totalRowList.addAll(this.rowHandleForCurrencyExpand(colDimValList, needTotalColDimList, colRow + 1));
            ++countOfRow;
        }
        this.updateOffset(reportCalcModel, countOfRow);
        if (template.getTemplateUse().isStatistic()) {
            int finalCountOfRow = countOfRow;
            Optional<TemplateDim> hasExpand = template.getColDimList().stream().filter(TemplateDim::isExpand).findFirst();
            if (hasExpand.isPresent()) {
                this.report.getReportDataList().forEach(r -> r.setRow(r.getRow() + finalCountOfRow + 1));
            } else {
                this.report.getReportDataList().forEach(r -> r.setRow(r.getRow() + finalCountOfRow));
            }
        }
        return totalRowList;
    }

    private List<ReportCalcVal> rowHandleForCurrencyNotExpand(List<ReportCalcVal> colDimValList, List<Long> needTotalColDimList, TemplateDim currencyDim, int rowIdx, Long currMem) {
        ArrayList<ReportCalcVal> result = new ArrayList<ReportCalcVal>(colDimValList.size());
        for (ReportCalcVal reportCalcVal : colDimValList) {
            ReportCalcVal totalRcv = this.createNewReportCalcVal(reportCalcVal, rowIdx, needTotalColDimList, currencyDim, currMem);
            result.add(totalRcv);
        }
        return result;
    }

    private List<ReportCalcVal> rowHandleForCurrencyExpand(List<ReportCalcVal> colDimValList, List<Long> needTotalColDimList, int rowIdx) {
        ArrayList<ReportCalcVal> result = new ArrayList<ReportCalcVal>(colDimValList.size());
        for (ReportCalcVal reportCalcVal : colDimValList) {
            ReportCalcVal totalRcv = this.createNewReportCalcVal(reportCalcVal, rowIdx, needTotalColDimList, null, null);
            result.add(totalRcv);
        }
        return result;
    }

    private ReportCalcVal createNewReportCalcVal(ReportCalcVal colRcv, int rowIdx, List<Long> needTotalColDimList, TemplateDim currencyDim, Long currMem) {
        ReportCalcVal totalRcv = new ReportCalcVal();
        totalRcv.setCol(colRcv.getCol());
        totalRcv.setRow(rowIdx);
        totalRcv.setRowSpan(1);
        totalRcv.setColSpan(1);
        totalRcv.setVirtualCell(colRcv.isVirtualCell());
        if (colRcv.isSummary()) {
            totalRcv.setTotalSummaryOfLittleSummary(true);
        }
        Dimension currentDimension = this.system.getMainDimensionByDimensionId(colRcv.getDimensionId());
        if (needTotalColDimList.contains(colRcv.getDimensionId())) {
            ReportValueType type = new ReportValueType();
            if (this.isMetricAmount(currentDimension, colRcv.getValue())) {
                type.setReportCellType(ReportCellType.AMOUNT);
            } else {
                type.setReportCellType(ReportCellType.PERCENT);
            }
            totalRcv.setValue(BigDecimal.ZERO);
            totalRcv.setDisplayVal(totalRcv.getValue().toString());
            totalRcv.setValueType(type);
            totalRcv.setSummary(true);
            totalRcv.setDataCell(true);
            totalRcv.setTotalSummary(true);
        } else if (currencyDim != null && Objects.equals(currencyDim.getDimensionId(), colRcv.getDimensionId())) {
            ReportValueType type = new ReportValueType();
            type.setReportCellType(ReportCellType.TEXT);
            DimMember dimMember = this.dimMemberMap.get(currMem);
            totalRcv.setDisplayVal(dimMember.getName());
            totalRcv.setValue(currMem);
            totalRcv.setDimensionId(currencyDim.getDimensionId());
            totalRcv.setDimensionName(currencyDim.getDimensionName());
            totalRcv.setValueType(type);
        } else {
            totalRcv.setDisplayVal("");
            totalRcv.setValueType(colRcv.getValueType());
        }
        totalRcv.setEnable(false);
        totalRcv.setRemarkCell(false);
        totalRcv.setSpecialColor(SpecialColorEnum.TOTAL_COLUMN_COLOR);
        totalRcv.setDisplayType(DisplayTypeEnum.NORMAR);
        return totalRcv;
    }

    private boolean isMetricAmount(Dimension currentDimension, Object memberId) {
        if (!currentDimension.getDimType().isMetric()) {
            return true;
        }
        MetricMember dimMember = (MetricMember)this.dimMemberMap.get(memberId);
        if (dimMember == null) {
            return false;
        }
        return dimMember.getDataType() != TemplateMetricDataType.PERCENT;
    }

    private List<ReportCalcVal> copyRow(List<ReportCalcVal> colDimValList) {
        ArrayList<ReportCalcVal> result = new ArrayList<ReportCalcVal>(colDimValList.size());
        for (ReportCalcVal reportCalcVal : colDimValList) {
            ReportCalcVal totalRcv = new ReportCalcVal();
            totalRcv.setDataId(reportCalcVal.getDataId());
            totalRcv.setDimensionId(reportCalcVal.getDimensionId());
            totalRcv.setDimensionName(reportCalcVal.getDimensionName());
            totalRcv.setDisplayVal(reportCalcVal.getDisplayVal());
            totalRcv.setValue(reportCalcVal.getValue());
            totalRcv.setCol(reportCalcVal.getCol());
            totalRcv.setRow(reportCalcVal.getRow());
            totalRcv.setColSpan(reportCalcVal.getColSpan());
            totalRcv.setRowSpan(reportCalcVal.getRowSpan());
            totalRcv.setLevel(reportCalcVal.getLevel());
            totalRcv.setEnable(reportCalcVal.isEnable());
            totalRcv.setSummary(reportCalcVal.isSummary());
            totalRcv.setDataCell(reportCalcVal.isDataCell());
            totalRcv.setRemarkCell(reportCalcVal.isRemarkCell());
            totalRcv.setVirtualCell(reportCalcVal.isVirtualCell());
            totalRcv.setValueType(reportCalcVal.getValueType());
            totalRcv.setFormula(reportCalcVal.getFormula());
            totalRcv.setDisplayType(reportCalcVal.getDisplayType());
            totalRcv.setReferenceCell(reportCalcVal.isReferenceCell());
            totalRcv.setRollCell(reportCalcVal.isRollCell());
            totalRcv.setExcelFormula(reportCalcVal.getExcelFormula());
            totalRcv.setMetric(reportCalcVal.isMetric());
            totalRcv.setBackColor(reportCalcVal.getBackColor());
            totalRcv.setTotalSummary(reportCalcVal.isTotalSummary());
            totalRcv.setUseType(reportCalcVal.getUseType());
            totalRcv.setTotalSummaryOfLittleSummary(reportCalcVal.isTotalSummaryOfLittleSummary());
            totalRcv.setDirty(reportCalcVal.isDirty());
            totalRcv.setSpecialColor(reportCalcVal.getSpecialColor());
            totalRcv.setDimLevel(reportCalcVal.getDimLevel());
            totalRcv.setSourceIdList(reportCalcVal.getSourceIdList());
            result.add(totalRcv);
        }
        return result;
    }
}

