/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.generator.actions.impl.DetailReportFormulaProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.FormulaProcessV3Action;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class ExportDetailReportFormulaProcessAction
extends DetailReportFormulaProcessAction {
    private static final Log logger = LogFactory.getLog(ExportDetailReportFormulaProcessAction.class);
    private int rowOffset = 3;

    public ExportDetailReportFormulaProcessAction(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
    }

    @Override
    protected void processSummary(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList, FormulaProcessV3Action.CalcValColQueryIndex queryIndex, Predicate<ReportCalcVal> sumPredicate, Predicate<ReportCalcVal> colLittleSumCellFilter) {
        ReportTemplate template = this.report.getTemplate();
        if (template.getTemplateType() != TemplateType.DETAIL) {
            super.processSummary(reportCalcModel, summaryDataList, queryIndex, sumPredicate, colLittleSumCellFilter);
            return;
        }
        if (EmptyUtil.isEmpty(summaryDataList)) {
            logger.info("\u4e0d\u5b58\u5728\u9700\u8981\u6c47\u603b\u7684cell");
            return;
        }
        List<ReportCalcVal> totalRowCells = summaryDataList.stream().filter(sumPredicate).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(totalRowCells) || !((ReportCalcVal)totalRowCells.get(0)).isTotalSummary()) {
            logger.info("\u4e0d\u5b58\u5728\u5408\u8ba1\u884c\u7684cell");
            super.processSummary(reportCalcModel, summaryDataList, queryIndex, sumPredicate, colLittleSumCellFilter);
            return;
        }
        FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex = this.buildIndex(reportCalcModel, this.rowOffset);
        ReportDataIndexQueryMap<String> indexQueryMap = queryTotalRowIndex.getIndexQueryMap();
        Map<String, ReportCalcVal> dataMap = queryTotalRowIndex.getDataMap();
        Optional<TemplateDim> currencyOptional = template.getColDimList().stream().filter(templateDim -> templateDim.getDimType() == DimensionType.CURRENCY).findFirst();
        for (ReportCalcVal reportCalcVal : totalRowCells) {
            List<ReportCalcVal> reportCalcValList;
            int col = reportCalcVal.getCol();
            int row = reportCalcVal.getRow();
            Map<String, Object> currencyInfoMap = null;
            if (!currencyOptional.isPresent()) {
                reportCalcValList = reportCalcModel.getDataValList().stream().filter(ReportCalcVal::isDataCell).filter(rcv -> rcv.getCol() == col && rcv.getRow() != reportCalcVal.getRow()).collect(Collectors.toList());
            } else if (reportCalcVal.isTotalSummaryOfLittleSummary()) {
                reportCalcValList = this.filterSumItems(totalRowCells, reportCalcVal);
                currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
            } else {
                DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfoWithVirtual(col, row - this.rowOffset);
                this.filterNullIfNeed(dimensionInfo);
                List<String> list = indexQueryMap.findList(dimensionInfo);
                if (EmptyUtil.isEmpty(list)) continue;
                reportCalcValList = list.stream().distinct().map(dataMap::get).filter(Objects::nonNull).filter(rcv -> rcv.getCol() == reportCalcVal.getCol()).collect(Collectors.toList());
            }
            if (currencyInfoMap != null) {
                reportCalcVal.setFormula(this.getSumFormula(reportCalcVal, reportCalcValList, currencyInfoMap));
                continue;
            }
            reportCalcVal.setFormula(this.getSumFormulaForTotalRow(reportCalcVal, reportCalcValList));
        }
    }
}

