/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodDirection;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportValueFormulaTypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaOperationValType;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.ss.util.CellReference;

public class FormulaProcessV3Action
implements IReportDataProcessAction {
    private static final Log logger = LogFactory.getLog(FormulaProcessV3Action.class);
    protected ReportDataSource report;
    protected FundPlanSystem system;
    protected Long currencyDimensionId;
    protected Long periodDimensionId;
    protected Map<Long, AccountMember> periodStartEndMap;
    protected MetricMember actAmtMetricMember;
    protected MetricMember planAmtMetricMember;
    protected Dimension metricDim;
    protected Dimension subjectDim;
    private Set<Long> mainDimensionIds;
    protected Map<String, MetricMember> templateMetricType2MetricMemberMap;
    private Set<Long> allDimIdSet;

    public FormulaProcessV3Action(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
        this.currencyDimensionId = system.getMainDimensionByDimType(DimensionType.CURRENCY).getId();
        this.periodDimensionId = system.getMainDimensionByDimType(DimensionType.PERIOD).getId();
        this.subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> memberList = this.subjectDim.getAllDimMemberList();
        this.periodStartEndMap = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection())).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        this.allDimIdSet = system.getDimList().stream().map(Dimension::getId).collect(Collectors.toSet());
        this.mainDimensionIds = system.getMainDimList().stream().filter(Objects::nonNull).map(Dimension::getId).collect(Collectors.toSet());
        this.metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
        if (EmptyUtil.isEmpty((Object)this.metricDim)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u7ef4\u5ea6\u4e0d\u5b58\u5728\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u3010%s\u3011\u5ea6\u91cf\u503c\u7ef4\u5ea6\u662f\u5426\u5df2\u7ecf\u521d\u59cb\u5316", (String)"FormulaProcessV3Action_0", (String)"tmc-fpm-business", (Object[])new Object[]{system.getName()}));
        }
        this.templateMetricType2MetricMemberMap = this.metricDim.getAllDimMemberList().stream().filter(MetricMember.class::isInstance).map(MetricMember.class::cast).collect(Collectors.toMap(key -> key.getTemplateMetricType().getCode(), Function.identity(), (a, b) -> a));
        this.actAmtMetricMember = this.templateMetricType2MetricMemberMap.get(TemplateMetricType.ACTMAT.getCode());
        this.planAmtMetricMember = this.templateMetricType2MetricMemberMap.get(TemplateMetricType.PLANAMT.getCode());
        if (EmptyUtil.isEmpty((Object)this.actAmtMetricMember) || EmptyUtil.isEmpty((Object)this.planAmtMetricMember)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u3010\u8ba1\u5212\u989d\u5ea6\u3011\u3010\u5df2\u6267\u884c\u989d\u5ea6\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u3010%s\u3011\u5ea6\u91cf\u6307\u6807\u662f\u5426\u521d\u59cb\u5316", (String)"FormulaProcessV3Action_1", (String)"tmc-fpm-business", (Object[])new Object[]{system.getName()}));
        }
    }

    @Override
    public void execute(ReportModel reportModel) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(FormulaProcessV3Action.class.getSimpleName());){
            List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
            for (ReportCalcModel calcModel : reportCalcModelList) {
                this.processFormula(calcModel, span);
            }
        }
    }

    private void processFormula(ReportCalcModel reportCalcModel, IFpmTraceSpan span) {
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        if (EmptyUtil.isEmpty(dataValList)) {
            return;
        }
        span.addTag("process FormulaProcessV3Action start");
        List<CalcValColRowInfo> calcValColRowInfoList = dataValList.stream().filter(ReportCalcVal::isDataCell).filter(reportCalcVal -> !reportCalcVal.isReferenceCell()).filter(reportCalcVal -> !reportCalcVal.isSummary()).map(CalcValColRowInfo::new).collect(Collectors.toList());
        span.addTag("build index");
        CalcValColQueryIndex queryIndex = this.build(calcValColRowInfoList, reportCalcModel);
        span.addTag("processSummaryForReference");
        this.processSummaryForReference(reportCalcModel, dataValList);
        List<ReportCalcVal> summaryDataList = dataValList.stream().filter(ReportCalcVal::isDataCell).filter(reportCalcVal -> !reportCalcVal.isReferenceCell()).filter(ReportCalcVal::isSummary).collect(Collectors.toList());
        span.addTag("process littleSum");
        this.processSummary(reportCalcModel, summaryDataList, queryIndex, reportCalcVal -> !reportCalcVal.isTotalSummary(), null);
        span.addTag("process TotalSum");
        this.processSummary(reportCalcModel, summaryDataList, queryIndex, ReportCalcVal::isTotalSummary, ReportCalcVal::isTotalSummaryOfLittleSummary);
        span.addTag("process processPeriodStartEnd");
        this.processPeriodStartEndIfNeed(reportCalcModel, summaryDataList, queryIndex);
        span.addTag("process SummaryAndFormula");
        this.processSummaryAndFormulaIfNeed(reportCalcModel, queryIndex);
        this.calTotalRowMetricVal(reportCalcModel, summaryDataList, reportCalcVal -> !reportCalcVal.isTotalSummary(), queryIndex);
        span.addTag("process end");
    }

    private void processSummaryForReference(ReportCalcModel reportCalcModel, List<ReportCalcVal> dataValList) {
        if (EmptyUtil.isEmpty(dataValList)) {
            logger.info("\u4e0d\u5b58\u5728\u5c0f\u8ba1\u6216\u5408\u8ba1\u7684cell");
            return;
        }
        List<ReportCalcVal> summaryDataList = dataValList.stream().filter(ReportCalcVal::isDataCell).filter(ReportCalcVal::isReferenceCell).filter(ReportCalcVal::isSummary).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(summaryDataList)) {
            logger.info("\u4e0d\u5b58\u5728\u975e\u53c2\u8003\u671f\u95f4\u7684\u5c0f\u8ba1\u6216\u5408\u8ba1\u7684cell");
            return;
        }
        List<CalcValColRowInfo> calcValColRowInfoList = dataValList.stream().filter(ReportCalcVal::isReferenceCell).filter(ReportCalcVal::isDataCell).filter(reportCalcVal -> !reportCalcVal.isSummary()).map(CalcValColRowInfo::new).collect(Collectors.toList());
        CalcValColQueryIndex queryIndex = this.build(calcValColRowInfoList, reportCalcModel);
        this.processSummary(reportCalcModel, summaryDataList, queryIndex, reportCalcVal -> !reportCalcVal.isTotalSummary(), null);
        this.calTotalRowMetricVal(reportCalcModel, summaryDataList, reportCalcVal -> !reportCalcVal.isTotalSummary(), queryIndex);
    }

    private void processPeriodStartEndIfNeed(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList, CalcValColQueryIndex queryIndex) {
        Set<Long> periodStartEndSubjectIds = this.getPeriodStartEndSubjectIds();
        if (EmptyUtil.isEmpty(periodStartEndSubjectIds)) {
            logger.info("\u4e0d\u5b58\u5728\u671f\u521d\u671f\u672b\u79d1\u76ee");
            return;
        }
        Map periodDirectionMapMap = periodStartEndSubjectIds.stream().map(this.periodStartEndMap::get).collect(Collectors.groupingBy(AccountMember::getPeriodDirection, Collectors.mapping(Function.identity(), Collectors.toMap(DimMember::getId, Function.identity()))));
        Map periodEndMap = periodDirectionMapMap.getOrDefault(PeriodDirection.ENDING, Collections.emptyMap());
        if (CollectionUtils.isEmpty(periodEndMap)) {
            logger.info("\u4e0d\u5b58\u5728\u671f\u672b\u79d1\u76ee");
            Map<Long, AccountMember> periodSubjects = this.periodStartEndMap.values().stream().filter(item -> periodStartEndSubjectIds.contains(item.getId())).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
            this.resetSummaryCellForPeriodStart(reportCalcModel, summaryDataList, periodSubjects, queryIndex);
            return;
        }
        Map periodStartMap = periodDirectionMapMap.getOrDefault(PeriodDirection.BEGINNING, Collections.emptyMap());
        HashSet<Long> needSetPeriodEndIdSet = new HashSet<Long>(periodStartMap.size());
        for (AccountMember accountMember2 : periodEndMap.values()) {
            AccountMember associateAccount = accountMember2.getAssociateAccount();
            if (EmptyUtil.isEmpty((Object)associateAccount)) {
                logger.info("\u671f\u672b\u79d1\u76ee\uff1a{}\uff0c\u6ca1\u6709\u5173\u8054\u7684\u671f\u521d\u79d1\u76ee", (Object)accountMember2.getName());
                continue;
            }
            Long periodStartSubjectId = associateAccount.getId();
            if (!periodStartMap.containsKey(periodStartSubjectId)) {
                logger.info("\u671f\u672b\u79d1\u76ee\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684\u671f\u521d\u79d1\u76ee", (Object)accountMember2.getName());
                continue;
            }
            needSetPeriodEndIdSet.add(accountMember2.getId());
        }
        if (EmptyUtil.isEmpty(needSetPeriodEndIdSet)) {
            logger.info("\u4e0d\u5b58\u5728\u671f\u521d\u79d1\u76ee\u3002\u3002\u3002");
            Map<Long, AccountMember> periodSubjects = this.periodStartEndMap.values().stream().filter(item -> periodStartEndSubjectIds.contains(item.getId())).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
            this.resetSummaryCellForPeriodStart(reportCalcModel, summaryDataList, periodSubjects, queryIndex);
            return;
        }
        Map<Long, AccountMember> periodEndFinalMap = needSetPeriodEndIdSet.stream().map(periodEndMap::get).filter(Objects::nonNull).filter(accountMember -> Objects.nonNull(accountMember.getAssociateAccount())).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        this.handleBeginEndDataCell(reportCalcModel, summaryDataList, queryIndex, periodEndFinalMap);
    }

    protected Set<Long> getPeriodStartEndSubjectIds() {
        List<TemplateAccountSetting> accountSettings = this.report.getTemplate().getAccountSettings();
        HashSet<Long> periodStartEndSubjectIds = new HashSet<Long>(16);
        this.fillPeriodStartEndSubjectIds(accountSettings, periodStartEndSubjectIds);
        return periodStartEndSubjectIds;
    }

    protected void handleBeginEndDataCell(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList, CalcValColQueryIndex queryIndex, Map<Long, AccountMember> periodEndMap) {
        if (!(this.report instanceof Report)) {
            return;
        }
        if (this.onlyNeedResetSummaryCell()) {
            List referenceSummaryDataList = reportCalcModel.getDataValList().stream().filter(ReportCalcVal::isDataCell).filter(ReportCalcVal::isReferenceCell).filter(ReportCalcVal::isSummary).collect(Collectors.toList());
            this.processSetProcessPeriodStartEndForReferencePeriodIfNeed(reportCalcModel, referenceQueryIndex -> this.resetSummaryCellForPeriodStart(reportCalcModel, referenceSummaryDataList, periodEndMap, (CalcValColQueryIndex)referenceQueryIndex));
            this.resetSummaryCellForPeriodStart(reportCalcModel, summaryDataList, periodEndMap, queryIndex);
            return;
        }
        Map<Integer, ReportCalcVal> subjectDimRowMap = this.getAllPeriodEndSubjectRowDimInfo(reportCalcModel, periodEndMap);
        HashMap<Long, AccountMember> refSubjectMap = new HashMap<Long, AccountMember>(periodEndMap);
        Set<Long> beginEndSubjectIds = DimensionInfoHelper.listBeginEndSubjectIds(this.system, true);
        for (Map.Entry<Long, AccountMember> memberEntry : periodEndMap.entrySet()) {
            if (beginEndSubjectIds.contains(memberEntry.getKey())) continue;
            refSubjectMap.remove(memberEntry.getKey());
        }
        if (!((Report)this.report).getInitFlag().booleanValue()) {
            this.processSetProcessPeriodStartEndForReferencePeriodIfNeed(reportCalcModel, referenceQueryIndex -> this.doProcessSetPeriodStartByPeriodEndValue(reportCalcModel, (CalcValColQueryIndex)referenceQueryIndex, (Map<Long, AccountMember>)refSubjectMap, subjectDimRowMap));
        }
        this.doProcessSetPeriodStartByPeriodEndValue(reportCalcModel, queryIndex, periodEndMap, subjectDimRowMap);
        this.resetSummaryCellForPeriodStart(reportCalcModel, summaryDataList, periodEndMap, queryIndex);
    }

    protected boolean onlyNeedResetSummaryCell() {
        if (this.report.getTemplate().getTemplateUse() != TemplateUseType.PLANING) {
            return true;
        }
        if (!Report.class.isInstance(this.report)) {
            return true;
        }
        Report report$ = (Report)this.report;
        return report$.getProcessStatus() != ReportProcessStatus.SAVE;
    }

    protected void resetSummaryCellForPeriodStart(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList, Map<Long, AccountMember> periodEndMap, CalcValColQueryIndex queryIndex) {
        Map<Long, AccountMember> periodStartMap = periodEndMap.values().stream().map(AccountMember::getAssociateAccount).filter(Objects::nonNull).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        periodStartMap.putAll(periodEndMap.values().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a)));
        Map<Integer, ReportCalcVal> subjectPeriodStartDimRowMap = this.getAllPeriodEndSubjectRowDimInfo(reportCalcModel, periodStartMap);
        this.getAllBeginEndTermWithSummary(subjectPeriodStartDimRowMap, reportCalcModel, periodStartMap);
        Consumer<ReportCalcVal> resetFunction = this.getResetConsumer(reportCalcModel, queryIndex);
        HashSet<Integer> colLittleSumIndex = new HashSet<Integer>(128);
        List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
        HashSet<Integer> periodAllIndex = new HashSet<Integer>(colDimValList.size());
        colDimValList.stream().filter(rc -> Objects.equals(rc.getDimensionId(), this.periodDimensionId)).forEach(rc -> {
            int col;
            for (int i = col = rc.getCol(); i < col + rc.getColSpan(); ++i) {
                if (!rc.isSummary()) {
                    return;
                }
                periodAllIndex.add(i);
            }
        });
        colDimValList.stream().filter(ReportCalcVal::isSummary).filter(ReportCalcVal::isTotalSummary).filter(ReportCalcVal::isTotalSummaryOfLittleSummary).forEach(reportCalcVal -> {
            int col;
            for (int i = col = reportCalcVal.getCol(); i < col + reportCalcVal.getColSpan(); ++i) {
                colLittleSumIndex.add(i);
            }
        });
        Predicate<ReportCalcVal> summaryFilter = this.getSummaryFilter(colLittleSumIndex, periodAllIndex);
        summaryDataList.stream().filter(reportCalcVal -> subjectPeriodStartDimRowMap.containsKey(reportCalcVal.getRow())).filter(summaryFilter::test).forEach(resetFunction::accept);
    }

    private void getAllBeginEndTermWithSummary(Map<Integer, ReportCalcVal> subjectPeriodStartDimRowMap, ReportCalcModel reportCalcModel, Map<Long, AccountMember> periodEndMap) {
        Dimension subjectDim = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> memberList = subjectDim.getAllDimMemberList();
        Set accountMemberList = memberList.stream().map(AccountMember.class::cast).filter(acc -> !periodEndMap.containsKey(acc.getId())).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection())).map(DimMember::getId).collect(Collectors.toSet());
        Consumer<ReportCalcVal> subjectFillRowMapConsumer = reportCalcVal -> {
            int row;
            for (int i = row = reportCalcVal.getRow(); i < row + reportCalcVal.getRowSpan(); ++i) {
                subjectPeriodStartDimRowMap.put(i, (ReportCalcVal)reportCalcVal);
            }
        };
        reportCalcModel.getRowDimValList().stream().filter(reportCalcVal -> Objects.equals(reportCalcVal.getDimensionId(), subjectDim.getId())).filter(reportCalcVal -> accountMemberList.contains(reportCalcVal.getValue())).forEach(subjectFillRowMapConsumer);
    }

    protected Consumer<ReportCalcVal> getResetConsumer(ReportCalcModel reportCalcModel, CalcValColQueryIndex queryIndex) {
        Consumer<ReportCalcVal> resetFunction = reportCalcVal -> {
            reportCalcVal.setValue(null);
            reportCalcVal.setDisplayVal("--");
            reportCalcVal.getValueType().setReportCellType(ReportCellType.TEXT);
            reportCalcVal.setFormula(null);
        };
        return resetFunction;
    }

    protected Predicate<ReportCalcVal> getSummaryFilter(Set<Integer> colLittleSumIndex, Set<Integer> periodAllIndex) {
        int periodDimLevel = this.getPeriodDimLevel();
        Predicate<ReportCalcVal> summaryFilter = reportCalcVal -> {
            if (reportCalcVal.isTotalSummary() && periodDimLevel == 1) {
                return true;
            }
            if (colLittleSumIndex.contains(reportCalcVal.getCol())) {
                return true;
            }
            if (!reportCalcVal.isTotalSummary() && reportCalcVal.isSummary()) {
                return true;
            }
            if (!periodAllIndex.contains(reportCalcVal.getCol())) {
                return false;
            }
            return false;
        };
        return summaryFilter;
    }

    protected int getPeriodDimLevel() {
        ReportTemplate template = this.report.getTemplate();
        Optional<TemplateDim> first = template.getColDimList().stream().filter(td -> td.getDimType() == DimensionType.PERIOD).findFirst();
        if (!first.isPresent()) {
            return -1;
        }
        TemplateDim periodDim = first.get();
        int level = periodDim.getLevel();
        return level;
    }

    protected void processSetProcessPeriodStartEndForReferencePeriodIfNeed(ReportCalcModel reportCalcModel, Consumer<CalcValColQueryIndex> callBack) {
        if (!(this.report instanceof Report)) {
            return;
        }
        Report report$ = (Report)this.report;
        PeriodMember referencePeriodMember = report$.getReferencePeriodMember();
        if (EmptyUtil.isEmpty((Object)referencePeriodMember)) {
            return;
        }
        ReportPeriodType reportPeriodType = report$.getReportPeriodType();
        ReportPeriodType referencePeriodType = report$.getReferencePeriodType();
        if (EmptyUtil.isEmpty((Object)reportPeriodType) || EmptyUtil.isEmpty((Object)referencePeriodType)) {
            return;
        }
        if (!Objects.equals(referencePeriodType.getReportPeriodId(), reportPeriodType.getReportPeriodId())) {
            return;
        }
        ReportTemplate template = this.report.getTemplate();
        Optional<TemplateReportType> first = template.getReportTypeList().stream().filter(templateReportType -> Objects.equals(templateReportType.getReportTypeId(), reportPeriodType.getReportPeriodId())).findFirst();
        if (!first.isPresent()) {
            return;
        }
        TemplateReportType templateReportType2 = first.get();
        List<MetricMember> referencePosList = templateReportType2.getReferencePosList();
        if (EmptyUtil.isEmpty(referencePosList)) {
            return;
        }
        Optional<MetricMember> actPosOptional = referencePosList.stream().filter(metricMember -> metricMember.getTemplateMetricType() == TemplateMetricType.ACTMAT).findFirst();
        if (!actPosOptional.isPresent()) {
            return;
        }
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        if (EmptyUtil.isEmpty(dataValList)) {
            return;
        }
        List<CalcValColRowInfo> referenceDataCellList = dataValList.stream().filter(ReportCalcVal::isDataCell).map(CalcValColRowInfo::new).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(referenceDataCellList)) {
            return;
        }
        CalcValColQueryIndex queryIndex = this.build(referenceDataCellList, reportCalcModel);
        callBack.accept(queryIndex);
    }

    protected void doProcessSetPeriodStartByPeriodEndValue(ReportCalcModel reportCalcModel, CalcValColQueryIndex queryIndex, Map<Long, AccountMember> periodEndMap, Map<Integer, ReportCalcVal> subjectDimRowMap) {
        ReportDataIndexQueryMap<String> indexQueryMap = queryIndex.getIndexQueryMap();
        Map<String, ReportCalcVal> dataMap = queryIndex.getDataMap();
        Dimension periodDim = this.system.getMainDimensionByDimType(DimensionType.PERIOD);
        BiFunction<Long, Long, Long> periodMemberFunction = this.getNextPeriodMemberFunction(periodEndMap.keySet());
        Collection<ReportCalcVal> reportCalcValList = dataMap.values().stream().filter(ReportCalcVal::isReferenceCell).filter(ReportCalcVal::isDataCell).filter(rc -> !rc.isSummary()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty((Collection)reportCalcValList)) {
            reportCalcValList = dataMap.values();
        }
        ReportTemplate template = this.report.getTemplate();
        Map<Long, TemplateAccountSetting> formulaSubjectMap = template.getAccountSettings().stream().filter(Objects::nonNull).filter(item -> ReportInputType.FORMULA == item.getInputType()).collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity(), (a, b) -> a));
        Map<Long, String> accountFormulaMap = template.getAccountSettings().stream().filter(item -> item.getInputType() == ReportInputType.FORMULA).collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, TemplateAccountSetting::getFormula));
        Map<Long, List<AccountMember>> beginMultiMapEnd = this.subjectDim.getAllDimMemberList(AccountMember.class).stream().filter(i -> Objects.nonNull(i.getPeriodDirection()) && Objects.nonNull(i.getAssociateAccount())).filter(i -> accountFormulaMap.containsKey(i.getId())).sorted(Comparator.comparing(DimMember::getSortCode)).collect(Collectors.groupingBy(i -> i.getAssociateAccount().getId()));
        Map<Long, Long> multiEndFindOneFormulaMap = this.multiEndFindOneFormula(accountFormulaMap, beginMultiMapEnd);
        for (ReportCalcVal reportCalcVal : reportCalcValList) {
            String colRowInfo;
            Long originalPeriodId;
            Long originalSubjectId;
            AccountMember accountMemberPeriodStart;
            Long beginId;
            AccountMember endMember;
            ReportCalcVal subjectDimCalVal;
            Object subjectPeriodEndId;
            int row = reportCalcVal.getRow();
            if (!subjectDimRowMap.containsKey(row) || !((subjectPeriodEndId = (subjectDimCalVal = subjectDimRowMap.get(row)).getValue()) instanceof Long) || EmptyUtil.isEmpty((Object)(endMember = periodEndMap.get(beginId = (Long)subjectPeriodEndId))) || EmptyUtil.isEmpty((Object)(accountMemberPeriodStart = endMember.getAssociateAccount()))) continue;
            if (this.checkMultiEndSubject(multiEndFindOneFormulaMap, beginMultiMapEnd, accountMemberPeriodStart.getId(), endMember.getId())) {
                this.processFormulaItemIfNeed(subjectDimCalVal, reportCalcModel, formulaSubjectMap, dataMap, indexQueryMap, reportCalcVal);
                continue;
            }
            DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(reportCalcVal.getCol(), row);
            if (this.filterNotActAmtMetricAndResetForReference(reportCalcVal, dimensionInfo) || EmptyUtil.isEmpty((Long)(originalSubjectId = this.updateDimensionInfoBean(dimensionInfo, subjectDimCalVal.getDimensionId(), originalId -> accountMemberPeriodStart.getId()))) || EmptyUtil.isEmpty((Long)(originalPeriodId = this.updateDimensionInfoBean(dimensionInfo, periodDim.getId(), originalId -> (Long)periodMemberFunction.apply(originalSubjectId, (Long)originalId)))) || EmptyUtil.isEmpty((String)(colRowInfo = indexQueryMap.find(dimensionInfo)))) continue;
            ReportCalcVal reportCalcValSubjectStart = dataMap.get(colRowInfo);
            this.setEnable(reportCalcValSubjectStart, reportCalcVal);
            if (reportCalcVal.isReferenceCell()) {
                if (!EmptyUtil.isEmpty((Object)reportCalcValSubjectStart.getValue())) continue;
                reportCalcValSubjectStart.setValue(reportCalcVal.getValue());
                reportCalcValSubjectStart.setDisplayVal(reportCalcVal.getDisplayVal());
                continue;
            }
            String formula = ExcelUtils.xy2Pos((int)reportCalcVal.getCol(), (int)reportCalcVal.getRow());
            reportCalcValSubjectStart.setFormula(this.getFormula(formula, reportCalcValSubjectStart, dataMap));
        }
    }

    private Map<Long, Long> multiEndFindOneFormula(Map<Long, String> accountFormulaMap, Map<Long, List<AccountMember>> beginMultiMapEnd) {
        HashMap<Long, Long> endFormulaLinkMap = new HashMap<Long, Long>(1);
        for (Map.Entry<Long, List<AccountMember>> entry : beginMultiMapEnd.entrySet()) {
            AccountMember accountMember;
            Long beginId = entry.getKey();
            List<AccountMember> accountMembers = entry.getValue();
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(accountMembers) || accountMembers.size() <= 1) continue;
            ArrayList<Integer> matchIndex = new ArrayList<Integer>(accountMembers.size());
            for (int i = 0; i < accountMembers.size(); ++i) {
                AccountMember accountMember2 = accountMembers.get(i);
                String formula = accountFormulaMap.get(accountMember2.getId());
                if (EmptyUtil.isEmpty((String)formula) || !formula.contains(beginId.toString())) continue;
                matchIndex.add(i);
            }
            if (matchIndex.size() != 1 || !Objects.nonNull(accountMember = accountMembers.get((Integer)matchIndex.get(0)))) continue;
            endFormulaLinkMap.put(beginId, accountMember.getId());
        }
        return endFormulaLinkMap;
    }

    private boolean checkMultiEndSubject(Map<Long, Long> accountFormulaMap, Map<Long, List<AccountMember>> beginMultiMapEnd, Long beginId, Long endId) {
        List<AccountMember> accountMembers = beginMultiMapEnd.get(beginId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(accountMembers) && accountMembers.size() > 1) {
            Long onlyOneFormulaLinkBegin = accountFormulaMap.get(beginId);
            if (Objects.nonNull(onlyOneFormulaLinkBegin)) {
                return !Objects.equals(endId, onlyOneFormulaLinkBegin);
            }
            AccountMember lastOneEndMember = accountMembers.get(accountMembers.size() - 1);
            Long memId = lastOneEndMember.getId();
            return !Objects.equals(endId, memId);
        }
        return false;
    }

    protected boolean filterAdjustMember(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo) {
        return false;
    }

    private void setEnable(ReportCalcVal reportCalcValSubjectStart, ReportCalcVal reportCalcVal) {
        reportCalcValSubjectStart.setEnable(reportCalcVal.isReferenceCell());
    }

    protected boolean filterNotActAmtMetricAndResetForReference(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo) {
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        int index = dimensionIdList.indexOf(this.metricDim.getId());
        if (index == -1) {
            return true;
        }
        if (!reportCalcVal.isReferenceCell()) {
            return false;
        }
        List memberIdList = dimensionInfo.getMemberIdList();
        Object o = memberIdList.get(index);
        if (!Objects.equals(o, this.actAmtMetricMember.getId())) {
            return true;
        }
        memberIdList.set(index, this.planAmtMetricMember.getId());
        return false;
    }

    protected Map<Integer, ReportCalcVal> getAllPeriodEndSubjectRowDimInfo(ReportCalcModel reportCalcModel, Map<Long, AccountMember> periodEndMap) {
        HashMap<Integer, ReportCalcVal> subjectDimRowMap = new HashMap<Integer, ReportCalcVal>(64);
        Dimension subjectDim = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        reportCalcModel.getRowDimValList().stream().filter(reportCalcVal -> Objects.equals(reportCalcVal.getDimensionId(), subjectDim.getId())).filter(reportCalcVal -> periodEndMap.containsKey((Long)reportCalcVal.getValue())).forEach(reportCalcVal -> {
            int row;
            for (int i = row = reportCalcVal.getRow(); i < row + reportCalcVal.getRowSpan(); ++i) {
                subjectDimRowMap.put(i, (ReportCalcVal)reportCalcVal);
            }
        });
        return subjectDimRowMap;
    }

    private BiFunction<Long, Long, Long> getNextPeriodMemberFunction(Set<Long> periodEndSubjectIds) {
        ReportPeriodType reportPeriodType = this.report.getReportPeriodType();
        List<PeriodMember> periodMembers = this.report.getPeriodMemberList();
        PeriodMember currentPeriodMember = periodMembers.get(0);
        HashMap<Long, Integer> periodMemberIndex = new HashMap<Long, Integer>(periodMembers.size() * 4);
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        HashMap<Long, Integer> periodMemberRollIndex = new HashMap<Long, Integer>(periodMembers.size());
        List<PeriodMember> rollPeriodMemberList = Collections.emptyList();
        List<PeriodMember> periodMemberList = new ArrayList<PeriodMember>(periodMembers);
        if (this.needCacheRollIndex()) {
            rollPeriodMemberList = periodMembers.stream().filter(periodMember -> periodMember != currentPeriodMember).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
            this.generateIndex(rollPeriodMemberList, periodMemberRollIndex);
            periodMemberList = Collections.singletonList(currentPeriodMember);
        }
        if (EmptyUtil.isNoEmpty((Object)((Object)detailPeriodType))) {
            periodMemberList = periodMemberList.stream().map(DimMember::getChildren).flatMap(Collection::stream).map(PeriodMember.class::cast).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        }
        this.addReferencePeriodMemberIfNeed(periodMemberList);
        this.generateIndex(periodMemberList, periodMemberIndex);
        ArrayList<PeriodMember> periodMemberListFinal = periodMemberList;
        List<PeriodMember> rollPeriodMemberListFinal = rollPeriodMemberList;
        return (originalSubjectId, originalPeriodId) -> {
            if (!periodEndSubjectIds.contains(originalSubjectId)) {
                return originalPeriodId;
            }
            if (periodMemberIndex.containsKey(originalPeriodId)) {
                Long nextPeriod = this.getNextPeriod((Map<Long, Integer>)periodMemberIndex, (List<PeriodMember>)periodMemberListFinal, (Long)originalPeriodId);
                if (Objects.equals(nextPeriod, -1L)) {
                    return EmptyUtil.isNoEmpty((Object)rollPeriodMemberListFinal) ? ((PeriodMember)rollPeriodMemberListFinal.get(0)).getId() : 0L;
                }
                return nextPeriod;
            }
            if (periodMemberRollIndex.containsKey(originalPeriodId)) {
                return this.getNextPeriod((Map<Long, Integer>)periodMemberRollIndex, rollPeriodMemberListFinal, (Long)originalPeriodId);
            }
            return 0L;
        };
    }

    private void addReferencePeriodMemberIfNeed(List<PeriodMember> periodMemberList) {
        if (!Report.class.isInstance(this.report)) {
            return;
        }
        Report report$ = (Report)this.report;
        PeriodMember referencePeriodMember = report$.getReferencePeriodMember();
        if (Objects.isNull(referencePeriodMember)) {
            return;
        }
        ReportPeriodType reportPeriodType = this.report.getReportPeriodType();
        if (!Objects.equals(referencePeriodMember.getPeriodTypeId(), reportPeriodType.getReportPeriodId())) {
            return;
        }
        periodMemberList.add(0, referencePeriodMember);
    }

    private Long getNextPeriod(Map<Long, Integer> periodMemberIndex, List<PeriodMember> periodMemberList, Long originalPeriodId) {
        Integer index = periodMemberIndex.get(originalPeriodId);
        Integer nextIndex = index + 1;
        if (nextIndex > periodMemberList.size()) {
            return 0L;
        }
        if (nextIndex.intValue() == periodMemberList.size()) {
            return -1L;
        }
        return periodMemberList.get(nextIndex).getId();
    }

    private void generateIndex(List<PeriodMember> periodMemberList, Map<Long, Integer> periodMemberIndex) {
        for (int i = 0; i < periodMemberList.size(); ++i) {
            PeriodMember periodMember = periodMemberList.get(i);
            periodMemberIndex.put(periodMember.getId(), i);
        }
    }

    private boolean needCacheRollIndex() {
        ReportPeriodType reportPeriodType = this.report.getReportPeriodType();
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        if (EmptyUtil.isEmpty((Object)((Object)detailPeriodType))) {
            return false;
        }
        List<PeriodMember> periodMembers = this.report.getPeriodMemberList();
        if (EmptyUtil.isEmpty(periodMembers) || periodMembers.size() == 1) {
            return false;
        }
        if (!Report.class.isInstance(this.report)) {
            return false;
        }
        Report report$ = (Report)this.report;
        return !report$.isRollContainsDetail();
    }

    private Long updateDimensionInfoBean(DimensionInfoBean dimensionInfo, Long dimensionId, Function<Long, Long> callBack) {
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        int index = dimensionIdList.indexOf(dimensionId);
        if (index == -1) {
            return 0L;
        }
        List memberIdList = dimensionInfo.getMemberIdList();
        Long originalMemberId = (Long)memberIdList.get(index);
        memberIdList.set(index, callBack.apply(originalMemberId));
        return originalMemberId;
    }

    private void fillPeriodStartEndSubjectIds(List<TemplateAccountSetting> accountSettings, Set<Long> periodStartEndSubjectIds) {
        if (EmptyUtil.isEmpty(accountSettings)) {
            return;
        }
        for (TemplateAccountSetting accountSetting : accountSettings) {
            Long accountMemId = accountSetting.getAccountMemId();
            if (this.periodStartEndMap.containsKey(accountMemId)) {
                AccountMember accountMember = this.periodStartEndMap.get(accountMemId);
                if (accountMember.getPeriodDirection() == PeriodDirection.BEGINNING && accountSetting.getInputType() != ReportInputType.MANUAL_INPUT) continue;
                periodStartEndSubjectIds.add(accountMemId);
            }
            this.fillPeriodStartEndSubjectIds(accountSetting.getChildren(), periodStartEndSubjectIds);
        }
    }

    protected void processSummaryAndFormulaIfNeed(ReportCalcModel reportCalcModel, CalcValColQueryIndex queryIndex) {
        if (!this.needDisposeFormulaAndSummary()) {
            return;
        }
        Map<Integer, ReportCalcVal> subjectRowMap = this.getSubjectRowInfo(reportCalcModel);
        this.doProcessSummaryAndFormula(subjectRowMap, reportCalcModel, queryIndex);
    }

    protected Map<Integer, ReportCalcVal> getSubjectRowInfo(ReportCalcModel reportCalcModel) {
        List<ReportCalcVal> rowDimValList = reportCalcModel.getRowDimValList();
        Dimension subjectDimension = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        HashMap<Integer, ReportCalcVal> subjectRowMap = new HashMap<Integer, ReportCalcVal>(128);
        rowDimValList.stream().filter(reportCalcVal -> Objects.equals(reportCalcVal.getDimensionId(), subjectDimension.getId())).forEach(reportCalcVal -> {
            int row;
            for (int i = row = reportCalcVal.getRow(); i < row + reportCalcVal.getRowSpan(); ++i) {
                subjectRowMap.put(i, (ReportCalcVal)reportCalcVal);
            }
        });
        return subjectRowMap;
    }

    protected void doProcessSummaryAndFormula(Map<Integer, ReportCalcVal> subjectRowMap, ReportCalcModel reportCalcModel, CalcValColQueryIndex queryIndex) {
        ReportTemplate template = this.report.getTemplate();
        Map<Long, TemplateAccountSetting> summarySubjectMap = template.getAccountSettings().stream().filter(Objects::nonNull).filter(item -> ReportInputType.SUMMARY == item.getInputType()).collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity(), (a, b) -> a));
        Map<Long, TemplateAccountSetting> formulaSubjectMap = template.getAccountSettings().stream().filter(Objects::nonNull).filter(item -> ReportInputType.FORMULA == item.getInputType()).collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity(), (a, b) -> a));
        Map<String, ReportCalcVal> dataMap = queryIndex.getDataMap();
        ReportDataIndexQueryMap<String> indexQueryMap = queryIndex.getIndexQueryMap();
        for (ReportCalcVal reportCalcVal : dataMap.values()) {
            int row = reportCalcVal.getRow();
            ReportCalcVal subject = subjectRowMap.get(row);
            if (EmptyUtil.isEmpty((Object)subject)) {
                return;
            }
            this.processSummaryItemIfNeed(subject, reportCalcModel, summarySubjectMap, dataMap, indexQueryMap, reportCalcVal);
            this.processFormulaItemIfNeed(subject, reportCalcModel, formulaSubjectMap, dataMap, indexQueryMap, reportCalcVal);
        }
    }

    private void processFormulaItemIfNeed(ReportCalcVal subjectRowDim, ReportCalcModel reportCalcModel, Map<Long, TemplateAccountSetting> formulaSubjectMap, Map<String, ReportCalcVal> dataMap, ReportDataIndexQueryMap<String> indexQueryMap, ReportCalcVal reportCalcVal) {
        Object subjectId = subjectRowDim.getValue();
        if (!formulaSubjectMap.containsKey(subjectId)) {
            return;
        }
        TemplateAccountSetting accountSetting = formulaSubjectMap.get(subjectId);
        String formula = accountSetting.getFormula();
        if (EmptyUtil.isEmpty((String)formula)) {
            return;
        }
        Map<Long, String> subjectIdItemMap = this.getFormulaChildItem(formula);
        if (CollectionUtils.isEmpty(subjectIdItemMap)) {
            return;
        }
        DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(reportCalcVal.getCol(), reportCalcVal.getRow());
        Long subjectDimDimensionId = subjectRowDim.getDimensionId();
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        int index = dimensionIdList.indexOf(subjectDimDimensionId);
        if (index == -1) {
            return;
        }
        for (Map.Entry<Long, String> entry : subjectIdItemMap.entrySet()) {
            Long formulaChildItem = entry.getKey();
            dimensionInfo.getMemberIdList().set(index, formulaChildItem);
            String colRowInfo = indexQueryMap.find(dimensionInfo);
            if (EmptyUtil.isEmpty((String)colRowInfo)) {
                formula = formula.replace(subjectIdItemMap.get(formulaChildItem), "0");
                continue;
            }
            ReportCalcVal reportCalcValFormulaChildItem = dataMap.get(colRowInfo);
            String formulaItem = ExcelUtils.xy2Pos((int)reportCalcValFormulaChildItem.getCol(), (int)reportCalcValFormulaChildItem.getRow());
            formula = formula.replace(subjectIdItemMap.get(formulaChildItem), formulaItem);
        }
        if (EmptyUtil.isEmpty((String)formula)) {
            return;
        }
        reportCalcVal.setFormula(this.getFormula(formula, reportCalcVal, dataMap));
    }

    private Map<Long, String> getFormulaChildItem(String formula) {
        if (EmptyUtil.isEmpty((String)formula)) {
            return Collections.emptyMap();
        }
        String[] formulaItemArr = formula.replaceAll("\\(", "").replaceAll("\\)", "").split("[\\+|\\-]");
        HashMap<Long, String> subjectIdItemMap = new HashMap<Long, String>(formulaItemArr.length);
        for (String formulaItem : formulaItemArr) {
            if (!formulaItem.matches("^(\\[)[0-9]+(\\])$")) continue;
            Long subjectId = Long.valueOf(formulaItem.replace("[", "").replace("]", ""));
            subjectIdItemMap.put(subjectId, formulaItem);
        }
        return subjectIdItemMap;
    }

    private void processSummaryItemIfNeed(ReportCalcVal subjectRowDim, ReportCalcModel reportCalcModel, Map<Long, TemplateAccountSetting> summarySubjectMap, Map<String, ReportCalcVal> dataMap, ReportDataIndexQueryMap<String> indexQueryMap, ReportCalcVal reportCalcVal) {
        Long subjectDimensionId = subjectRowDim.getDimensionId();
        Object subjectId = subjectRowDim.getValue();
        if (EmptyUtil.isEmpty((Object)subjectId)) {
            return;
        }
        if (!summarySubjectMap.containsKey(subjectId)) {
            return;
        }
        TemplateAccountSetting accountSetting = summarySubjectMap.get(subjectId);
        List<TemplateAccountSetting> children = accountSetting.getChildren();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(children)) {
            return;
        }
        DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(reportCalcVal.getCol(), reportCalcVal.getRow());
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        int index = dimensionIdList.indexOf(subjectDimensionId);
        ArrayList<String> childResultList = new ArrayList<String>(64);
        for (TemplateAccountSetting child : children) {
            dimensionInfo.getMemberIdList().set(index, child.getAccountMemId());
            childResultList.addAll(indexQueryMap.findList(dimensionInfo));
        }
        if (EmptyUtil.isEmpty(childResultList)) {
            return;
        }
        List<ReportCalcVal> reportCalcValList = childResultList.stream().map(dataMap::get).collect(Collectors.toList());
        reportCalcVal.setFormula(this.getSumFormula(reportCalcVal, reportCalcValList, Collections.emptyMap()));
    }

    protected boolean needDisposeFormulaAndSummary() {
        PlanChangeReport changeReport;
        Report planReport;
        ReportTemplate template = this.report.getTemplate();
        if (template.getTemplateType() == TemplateType.DETAIL) {
            return false;
        }
        TemplateUseType templateUse = template.getTemplateUse();
        if (templateUse != TemplateUseType.PLANING) {
            return false;
        }
        if (Report.class.isInstance(this.report) && (planReport = (Report)this.report).getProcessStatus() == ReportProcessStatus.SAVE) {
            return true;
        }
        return PlanChangeReport.class.isInstance(this.report) && ((changeReport = (PlanChangeReport)this.report).getRecordBillStatus() == BillStatus.STAGE || changeReport.getRecordBillStatus() == BillStatus.COMMITTED);
    }

    protected void processSummary(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList, CalcValColQueryIndex queryIndex, Predicate<ReportCalcVal> sumPredicate, Predicate<ReportCalcVal> colLittleSumCellFilter) {
        if (EmptyUtil.isEmpty(summaryDataList)) {
            logger.info("\u4e0d\u5b58\u5728\u9700\u8981\u6c47\u603b\u7684cell");
            return;
        }
        HashSet<Integer> rowLittleSumIndex = new HashSet<Integer>(128);
        HashSet<Integer> colLittleSumIndex = new HashSet<Integer>(128);
        List littleSumCells = summaryDataList.stream().filter(sumPredicate).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(littleSumCells)) {
            logger.info("\u4e0d\u5b58\u5728\u5c0f\u8ba1\u6216\u5408\u8ba1cell");
            return;
        }
        this.fillRowAndColIndex(rowLittleSumIndex, colLittleSumIndex, reportCalcModel, colLittleSumCellFilter);
        Function<ReportCalcVal, Predicate<ReportCalcVal>> periodSummaryOnOneLevelFunction = this.getPeriodSummaryOnOneLevelFilter(reportCalcModel, rowLittleSumIndex::contains, Objects.nonNull(colLittleSumCellFilter));
        Function<ReportCalcVal, Predicate<ReportCalcVal>> duplicateSubtotalFunction = this.duplicateSubtotalFilter(reportCalcModel);
        ReportDataIndexQueryMap<String> indexQueryMap = queryIndex.getIndexQueryMap();
        Map<String, ReportCalcVal> dataMap = queryIndex.getDataMap();
        for (ReportCalcVal reportCalcVal : littleSumCells) {
            int col = reportCalcVal.getCol();
            int row = reportCalcVal.getRow();
            DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(col, row);
            this.filterNullIfNeed(dimensionInfo);
            List<String> list = indexQueryMap.findList(dimensionInfo);
            if (EmptyUtil.isEmpty(list)) continue;
            Predicate<ReportCalcVal> periodSummaryOnOneLevelFilter = periodSummaryOnOneLevelFunction.apply(reportCalcVal);
            if (this.report.getTemplate().getTemplateType() == TemplateType.DETAIL) {
                periodSummaryOnOneLevelFilter = periodSummaryOnOneLevelFilter.and(rcv -> rcv.getRow() == reportCalcVal.getRow());
            }
            if (rowLittleSumIndex.contains(row) && colLittleSumIndex.contains(col)) {
                periodSummaryOnOneLevelFilter = duplicateSubtotalFunction.apply(reportCalcVal);
            }
            List<ReportCalcVal> reportCalcValList = list.stream().distinct().map(dataMap::get).filter(Objects::nonNull).filter(periodSummaryOnOneLevelFilter).collect(Collectors.toList());
            Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
            reportCalcVal.setFormula(this.getSumFormula(reportCalcVal, reportCalcValList, currencyInfoMap));
            if (reportCalcVal.getValueType().getReportCellType() != ReportCellType.PERCENT) continue;
            this.handlePercentVal(reportCalcVal, reportCalcValList);
        }
    }

    protected void calTotalRowMetricVal(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList, Predicate<ReportCalcVal> sumPredicate, CalcValColQueryIndex queryIndex) {
        ReportTemplate template = this.report.getTemplate();
        if (template.getTemplateType() != TemplateType.FIXED) {
            return;
        }
        if (EmptyUtil.isEmpty(summaryDataList)) {
            logger.info("\u4e0d\u5b58\u5728\u9700\u8981\u6c47\u603b\u7684cell");
            return;
        }
        List littleSumCells = summaryDataList.stream().filter(sumPredicate).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(littleSumCells)) {
            logger.info("\u4e0d\u5b58\u5728\u5c0f\u8ba1\u6216\u5408\u8ba1cell");
            return;
        }
        for (ReportCalcVal reportCalcVal : littleSumCells) {
            int col = reportCalcVal.getCol();
            int row = reportCalcVal.getRow();
            DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(col, row);
            this.filterNullIfNeed(dimensionInfo);
            Long metricDimId = this.metricDim.getId();
            Object metricMemberId = dimensionInfo.getMemberByDimensionId(metricDimId);
            Optional<Object> metricMemberOpt = Optional.empty();
            if (!Objects.equals(metricMemberId, 0L)) {
                metricMemberOpt = this.metricDim.getAllDimMemberList().stream().filter(MetricMember.class::isInstance).filter(member -> Objects.equals(member.getId(), metricMemberId)).map(MetricMember.class::cast).findAny();
            }
            if (!metricMemberOpt.isPresent() || ((MetricMember)metricMemberOpt.get()).getMetricType() != MetricMemberTypeEnum.ANALYSE) continue;
            this.calTotalRowAnalyseMetricVal(reportCalcVal, dimensionInfo, (MetricMember)metricMemberOpt.get(), queryIndex, reportCalcModel);
        }
    }

    protected Function<ReportCalcVal, Predicate<ReportCalcVal>> duplicateSubtotalFilter(ReportCalcModel reportCalcModel) {
        ReportTemplate template = this.report.getTemplate();
        List<TemplateDim> colDimList = template.getColDimList();
        Optional<TemplateDim> templateDimOptional = colDimList.stream().filter(td -> td.getDimType() == DimensionType.PERIOD).sorted(Comparator.comparing(TemplateDim::getLevel)).findFirst();
        if (!templateDimOptional.isPresent()) {
            return currentLittleSumCell -> reportCalcVal -> true;
        }
        ReportPeriodType reportPeriodType = this.report.getReportPeriodType();
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        if (detailPeriodType == null) {
            return currentLittleSumCell -> reportCalcVal -> true;
        }
        ReportCalcTree colTree = reportCalcModel.getColTree();
        ReportCalcValTreeNode root = colTree.getRoot();
        TemplateDim periodDim = templateDimOptional.get();
        return currentLittleSumCell -> reportCalcVal -> {
            Optional<ReportCalcValTreeNode> first;
            List<ReportCalcValTreeNode> children = root.getChildren();
            int currentCol = currentLittleSumCell.getCol();
            for (int level = this.getRealLevelIfNeed(periodDim, colTree, (ReportCalcVal)currentLittleSumCell); level > 1 && (first = children.stream().filter(node -> node.getCol() <= currentCol && node.getCol() + node.getColSpan() - 1 >= currentCol).findFirst()).isPresent(); --level) {
                children = first.get().getChildren();
            }
            first = children.stream().filter(node -> Objects.equals(node.getCalcVal().getDimensionId(), periodDim.getDimensionId())).filter(rcv -> currentCol > rcv.getCol() && currentCol <= rcv.getCol() + rcv.getColSpan()).findFirst();
            if (!first.isPresent()) {
                return true;
            }
            ReportCalcValTreeNode treeNode = first.get();
            int colStart = treeNode.getCol();
            int colEnd = colStart + treeNode.getColSpan() - 1;
            if (treeNode.isSummary()) {
                ReportCalcValTreeNode parent = treeNode.getParent();
                Long summaryCellDimensionId = treeNode.getCalcVal().getDimensionId();
                Long parentCellDimensionId = parent.getCalcVal().getDimensionId();
                List<ReportCalcValTreeNode> parentChildren = parent.getChildren();
                colStart = Objects.equals(summaryCellDimensionId, parentCellDimensionId) ? parent.getCol() : parentChildren.get(0).getCol();
                colEnd = Objects.equals(summaryCellDimensionId, parentCellDimensionId) ? colStart + parent.getColSpan() - 1 : treeNode.getCol();
            }
            return colStart <= reportCalcVal.getCol() && colEnd > reportCalcVal.getCol();
        };
    }

    protected Map<String, Object> getCurrencyInfoMap(ReportCalcModel reportCalcModel, List<ReportCalcVal> reportCalcValList) {
        if (EmptyUtil.isEmpty(reportCalcValList)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> currencyInfoMap = new HashMap<String, Object>(16);
        for (ReportCalcVal rcv : reportCalcValList) {
            DimensionInfoBean dimensionInfoBean = reportCalcModel.getDimensionInfo(rcv.getCol(), rcv.getRow());
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            int indexOf = dimensionIdList.indexOf(this.currencyDimensionId);
            if (indexOf == -1) continue;
            String colRowInfo = String.join((CharSequence)"_", String.valueOf(rcv.getCol()), String.valueOf(rcv.getRow()));
            currencyInfoMap.put(colRowInfo, dimensionInfoBean.getMemberIdList().get(indexOf));
        }
        return currencyInfoMap;
    }

    protected BigDecimal getCurrencyRate(Long currencyId, Map<String, Object> currencyInfoMap) {
        Map<Object, BigDecimal> rateInfo = Collections.emptyMap();
        HashSet<Object> currencyIdSet = new HashSet<Object>(currencyInfoMap.values());
        if (currencyIdSet.size() > 1 && this.report instanceof Report) {
            rateInfo = ((Report)this.report).getExchangeRateMap();
        }
        return rateInfo.getOrDefault(currencyId, BigDecimal.ONE);
    }

    protected Function<ReportCalcVal, Predicate<ReportCalcVal>> getPeriodSummaryOnOneLevelFilter(ReportCalcModel reportCalcModel, Predicate<Integer> rowLittleSumFilter, boolean isSum) {
        if (isSum) {
            return currentLittleSumCell -> reportCalcVal -> true;
        }
        ReportTemplate template = this.report.getTemplate();
        List<TemplateDim> colDimList = template.getColDimList();
        Optional<TemplateDim> templateDimOptional = colDimList.stream().filter(td -> td.getDimType() == DimensionType.PERIOD).sorted(Comparator.comparing(TemplateDim::getLevel)).findFirst();
        if (!templateDimOptional.isPresent()) {
            return currentLittleSumCell -> reportCalcVal -> true;
        }
        ReportPeriodType reportPeriodType = this.report.getReportPeriodType();
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        if (detailPeriodType == null) {
            return currentLittleSumCell -> reportCalcVal -> true;
        }
        ReportCalcTree colTree = reportCalcModel.getColTree();
        ReportCalcValTreeNode root = colTree.getRoot();
        TemplateDim templateDim = templateDimOptional.get();
        return currentLittleSumCell -> reportCalcVal -> {
            Optional<ReportCalcValTreeNode> first;
            if (rowLittleSumFilter.test(currentLittleSumCell.getRow())) {
                return true;
            }
            List<ReportCalcValTreeNode> children = root.getChildren();
            int currentCol = currentLittleSumCell.getCol();
            for (int level = this.getRealLevelIfNeed(templateDim, colTree, (ReportCalcVal)currentLittleSumCell); level > 1 && (first = children.stream().filter(node -> node.getCol() <= currentCol && node.getCol() + node.getColSpan() - 1 >= currentCol).findFirst()).isPresent(); --level) {
                children = first.get().getChildren();
            }
            first = children.stream().filter(node -> Objects.equals(node.getCalcVal().getDimensionId(), templateDim.getDimensionId())).filter(ReportCalcValTreeNode::isSummary).filter(reportCalcValTreeNode -> reportCalcValTreeNode.getRow() == templateDim.getLevel() - 1).filter(reportCalcValTreeNode -> reportCalcValTreeNode.getCol() == currentLittleSumCell.getCol()).findFirst();
            if (!first.isPresent()) {
                first = children.stream().filter(node -> Objects.equals(node.getCalcVal().getDimensionId(), templateDim.getDimensionId())).filter(rcv -> currentCol > rcv.getCol() && currentCol <= rcv.getCol() + rcv.getColSpan()).findFirst();
            }
            if (!first.isPresent()) {
                return true;
            }
            ReportCalcValTreeNode treeNode = first.get();
            int colStart = treeNode.getCol();
            int colEnd = colStart + treeNode.getColSpan() - 1;
            if (treeNode.isSummary()) {
                ReportCalcValTreeNode parent = treeNode.getParent();
                Long summaryCellDimensionId = treeNode.getCalcVal().getDimensionId();
                Long parentCellDimensionId = parent.getCalcVal().getDimensionId();
                List<ReportCalcValTreeNode> parentChildren = parent.getChildren();
                colStart = Objects.equals(summaryCellDimensionId, parentCellDimensionId) ? parent.getCol() : parentChildren.get(0).getCol();
                colEnd = Objects.equals(summaryCellDimensionId, parentCellDimensionId) ? colStart + parent.getColSpan() - 1 : treeNode.getCol();
            }
            int littleColEnd = currentLittleSumCell.getCol() + currentLittleSumCell.getColSpan() - 1;
            if (currentLittleSumCell.getCol() + currentLittleSumCell.getColSpan() - 1 < colEnd) {
                colEnd = littleColEnd;
            }
            return colStart <= reportCalcVal.getCol() && colEnd > reportCalcVal.getCol() && currentLittleSumCell.getRow() == reportCalcVal.getRow();
        };
    }

    private int getRealLevelIfNeed(TemplateDim templateDim, ReportCalcTree colTree, ReportCalcVal currentLittleSumCell) {
        int level = templateDim.getLevel();
        if (!templateDim.getDimType().isPeriodDim()) {
            return level;
        }
        Report report$ = (Report)this.report;
        if (!report$.isRollContainsDetail()) {
            return level;
        }
        if (!templateDim.isExpand()) {
            return level;
        }
        ++level;
        ReportCalcValTreeNode root = colTree.getRoot();
        Optional<ReportCalcValTreeNode> first = root.getChildren().stream().filter(rcv -> Objects.equals(rcv.getCalcVal().getDimensionId(), templateDim.getDimensionId())).findFirst();
        if (!first.isPresent()) {
            return level;
        }
        ReportCalcValTreeNode treeNode = first.get();
        Optional<ReportCalcValTreeNode> summaryNodeOP = treeNode.getChildren().stream().filter(ReportCalcValTreeNode::isSummary).findFirst();
        if (treeNode.getCol() + treeNode.getColSpan() - 1 == currentLittleSumCell.getCol() && summaryNodeOP.isPresent()) {
            --level;
        }
        return level;
    }

    protected Formula getSumFormula(ReportCalcVal leftCalcVal, List<ReportCalcVal> reportCalcValList, Map<String, Object> currencyInfoMap) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(new CellReference(leftCalcVal.getRow(), leftCalcVal.getCol()).formatAsString());
        formula.setLeftVal(leftOperationVal);
        Map<Object, Object> rateInfo = Collections.emptyMap();
        HashSet<Object> currencyIdSet = new HashSet<Object>(currencyInfoMap.values());
        if (currencyIdSet.size() > 1 && this.report instanceof Report) {
            rateInfo = ((Report)this.report).getExchangeRateMap();
        }
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        for (int i = 0; i < reportCalcValList.size(); ++i) {
            ReportCalcVal reportCalcVal = reportCalcValList.get(i);
            int currCol = reportCalcVal.getCol();
            int currRow = reportCalcVal.getRow();
            String excelPost = new CellReference(currRow, currCol).formatAsString();
            FormulaOperationVal rightVal = new FormulaOperationVal();
            rightVal.setName(excelPost);
            if (reportCalcVal.getValue() != null) {
                rightVal.setValue(reportCalcVal.getValue().toString());
            }
            operator.add(rightVal);
            FormulaOperatorSymbol multiSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.MULTI);
            operator.add(multiSymbol);
            FormulaOperationVal rateVal = new FormulaOperationVal();
            String key = String.join((CharSequence)"_", String.valueOf(reportCalcVal.getCol()), String.valueOf(reportCalcVal.getRow()));
            Object currencyId = currencyInfoMap.getOrDefault(key, 0L);
            BigDecimal rate = rateInfo.getOrDefault(currencyId, BigDecimal.ONE);
            rateVal.setName(rate.toPlainString());
            rateVal.setValue(rate.toPlainString());
            rateVal.setValType(FormulaOperationValType.CONSTANT);
            operator.add(rateVal);
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.PLUS);
            operator.add(addSymbol);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(operator)) {
            operator.removeLast();
        }
        formula.setOperator(operator);
        return formula;
    }

    protected void fillRowAndColIndex(Set<Integer> rowLittleSumIndex, Set<Integer> colLittleSumIndex, ReportCalcModel reportCalcModel, Predicate<ReportCalcVal> filter) {
        List<ReportCalcVal> rowDimValList = reportCalcModel.getRowDimValList();
        List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
        rowDimValList.stream().filter(ReportCalcVal::isSummary).forEach(reportCalcVal -> {
            int row;
            for (int i = row = reportCalcVal.getRow(); i < row + reportCalcVal.getRowSpan(); ++i) {
                rowLittleSumIndex.add(i);
            }
        });
        if (EmptyUtil.isEmpty(filter)) {
            filter = reportCalcVal -> true;
        }
        colDimValList.stream().filter(ReportCalcVal::isSummary).filter(filter::test).forEach(reportCalcVal -> {
            int col;
            for (int i = col = reportCalcVal.getCol(); i < col + reportCalcVal.getColSpan(); ++i) {
                colLittleSumIndex.add(i);
            }
        });
    }

    private Formula getFormula(String excelFormula, ReportCalcVal leftCalcVal, Map<String, ReportCalcVal> dataMap) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(new CellReference(leftCalcVal.getRow(), leftCalcVal.getCol()).formatAsString());
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        excelFormula = excelFormula.replaceAll("SUM\\(", "");
        excelFormula = excelFormula.replaceAll("\\)", "");
        String regEx = "\\+|\\-";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(excelFormula);
        String[] excelPostArr = p.split(excelFormula);
        ArrayList<String> symbolArr = new ArrayList<String>(excelPostArr.length - 1);
        if (excelPostArr.length > 0) {
            for (int count = 0; count < excelPostArr.length; ++count) {
                if (!m.find()) continue;
                symbolArr.add(m.group());
            }
        }
        for (int i = 0; i < excelPostArr.length; ++i) {
            String excelPost = excelPostArr[i];
            boolean numeric = NumberUtils.isNumber((String)excelPost);
            FormulaOperationVal rightVal = new FormulaOperationVal();
            rightVal.setName(excelPost);
            if (!numeric) {
                int col = ExcelUtils.pos2X((String)excelPost);
                int row = ExcelUtils.pos2Y((String)excelPost);
                String key = String.join((CharSequence)"_", String.valueOf(col), String.valueOf(row));
                ReportCalcVal item = dataMap.get(key);
                if (EmptyUtil.isNoEmpty((Object)item) && Objects.nonNull(item.getValue())) {
                    rightVal.setValue(item.getValue().toString());
                }
            } else {
                rightVal.setValue(excelPost);
                rightVal.setValType(FormulaOperationValType.CONSTANT);
            }
            operator.add(rightVal);
            if (i >= symbolArr.size()) continue;
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.getBySymbol((String)symbolArr.get(i)));
            operator.add(addSymbol);
        }
        formula.setOperator(operator);
        return formula;
    }

    public CalcValColQueryIndex build(List<CalcValColRowInfo> calcValColRowInfoList, ReportCalcModel reportCalcModel) {
        return this.build(calcValColRowInfoList, reportCalcModel, reportCalcVal -> true);
    }

    public CalcValColQueryIndex build(List<CalcValColRowInfo> calcValColRowInfoList, ReportCalcModel reportCalcModel, Predicate<ReportCalcVal> predicate) {
        List dimensionIds;
        calcValColRowInfoList = calcValColRowInfoList.stream().filter(Objects::nonNull).filter(calcValColRowInfo -> predicate.test(calcValColRowInfo.getReportCalcVal())).collect(Collectors.toList());
        ReportDataIndexQueryMap<String> map = new ReportDataIndexQueryMap<String>(calcValColRowInfoList.size());
        Set mainDimensionIds = this.system.getMainDimList().stream().map(Dimension::getId).collect(Collectors.toSet());
        boolean enableSubjectFlowCombine = TemplateInfoHelper.hasEnableSubjectFlowCombine(this.report.getTemplate());
        if (enableSubjectFlowCombine && !org.apache.commons.collections.CollectionUtils.isEmpty(dimensionIds = reportCalcModel.getColTree().getLeafList().stream().filter(item -> item.getCalcVal().isVirtualCell()).map(item -> item.getCalcVal().getDimensionId()).collect(Collectors.toList()))) {
            mainDimensionIds.addAll(dimensionIds);
        }
        HashMap<String, ReportCalcVal> dataMap = new HashMap<String, ReportCalcVal>(calcValColRowInfoList.size());
        for (CalcValColRowInfo calcValColRowInfo2 : calcValColRowInfoList) {
            ReportCalcVal reportCalcVal = calcValColRowInfo2.getReportCalcVal();
            DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfoWithVirtual(reportCalcVal.getCol(), reportCalcVal.getRow());
            this.filterNullIfNeed(dimensionInfo);
            List dimensionIdList = dimensionInfo.getDimensionIdList();
            List memberIdList = dimensionInfo.getMemberIdList();
            for (int i = 0; i < dimensionIdList.size(); ++i) {
                Long dimensionId = (Long)dimensionIdList.get(i);
                if (!mainDimensionIds.contains(dimensionId)) continue;
                Long memberId = (Long)memberIdList.get(i);
                map.addData(dimensionId, memberId, calcValColRowInfo2.getColRow());
            }
            dataMap.put(calcValColRowInfo2.getColRow(), reportCalcVal);
        }
        return new CalcValColQueryIndex(map, dataMap);
    }

    protected void filterNullIfNeed(DimensionInfoBean dimensionInfo) {
        ReportTemplate template = this.report.getTemplate();
        if (template.getTemplateType() != TemplateType.DETAIL) {
            return;
        }
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        List memberIdList = dimensionInfo.getMemberIdList();
        for (int i = dimensionIdList.size() - 1; i >= 0; --i) {
            if (!Objects.isNull(memberIdList.get(i)) && (this.mainDimensionIds.contains(dimensionIdList.get(i)) || !this.allDimIdSet.contains(dimensionIdList.get(i)))) continue;
            memberIdList.remove(i);
            dimensionIdList.remove(i);
        }
    }

    protected void handlePercentVal(ReportCalcVal reportCalcVal, List<ReportCalcVal> reportCalcValList) {
        if (reportCalcVal.getValueType() == null || reportCalcVal.getValueType().getReportCellType() != ReportCellType.PERCENT) {
            return;
        }
        if (reportCalcVal.getFormula() == null) {
            return;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reportCalcVal.getFormula().getOperator())) {
            return;
        }
        long count = reportCalcValList.stream().filter(item -> Objects.nonNull(item.getValue())).filter(item -> {
            if (item.getValue() instanceof BigDecimal) {
                return ((BigDecimal)item.getValue()).compareTo(BigDecimal.ZERO) > 0;
            }
            if (item.getValue() instanceof Integer) {
                return ((Integer)item.getValue()).compareTo(0) > 0;
            }
            return false;
        }).count();
        if (count <= 0L) {
            return;
        }
        Deque<IFormulaOperator> operator = reportCalcVal.getFormula().getOperator();
        FormulaOperatorSymbol division = new FormulaOperatorSymbol(FormulaSymbolEnum.DIVI);
        FormulaOperatorSymbol bracketLeft = new FormulaOperatorSymbol(FormulaSymbolEnum.BRACKET_LEFT);
        FormulaOperatorSymbol bracketRight = new FormulaOperatorSymbol(FormulaSymbolEnum.BRACKET_RIGHT);
        FormulaOperationVal divisionVal = new FormulaOperationVal();
        divisionVal.setName(count + "");
        divisionVal.setValue(count + "");
        divisionVal.setValType(FormulaOperationValType.CONSTANT);
        operator.addFirst(bracketLeft);
        operator.addLast(bracketRight);
        operator.add(division);
        operator.add(divisionVal);
    }

    private void calTotalRowBaseMetricValCal(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo, CalcValColQueryIndex queryTotalRowIndex, ReportCalcModel reportCalcModel) {
        List<ReportCalcVal> reportCalcValList = this.findReportCalcValListByDimensionInfoInfo(dimensionInfo, queryTotalRowIndex);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reportCalcValList)) {
            return;
        }
        Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
        BigDecimal currBaseMetricTotalAmt = BigDecimal.ZERO;
        for (ReportCalcVal baseMetricReportCalcVal : reportCalcValList) {
            if (Objects.isNull(baseMetricReportCalcVal.getValue())) continue;
            String key = String.join((CharSequence)"_", String.valueOf(baseMetricReportCalcVal.getCol()), String.valueOf(baseMetricReportCalcVal.getRow()));
            Object currencyId = currencyInfoMap.getOrDefault(key, 0L);
            BigDecimal rate = this.getCurrencyRate((Long)currencyId, currencyInfoMap);
            BigDecimal baseMetricValAmt = rate.multiply((BigDecimal)baseMetricReportCalcVal.getValue());
            currBaseMetricTotalAmt = currBaseMetricTotalAmt.add(baseMetricValAmt);
        }
        reportCalcVal.setValue(currBaseMetricTotalAmt);
        reportCalcVal.setDisplayVal(currBaseMetricTotalAmt.toPlainString());
        reportCalcVal.setFormula(null);
    }

    private List<ReportCalcVal> findReportCalcValListByDimensionInfoInfo(DimensionInfoBean dimensionInfo, CalcValColQueryIndex queryTotalRowIndex) {
        ReportDataIndexQueryMap<String> indexQueryMap = queryTotalRowIndex.getIndexQueryMap();
        Map<String, ReportCalcVal> dataMap = queryTotalRowIndex.getDataMap();
        List<String> list = indexQueryMap.findList(dimensionInfo);
        if (EmptyUtil.isEmpty(list)) {
            return new ArrayList<ReportCalcVal>(0);
        }
        return list.stream().distinct().map(dataMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void calTotalRowAnalyseMetricVal(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo, MetricMember analyseMetricMember, CalcValColQueryIndex queryTotalRowIndex, ReportCalcModel reportCalcModel) {
        Set rowSummaryNum = reportCalcModel.getRowDimValList().stream().filter(ReportCalcVal::isSummary).map(ReportCalcVal::getRow).collect(Collectors.toSet());
        boolean isRowSummary = rowSummaryNum.contains(reportCalcVal.getRow());
        Function<ReportCalcVal, Predicate<ReportCalcVal>> periodSummaryOnOneLevelFunction = this.getPeriodSummaryOnOneLevelFilter(reportCalcModel, rowSummaryNum::contains, false);
        Predicate<ReportCalcVal> periodSummaryOnOneLevelFilter = periodSummaryOnOneLevelFunction.apply(reportCalcVal);
        HashMap<TemplateMetricType, String> calculateParam = new HashMap<TemplateMetricType, String>(8);
        List<ReportValueFormulaTypeEnum> reportValueFormulaTypeEnums = MetricValueUtils.splitFormulaBaseMetricType(analyseMetricMember.getValStr());
        for (ReportValueFormulaTypeEnum reportValueFormulaTypeEnum : reportValueFormulaTypeEnums) {
            Long subjectDimId;
            Long subjectMemId;
            AccountMember accountMember;
            TemplateMetricType templateMetricType = MetricValueUtils.switchType(reportValueFormulaTypeEnum);
            MetricMember currBaseMetricMember = this.templateMetricType2MetricMemberMap.get(templateMetricType.getCode());
            DimensionInfoBean dimensionInfoBeanCopy = dimensionInfo.copy();
            dimensionInfoBeanCopy.replaceValueIfContains(analyseMetricMember.getDimensionId(), (Object)currBaseMetricMember.getId());
            List<ReportCalcVal> reportCalcValList = this.findReportCalcValListByDimensionInfoInfo(dimensionInfoBeanCopy, queryTotalRowIndex);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(reportCalcValList)) {
                reportCalcVal.setValue(BigDecimal.ZERO);
                reportCalcVal.setDisplayVal(BigDecimal.ZERO.toPlainString());
                reportCalcVal.setFormula(null);
                return;
            }
            reportCalcValList = reportCalcValList.stream().filter(Objects::nonNull).filter(periodSummaryOnOneLevelFilter).collect(Collectors.toList());
            if (!isRowSummary && (accountMember = this.periodStartEndMap.get(subjectMemId = (Long)dimensionInfoBeanCopy.getMemberByDimensionId(subjectDimId = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS).getId()))) != null) {
                reportCalcValList = accountMember.getPeriodDirection().isBeginning() ? Collections.singletonList(reportCalcValList.get(0)) : Collections.singletonList(reportCalcValList.get(reportCalcValList.size() - 1));
            }
            Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
            BigDecimal currBaseMetricTotalAmt = BigDecimal.ZERO;
            for (ReportCalcVal baseMetricReportCalcVal : reportCalcValList) {
                if (Objects.isNull(baseMetricReportCalcVal.getValue())) continue;
                String key = String.join((CharSequence)"_", String.valueOf(baseMetricReportCalcVal.getCol()), String.valueOf(baseMetricReportCalcVal.getRow()));
                Object currencyId = currencyInfoMap.getOrDefault(key, 0L);
                BigDecimal rate = this.getCurrencyRate((Long)currencyId, currencyInfoMap);
                BigDecimal baseMetricValAmt = rate.multiply((BigDecimal)baseMetricReportCalcVal.getValue());
                currBaseMetricTotalAmt = currBaseMetricTotalAmt.add(baseMetricValAmt);
            }
            calculateParam.put(templateMetricType, currBaseMetricTotalAmt.toPlainString());
        }
        BigDecimal analyseMetricTotalAmt = MetricValueUtils.computeByExpress(analyseMetricMember, calculateParam);
        analyseMetricTotalAmt = MetricValueUtils.transferScaleIfPercent(analyseMetricMember.getDataType().isPercent(), analyseMetricTotalAmt);
        reportCalcVal.setValue(analyseMetricTotalAmt);
        reportCalcVal.setDisplayVal(analyseMetricTotalAmt.toPlainString());
        reportCalcVal.setFormula(null);
    }

    public static class CalcValColRowInfo {
        private ReportCalcVal reportCalcVal;
        private String colRow;

        public CalcValColRowInfo(ReportCalcVal reportCalcVal) {
            this.colRow = String.join((CharSequence)"_", String.valueOf(reportCalcVal.getCol()), String.valueOf(reportCalcVal.getRow()));
            this.reportCalcVal = reportCalcVal;
        }

        public ReportCalcVal getReportCalcVal() {
            return this.reportCalcVal;
        }

        public String getColRow() {
            return this.colRow;
        }
    }

    public static class CalcValColQueryIndex {
        private ReportDataIndexQueryMap<String> indexQueryMap;
        private Map<String, ReportCalcVal> dataMap;

        public CalcValColQueryIndex(ReportDataIndexQueryMap<String> indexQueryMap, Map<String, ReportCalcVal> dataMap) {
            this.indexQueryMap = indexQueryMap;
            this.dataMap = dataMap;
        }

        public ReportDataIndexQueryMap<String> getIndexQueryMap() {
            return this.indexQueryMap;
        }

        public void setIndexQueryMap(ReportDataIndexQueryMap<String> indexQueryMap) {
            this.indexQueryMap = indexQueryMap;
        }

        public Map<String, ReportCalcVal> getDataMap() {
            return this.dataMap;
        }

        public void setDataMap(Map<String, ReportCalcVal> dataMap) {
            this.dataMap = dataMap;
        }

        public List<ReportCalcVal> findList(DimensionInfoBean dimensionInfoBean) {
            return this.indexQueryMap.findList(dimensionInfoBean).stream().map(this.dataMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

