/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.common.helper.StringHelper;

public class FundPosFormsExportAction
implements IReportDataProcessAction {
    private AnalysisHeader headerInfo;
    private FundPlanSystem system;
    private static List<String> extraHeaders = new ArrayList<String>(){
        {
            this.add(ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"FundPosFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"FundPosFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FundPosFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u5934\u5bf8\u8d26\u6237", (String)"FundPosFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"FundPosFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f", (String)"FundPosFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"FundPosFormsExportAction_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    };

    public FundPosFormsExportAction(AnalysisHeader headerInfo, FundPlanSystem system) {
        this.headerInfo = headerInfo;
        this.system = system;
    }

    @Override
    public void execute(ReportModel reportModel) {
        List customDimensions;
        Optional<Dimension> settlementDimOP;
        ReportValueType textType = this.getValType(ReportCellType.TEXT, null);
        Map<Long, DimMember> dimMemberMap = this.system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(extraHeaders.size());
        for (int i = 0; i < extraHeaders.size(); ++i) {
            headerDescCalcVals.add(this.createCalcVal(extraHeaders.get(i), textType, 0, i, false));
        }
        int row = 1;
        int col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(extraHeaders.size());
        ReportCalcVal systemCalcVal = this.createCalcVal(this.system.getName(), textType, row, col++, true);
        headerValCalcVals.add(systemCalcVal);
        List<Long> orgIds = this.headerInfo.getOrg();
        String mainBodyStr = "-";
        if (EmptyUtil.isNoEmpty(orgIds)) {
            mainBodyStr = this.getMemberStr(orgIds, dimMemberMap);
        }
        ReportCalcVal mainBodyCalcVal = this.createCalcVal(mainBodyStr, textType, row, col++, true);
        headerValCalcVals.add(mainBodyCalcVal);
        List<Long> currencyIds = this.headerInfo.getCurrency();
        String currencyStr = "-";
        if (EmptyUtil.isNoEmpty(currencyIds)) {
            currencyStr = this.getMemberStr(currencyIds, dimMemberMap);
        }
        ReportCalcVal currencyCalcVal = this.createCalcVal(currencyStr, textType, row, col++, true);
        headerValCalcVals.add(currencyCalcVal);
        List<Long> fundPosAcctIds = this.headerInfo.getFundPositionAcctIds();
        String fundPosAcctStr = "-";
        if (EmptyUtil.isNoEmpty(fundPosAcctIds)) {
            DynamicObject[] fundPosAccts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", fundPosAcctIds)});
            fundPosAcctStr = Arrays.stream(fundPosAccts).filter(Objects::nonNull).map(o -> o.getString("name")).collect(Collectors.joining(","));
        }
        ReportCalcVal fundPosAcctCalcVal = this.createCalcVal(fundPosAcctStr, textType, row, col++, true);
        headerValCalcVals.add(fundPosAcctCalcVal);
        Long exchangeRateTableId = this.headerInfo.getExchangeRateTableId();
        String exchangeRateTableStr = "-";
        if (EmptyUtil.isNoEmpty((Long)exchangeRateTableId)) {
            DynamicObject exchangeRateTable = TmcDataServiceHelper.loadSingle((String)"bd_exratetable", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)exchangeRateTableId)});
            exchangeRateTableStr = Optional.ofNullable(exchangeRateTable).map(o -> o.getString("name")).orElseGet(() -> "-");
        }
        ReportCalcVal exchangeRateTableCalcVal = this.createCalcVal(exchangeRateTableStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateTableCalcVal);
        Date exchangeRateDate = this.headerInfo.getExchangeRateDate();
        String exchangeRateDateStr = Optional.ofNullable(exchangeRateDate).map(o -> DateUtils.formatString((Date)o, (String)"yyyy-MM-dd")).orElseGet(() -> "-");
        ReportCalcVal exchangeRateDateCalcVal = this.createCalcVal(exchangeRateDateStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateDateCalcVal);
        AmountUnit amountUnit = this.headerInfo.getAmountUnit();
        ReportCalcVal amountUnitCalcVal = this.createCalcVal(amountUnit.getName(), textType, row, col++, true);
        headerValCalcVals.add(amountUnitCalcVal);
        Optional<Dimension> companyDimOP = this.seekDim(DimensionType.COMPANY);
        if (companyDimOP.isPresent()) {
            headerDescCalcVals.add(this.createCalcVal(companyDimOP.get().getName(), textType, 0, headerDescCalcVals.size(), false));
            List<Long> companyIds = this.headerInfo.getCompany();
            String companyStr = "-";
            if (EmptyUtil.isNoEmpty(companyIds)) {
                companyStr = this.getMemberStr(companyIds, dimMemberMap);
            }
            ReportCalcVal companyCalcVal = this.createCalcVal(companyStr, textType, row, col++, true);
            headerValCalcVals.add(companyCalcVal);
        }
        if ((settlementDimOP = this.seekDim(DimensionType.SETTLEMENT_TYPE)).isPresent()) {
            headerDescCalcVals.add(this.createCalcVal(settlementDimOP.get().getName(), textType, 0, headerDescCalcVals.size(), false));
            List<Long> settlementIds = this.headerInfo.getSettlementMethod();
            Object settlementStr = "-";
            if (EmptyUtil.isNoEmpty(settlementIds)) {
                settlementStr = this.getMemberStr(settlementIds, dimMemberMap);
            }
            ReportCalcVal settlementCalcVal = this.createCalcVal(settlementStr, textType, row, col++, true);
            headerValCalcVals.add(settlementCalcVal);
        }
        if (!EmptyUtil.isEmpty(customDimensions = this.system.getDimList().stream().filter(Objects::nonNull).filter(dim -> dim.getDimType() == DimensionType.CUSTOM).collect(Collectors.toList()))) {
            for (Dimension customDimension : customDimensions) {
                String number = customDimension.getNumber();
                List<Long> memberIdList = this.getCustomMemberList(this.headerInfo.getCustomDimension(), number);
                headerDescCalcVals.add(this.createCalcVal(customDimension.getName(), textType, 0, headerDescCalcVals.size(), false));
                String memberStr = "-";
                if (EmptyUtil.isNoEmpty(memberIdList)) {
                    memberStr = this.getMemberStr(memberIdList, dimMemberMap);
                }
                ReportCalcVal settlementCalcVal = this.createCalcVal(memberStr, textType, row, col++, true);
                headerValCalcVals.add(settlementCalcVal);
            }
        }
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            List<ReportCalcVal> extValList = reportCalcModel.getExtValList();
            if (EmptyUtil.isEmpty(extValList)) {
                extValList = new ArrayList<ReportCalcVal>(10);
            }
            extValList.forEach(o -> o.setRow(o.getRow() + 3));
            extValList.addAll(headerDescCalcVals);
            extValList.addAll(headerValCalcVals);
            reportCalcModel.setExtValList(extValList);
            List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
            dataValList.forEach(o -> o.setRow(o.getRow() + 3));
            List<ReportCalcVal> rowDimValList = reportCalcModel.getRowDimValList();
            rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
            List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
            colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
            reportCalcModel.setRowOffset(reportCalcModel.getRowOffset() + 3);
        }
    }

    private List<Long> getCustomMemberList(Map<String, List<Long>> customDimension, String number) {
        if (EmptyUtil.isEmpty(customDimension)) {
            return Collections.emptyList();
        }
        if (!customDimension.containsKey(number)) {
            return Collections.emptyList();
        }
        return customDimension.get(number);
    }

    private String getMemberStr(List<Long> memberIds, Map<Long, DimMember> dimMemberMap) {
        return memberIds.stream().filter(Objects::nonNull).map(dimMemberMap::get).map(DimMember::getName).collect(Collectors.joining(","));
    }

    private ReportCalcVal createCalcVal(Object value, ReportValueType type, int row, int col, boolean isEnable) {
        ReportCalcVal calcVal = new ReportCalcVal();
        calcVal.setRow(row);
        calcVal.setCol(col);
        calcVal.setValue(value);
        calcVal.setEnable(isEnable);
        calcVal.setSummary(false);
        calcVal.setRemarkCell(false);
        calcVal.setDataCell(false);
        calcVal.setValueType(type);
        String displayVal = Optional.ofNullable(value).map(Object::toString).orElse("-").trim();
        calcVal.setDisplayVal(StringHelper.subString((String)displayVal, (int)30000, (String[])new String[]{";", ","}));
        calcVal.setRowSpan(1);
        calcVal.setColSpan(1);
        return calcVal;
    }

    private ReportValueType getValType(ReportCellType cellType, Object val) {
        ReportValueType valType = new ReportValueType();
        valType.setValue(val);
        valType.setReportCellType(cellType);
        return valType;
    }

    private Optional<Dimension> seekDim(DimensionType dimType) {
        return this.system.getDimList().stream().filter(Objects::nonNull).filter(dim -> dim.getDimType() == dimType).findAny();
    }
}

