/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.mvc.enums.PlanChangeReferIndex;
import kd.tmc.fpm.business.spread.generator.actions.impl.FormulaProcessV3Action;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class PlanChangeFormulaProcessV3Action
extends FormulaProcessV3Action {
    private static final Log logger = LogFactory.getLog(PlanChangeFormulaProcessV3Action.class);
    protected Dimension adjDim;
    private DimMember adjustMember;

    public PlanChangeFormulaProcessV3Action(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
        this.adjDim = system.getMainDimensionByDimType(DimensionType.ADJUSTDATATYPE);
        List<DimMember> adjDimAllDimMemberList = this.adjDim.getAllDimMemberList();
        for (DimMember dimMember : adjDimAllDimMemberList) {
            if (!dimMember.getNumber().equals(PlanChangeReferIndex.ADJUSTAMT.getValue())) continue;
            this.adjustMember = dimMember;
        }
    }

    @Override
    protected void handleBeginEndDataCell(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList, FormulaProcessV3Action.CalcValColQueryIndex queryIndex, Map<Long, AccountMember> periodEndMap) {
        if (!(this.report instanceof PlanChangeReport)) {
            return;
        }
        Map<Integer, ReportCalcVal> subjectDimRowMap = this.getAllPeriodEndSubjectRowDimInfo(reportCalcModel, periodEndMap);
        this.doProcessSetPeriodStartByPeriodEndValue(reportCalcModel, queryIndex, periodEndMap, subjectDimRowMap);
        this.resetSummaryCellForPeriodStart(reportCalcModel, summaryDataList, periodEndMap, queryIndex);
    }

    @Override
    protected boolean onlyNeedResetSummaryCell() {
        if (this.report.getTemplate().getTemplateUse() != TemplateUseType.PLANING) {
            return true;
        }
        if (!(this.report instanceof PlanChangeReport)) {
            return true;
        }
        return ((PlanChangeReport)this.report).getRecordBillStatus() != BillStatus.STAGE;
    }

    @Override
    protected boolean filterNotActAmtMetricAndResetForReference(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo) {
        return false;
    }

    @Override
    protected boolean filterAdjustMember(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo) {
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        int index = dimensionIdList.indexOf(this.adjDim.getId());
        if (index == -1) {
            return true;
        }
        List memberIdList = dimensionInfo.getMemberIdList();
        Object memberId = memberIdList.get(index);
        return !Objects.equals(memberId, this.adjustMember.getId());
    }
}

