/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaOperationValType;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.business.spread.generator.actions.impl.FormulaProcessV3Action;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.ss.util.CellReference;

public class PositionFormulaProcessAction
extends FormulaProcessV3Action {
    private Long subjectDimId;
    private Map<Long, Set<Long>> parentSubjectChildIdMap;

    public PositionFormulaProcessAction(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        this.subjectDimId = subjectDim.getId();
        this.parentSubjectChildIdMap = new HashMap<Long, Set<Long>>(64);
        List allDimMemberList = subjectDim.getAllDimMemberList().stream().map(AccountMember.class::cast).sorted(Comparator.comparing(DimMember::getLevel)).collect(Collectors.toList());
        HashMap<Long, Long> childTopIdMap = new HashMap<Long, Long>(16);
        for (AccountMember accountMember : allDimMemberList) {
            Long parentId = accountMember.getParentId();
            if (EmptyUtil.isEmpty((Long)parentId)) continue;
            Long accountMemberId = accountMember.getId();
            childTopIdMap.putIfAbsent(accountMemberId, childTopIdMap.getOrDefault(parentId, parentId));
            Set allChildIds = this.parentSubjectChildIdMap.computeIfAbsent((Long)childTopIdMap.get(accountMemberId), (Function<Long, Set<Long>>)((Function<Long, Set>)k -> new HashSet(16)));
            allChildIds.add(accountMemberId);
        }
    }

    @Override
    public void execute(ReportModel reportModel) {
        super.execute(reportModel);
        ReportCalcModel currReportCalcModel = reportModel.getReportCalcModelList().get(0);
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        List rowTotalRowList = rowDimValList.stream().filter(ReportCalcVal::isSummary).map(ReportCalcVal::getRow).collect(Collectors.toList());
        List rowTotalDataValList = dataValList.stream().filter(item -> rowTotalRowList.contains(item.getRow())).collect(Collectors.toList());
        Dimension dimension = this.system.getDimList().stream().filter(item -> item.getDimType() == DimensionType.ACCOUNTTYPE).findFirst().get();
        List<DimMember> memberList = dimension.getMemberList();
        ReportCalcVal inReCalcVal = null;
        ReportCalcVal outCalcVal = null;
        for (DimMember dimMember : memberList) {
            Optional<ReportCalcVal> first = rowDimValList.stream().filter(item -> item.getValue() != null && item.getValue().equals(dimMember.getId())).findFirst();
            if (!first.isPresent()) continue;
            ReportCalcVal reportCalcVal = first.get();
            if (dimMember.getNumber().equals(FlowEnum.INFLOW.getValue())) {
                inReCalcVal = reportCalcVal;
            }
            if (!dimMember.getNumber().equals(FlowEnum.OUTFLOW.getValue())) continue;
            outCalcVal = reportCalcVal;
        }
        ReportCalcVal inReportCalcVal = inReCalcVal;
        ReportCalcVal outReportCalcVal = outCalcVal;
        Function<List<ReportCalcVal>, List<ReportCalcVal>> allFirstSubNodeFunction = this.getAllFirstSubNodeFunction(currReportCalcModel);
        for (ReportCalcVal reportCalcVal : rowTotalDataValList) {
            String sumFormula;
            List<ReportCalcVal> allFirstSubNode;
            if (inReportCalcVal != null && reportCalcVal.getRow() >= inReportCalcVal.getRow() && reportCalcVal.getRow() <= inReportCalcVal.getEndRow()) {
                List inDataList = dataValList.stream().filter(item -> item.getRow() >= inReportCalcVal.getRow() && item.getRow() < inReportCalcVal.getEndRow() && item.getCol() == reportCalcVal.getCol()).collect(Collectors.toList());
                allFirstSubNode = allFirstSubNodeFunction.apply(inDataList);
                sumFormula = this.getSumFormula(allFirstSubNode);
                reportCalcVal.setFormula(this.getFormula(sumFormula, reportCalcVal, allFirstSubNode));
            }
            if (outReportCalcVal == null || reportCalcVal.getRow() < outReportCalcVal.getRow() || reportCalcVal.getRow() > outReportCalcVal.getEndRow()) continue;
            List outDataList = dataValList.stream().filter(item -> item.getRow() >= outReportCalcVal.getRow() && item.getRow() < outReportCalcVal.getEndRow() && item.getCol() == reportCalcVal.getCol()).collect(Collectors.toList());
            allFirstSubNode = allFirstSubNodeFunction.apply(outDataList);
            sumFormula = this.getSumFormula(allFirstSubNode);
            reportCalcVal.setFormula(this.getFormula(sumFormula, reportCalcVal, allFirstSubNode));
        }
    }

    private Function<List<ReportCalcVal>, List<ReportCalcVal>> getAllFirstSubNodeFunction(ReportCalcModel currReportCalcModel) {
        List rowDimValList = currReportCalcModel.getRowDimValList().stream().filter(rcv -> Objects.equals(rcv.getDimensionId(), this.subjectDimId)).collect(Collectors.toList());
        HashSet<Long> subjectTopWithFlowMemIds = new HashSet<Long>(16);
        HashSet currentSubjectAllChildIds = new HashSet(128);
        HashMap<Integer, Long> rowSubjectIdMap = new HashMap<Integer, Long>(rowDimValList.size());
        for (ReportCalcVal rowDimVal : rowDimValList) {
            if (rowDimVal.isSummary()) continue;
            Long currentSubjectMemId = (Long)rowDimVal.getValue();
            for (int i = 0; i <= rowDimVal.getEndRow(); ++i) {
                rowSubjectIdMap.putIfAbsent(i, currentSubjectMemId);
            }
            subjectTopWithFlowMemIds.add(currentSubjectMemId);
            currentSubjectAllChildIds.addAll(this.parentSubjectChildIdMap.getOrDefault(currentSubjectMemId, Collections.emptySet()));
            Collection intersection = CollectionUtils.intersection(currentSubjectAllChildIds, subjectTopWithFlowMemIds);
            if (!EmptyUtil.isNoEmpty((Object)intersection)) continue;
            subjectTopWithFlowMemIds.removeAll(intersection);
        }
        return dataList -> dataList.stream().filter(rcv -> subjectTopWithFlowMemIds.contains(rowSubjectIdMap.getOrDefault(rcv.getRow(), 0L))).collect(Collectors.toList());
    }

    @Override
    protected Function<ReportCalcVal, Predicate<ReportCalcVal>> getPeriodSummaryOnOneLevelFilter(ReportCalcModel reportCalcModel, Predicate<Integer> rowLittleSumFilter, boolean isSum) {
        if (isSum) {
            return currentLittleSumCell -> reportCalcVal -> true;
        }
        ReportTemplate template = this.report.getTemplate();
        List<TemplateDim> colDimList = template.getColDimList();
        Optional<TemplateDim> templateDimOptional = colDimList.stream().filter(td -> td.getDimType() == DimensionType.PERIOD).sorted(Comparator.comparing(TemplateDim::getLevel)).findFirst();
        if (!templateDimOptional.isPresent()) {
            return currentLittleSumCell -> reportCalcVal -> true;
        }
        ReportPeriodType reportPeriodType = this.report.getReportPeriodType();
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        if (detailPeriodType == null) {
            return currentLittleSumCell -> reportCalcVal -> true;
        }
        ReportCalcTree colTree = reportCalcModel.getColTree();
        ReportCalcValTreeNode root = colTree.getRoot();
        TemplateDim templateDim = templateDimOptional.get();
        return currentLittleSumCell -> reportCalcVal -> {
            Optional<ReportCalcValTreeNode> first;
            if (rowLittleSumFilter.test(currentLittleSumCell.getRow())) {
                return true;
            }
            List<ReportCalcValTreeNode> children = root.getChildren();
            int currentCol = currentLittleSumCell.getCol();
            for (int level = templateDim.getLevel(); level > 1 && (first = children.stream().filter(node -> node.getCol() <= currentCol && node.getCol() + node.getColSpan() - 1 >= currentCol).findFirst()).isPresent(); --level) {
                children = first.get().getChildren();
            }
            first = children.stream().filter(node -> Objects.equals(node.getCalcVal().getDimensionId(), templateDim.getDimensionId())).filter(ReportCalcValTreeNode::isSummary).filter(reportCalcValTreeNode -> reportCalcValTreeNode.getRow() == templateDim.getLevel() - 1).filter(reportCalcValTreeNode -> reportCalcValTreeNode.getCol() == currentLittleSumCell.getCol()).findFirst();
            if (!first.isPresent()) {
                first = children.stream().filter(node -> Objects.equals(node.getCalcVal().getDimensionId(), templateDim.getDimensionId())).filter(rcv -> currentCol > rcv.getCol() && currentCol <= rcv.getCol() + rcv.getColSpan()).findFirst();
            }
            if (!first.isPresent()) {
                return true;
            }
            ReportCalcValTreeNode treeNode = first.get();
            int colStart = treeNode.getCol();
            int colEnd = colStart + treeNode.getColSpan() - 1;
            if (treeNode.isSummary()) {
                ReportCalcValTreeNode parent = treeNode.getParent();
                Long summaryCellDimensionId = treeNode.getCalcVal().getDimensionId();
                Long parentCellDimensionId = parent.getCalcVal().getDimensionId();
                List<ReportCalcValTreeNode> parentChildren = parent.getChildren();
                colStart = Objects.equals(summaryCellDimensionId, parentCellDimensionId) ? parent.getCol() : parentChildren.get(0).getCol();
                colEnd = Objects.equals(summaryCellDimensionId, parentCellDimensionId) ? colStart + parent.getColSpan() - 1 : treeNode.getCol();
            }
            return colStart <= reportCalcVal.getCol() && colEnd > reportCalcVal.getCol() && currentLittleSumCell.getRow() == reportCalcVal.getRow();
        };
    }

    private String getSumFormula(List<ReportCalcVal> dataList) {
        String sumFormulaText = "=SUM(%s)";
        ArrayList<String> positionList = new ArrayList<String>(dataList.size());
        for (ReportCalcVal reportCalcVal : dataList) {
            String excelPosition = new CellReference(reportCalcVal.getRow(), reportCalcVal.getCol()).formatAsString();
            positionList.add(excelPosition);
        }
        return String.format(sumFormulaText, String.join((CharSequence)",", positionList));
    }

    private Formula getFormula(String excelFormula, ReportCalcVal leftCalcVal, List<ReportCalcVal> dataValList) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(new CellReference(leftCalcVal.getRow(), leftCalcVal.getCol()).formatAsString());
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        excelFormula = excelFormula.replaceAll("=SUM\\(", "");
        excelFormula = excelFormula.replaceAll("\\)", "");
        if (StringUtils.isEmpty((String)excelFormula)) {
            return null;
        }
        String regEx = "\\+|\\-|\\,";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(excelFormula);
        String[] excelPostArr = p.split(excelFormula);
        ArrayList<String> symbolArr = new ArrayList<String>(excelPostArr.length - 1);
        if (excelPostArr.length > 0) {
            for (int count = 0; count < excelPostArr.length; ++count) {
                if (!m.find()) continue;
                symbolArr.add(m.group());
            }
        }
        for (int i = 0; i < excelPostArr.length; ++i) {
            String excelPost = excelPostArr[i];
            boolean numeric = NumberUtils.isNumber((String)excelPost);
            FormulaOperationVal rightVal = new FormulaOperationVal();
            rightVal.setName(excelPost);
            if (!numeric) {
                int row = ExcelUtils.pos2X((String)excelPost);
                int col = ExcelUtils.pos2Y((String)excelPost);
                dataValList.stream().filter(item -> item.getRow() == row && item.getCol() == col).findFirst().ifPresent(item -> {
                    if (item.getValue() != null) {
                        rightVal.setValue(item.getValue().toString());
                    }
                });
            } else {
                rightVal.setValue(excelPost);
                rightVal.setValType(FormulaOperationValType.CONSTANT);
            }
            operator.add(rightVal);
            if (i >= symbolArr.size()) continue;
            if (",".equalsIgnoreCase((String)symbolArr.get(i))) {
                FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.PLUS);
                operator.add(addSymbol);
                continue;
            }
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.getBySymbol((String)symbolArr.get(i)));
            operator.add(addSymbol);
        }
        formula.setOperator(operator);
        return formula;
    }
}

