/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.provider.ReportDataBaseDataProvider;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.FlowEnum;
import org.apache.commons.lang.math.NumberUtils;

public class ReportDataProcessDetailAction
implements IReportDataProcessAction {
    private ReportDataSource report;
    private FundPlanSystem system;
    private QueryIndexInfo<String, ReportData> queryIndexInfo;
    private Map<Integer, ReportData> rowReportDataMap;
    private Map<Object, DimMember> allMemberMap;
    private ReportDataBaseDataProvider reportDataBaseDataProvider;
    private Map<Long, Dimension> dimensionMap;

    public ReportDataProcessDetailAction(FundPlanSystem system, ReportDataSource report) {
        this.report = report;
        this.system = system;
        this.allMemberMap = system.getMainDimList().stream().map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        this.reportDataBaseDataProvider = new ReportDataBaseDataProvider(report.getReportDataList());
        this.dimensionMap = system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
    }

    private void generateIndex() {
        List<ReportData> reportDataList = this.report.getReportDataList();
        List warpBeanList = reportDataList.stream().filter(rd -> !rd.isAuxiliaryInfo()).map(reportData -> {
            List dimensionIdList = reportData.getDimList().stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
            WarpBean<String, ReportData> warpBean = new WarpBean<String, ReportData>(UUID.randomUUID().toString(), DimensionInfoBean.of(dimensionIdList, reportData.getDimValList()), (ReportData)reportData);
            return warpBean;
        }).collect(Collectors.toList());
        this.queryIndexInfo = QueryIndexInfoMapGenerator.build(warpBeanList, this.system, rd -> true);
        this.rowReportDataMap = reportDataList.stream().collect(Collectors.toMap(ReportData::getRow, Function.identity(), (a, b) -> a));
    }

    @Override
    public void execute(ReportModel reportModel) {
        this.generateIndex();
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            List<ReportCalcValTreeNode> leafList = reportCalcModel.getColTree().getLeafList();
            Map<Integer, Object> colDimMap = leafList.stream().filter(node -> !node.isSummary()).filter(node -> !node.isRemark()).collect(Collectors.toMap(ReportCalcValTreeNode::getCol, ReportCalcValTreeNode::getValue));
            List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
            dataValList.sort((o1, o2) -> o2.isDataCell() ? -1 : 1);
            for (ReportCalcVal reportCalcVal : dataValList) {
                if (reportCalcVal.isSummary()) continue;
                int col = reportCalcVal.getCol();
                int row = reportCalcVal.getRow();
                this.setDimCellValueIfNeed(reportCalcVal, colDimMap);
                DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(col, row);
                this.setDataCellValueIfNeed(reportCalcVal, dimensionInfo);
            }
        }
    }

    private void setDataCellValueIfNeed(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo) {
        if (!reportCalcVal.isDataCell()) {
            return;
        }
        DimensionInfoBean copy = dimensionInfo.copy();
        this.filterEmpty(copy);
        List<ReportData> list = this.queryIndexInfo.findList(copy);
        if (EmptyUtil.isEmpty(list)) {
            return;
        }
        List reportDataList = list.stream().filter(rd -> rd.getRow() == reportCalcVal.getRow()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        if (reportDataList.size() > 1) {
            throw new KDBizException("duplicate data exists\uff01");
        }
        ReportData reportData = (ReportData)reportDataList.get(0);
        BigDecimal amtVal = reportData.getBigDecimalValue();
        if (EmptyUtil.isEmpty((BigDecimal)amtVal)) {
            amtVal = reportData.getPlanAmt();
        }
        reportCalcVal.setValue(amtVal);
        reportCalcVal.setDataId(reportData.getId());
        reportCalcVal.setDisplayVal(amtVal == null ? "" : amtVal.toString());
    }

    private void filterEmpty(DimensionInfoBean dimensionInfo) {
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        List memberIdList = dimensionInfo.getMemberIdList();
        for (int i = dimensionIdList.size() - 1; i >= 0; --i) {
            Long dimensionId = (Long)dimensionIdList.get(i);
            Dimension dimension = this.dimensionMap.get(dimensionId);
            if (Objects.isNull(dimension) || dimension.getDimType() == DimensionType.DETAILDIM) {
                memberIdList.remove(i);
                dimensionIdList.remove(i);
                continue;
            }
            Object memberId = memberIdList.get(i);
            if (!EmptyUtil.isEmpty(memberId)) continue;
            memberIdList.remove(i);
            dimensionIdList.remove(i);
        }
    }

    private void setDimCellValueIfNeed(ReportCalcVal reportCalcVal, Map<Integer, Object> colDimMap) {
        if (reportCalcVal.isDataCell()) {
            return;
        }
        Consumer<ReportData> dimMemValueCallBack = this.getDimMemValueCallBack(reportCalcVal, colDimMap);
        ReportData reportData = this.rowReportDataMap.get(reportCalcVal.getRow());
        if (EmptyUtil.isEmpty((Object)reportData)) {
            return;
        }
        dimMemValueCallBack.accept(reportData);
    }

    private Consumer<ReportData> getDimMemValueCallBack(ReportCalcVal reportCalcVal, Map<Integer, Object> colDimMap) {
        Object dimensionId = colDimMap.get(reportCalcVal.getCol());
        return reportData -> {
            if (EmptyUtil.isEmpty((Object)dimensionId)) {
                return;
            }
            if (this.dimensionMap.get(dimensionId).getDimType() == DimensionType.ACCOUNTTYPE && reportCalcVal.isVirtualCell()) {
                this.setSubjectFlowColValIfNeed(reportCalcVal, (ReportData)reportData);
                return;
            }
            List<TemplateDim> dimList = reportData.getDimList();
            Optional<TemplateDim> first = dimList.stream().filter(td -> Objects.equals(td.getDimensionId(), dimensionId)).findFirst();
            if (!first.isPresent()) {
                return;
            }
            TemplateDim templateDim = first.get();
            int index = dimList.indexOf(templateDim);
            List<Object> dimValList = reportData.getDimValList();
            Object memberId = dimValList.get(index);
            if (templateDim.isDetailDim()) {
                this.setDetailDimInfoIfNeed(reportCalcVal, (ReportData)reportData, templateDim, memberId);
                return;
            }
            DimMember dimMember = this.allMemberMap.get(memberId);
            reportCalcVal.setValue(memberId);
            if (EmptyUtil.isNoEmpty((Object)dimMember)) {
                reportCalcVal.setDisplayVal(dimMember.getName());
            }
        };
    }

    private void setDetailDimInfoIfNeed(ReportCalcVal reportCalcVal, ReportData reportData, TemplateDim templateDim, Object memberId) {
        if (!templateDim.isDetailDim()) {
            return;
        }
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        ReportValueType valueType = reportCalcVal.getValueType();
        if (templateDim.getDetailDimType() == DetailDimType.COUNTERPARTY_NAME) {
            Optional<TemplateDim> counterpartyTypeDim = dimList.stream().filter(item -> DetailDimType.CONNTERPARTY_TYPE == item.getDetailDimType()).findFirst();
            if (!counterpartyTypeDim.isPresent()) {
                return;
            }
            TemplateDim counterpartyType = counterpartyTypeDim.get();
            int typeDimIndex = dimList.indexOf(counterpartyType);
            Object counterpartyTypeValue = dimValList.get(typeDimIndex);
            valueType.setValue(counterpartyTypeValue);
        }
        this.setValueByCellType(reportCalcVal, memberId);
        if ("0".equalsIgnoreCase(reportCalcVal.getDisplayVal())) {
            reportCalcVal.setDisplayVal("");
        }
    }

    private void setValueByCellType(ReportCalcVal reportCalcVal, Object memberId) {
        ReportValueType valueType = reportCalcVal.getValueType();
        ReportCellType reportCellType = valueType.getReportCellType();
        if (Objects.isNull(memberId)) {
            return;
        }
        switch (reportCellType) {
            case MUTI_BASE_DATA: {
                Map value = (Map)valueType.getValue();
                for (Map.Entry next : value.entrySet()) {
                    if (!next.getValue().equals(memberId)) continue;
                    reportCalcVal.setDisplayVal((String)next.getKey());
                    return;
                }
                return;
            }
            case BASE_DATA: {
                if (Objects.isNull(valueType.getValue())) {
                    return;
                }
                String entityName = valueType.getValue().toString();
                DynamicObject baseData = this.reportDataBaseDataProvider.getBaseData(entityName, memberId);
                if (Objects.isNull(baseData)) {
                    return;
                }
                reportCalcVal.setDisplayVal(baseData.getString("name"));
                return;
            }
            case DATE: {
                if (!(memberId instanceof Date)) {
                    return;
                }
                String dateStr = String.format("%s", ((Date)memberId).getTime());
                reportCalcVal.setDisplayVal(dateStr);
                return;
            }
            case AMOUNT: {
                String memStr = memberId.toString();
                BigDecimal amount = BigDecimal.ZERO;
                if (NumberUtils.isNumber((String)memStr)) {
                    amount = new BigDecimal(memStr);
                }
                reportCalcVal.setDisplayVal(amount.toString());
                reportCalcVal.setValue(amount);
                return;
            }
        }
        reportCalcVal.setDisplayVal(memberId.toString());
    }

    private void setSubjectFlowColValIfNeed(ReportCalcVal reportCalcVal, ReportData reportData) {
        if (!reportCalcVal.isVirtualCell()) {
            return;
        }
        List<TemplateDim> dimList = reportData.getDimList();
        OptionalInt subjectTplDimIdx = IntStream.range(0, dimList.size()).filter(idx -> ((TemplateDim)dimList.get(idx)).getDimType() == DimensionType.SUBJECTS).findAny();
        if (!subjectTplDimIdx.isPresent()) {
            return;
        }
        List<Object> dimValList = reportData.getDimValList();
        Object subjectMemberId = dimValList.get(subjectTplDimIdx.getAsInt());
        AccountMember subjectMember = (AccountMember)this.allMemberMap.get(subjectMemberId);
        if (EmptyUtil.isNoEmpty((Object)subjectMember)) {
            String flowType = subjectMember.getFlowType().getNumber();
            Optional<String> displayValOpt = Arrays.stream(FlowEnum.values()).filter(flowEnum -> Objects.equals(flowEnum.getValue(), flowType)).map(FlowEnum::getName).findAny();
            reportCalcVal.setValue(subjectMember.getFlowType().getVirtualId());
            reportCalcVal.setDisplayVal(displayValOpt.orElse(""));
        }
    }
}

