/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.List;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.service.DetailReportDataToCalcValStrategy;
import kd.tmc.fpm.business.spread.generator.actions.service.FixReportDataToCalcValSplitStrategy;
import kd.tmc.fpm.business.spread.generator.actions.service.FixReportDataToCalcValStrategy;
import kd.tmc.fpm.business.spread.generator.actions.service.IReportDataToCalcValStrategy;
import kd.tmc.fpm.business.spread.generator.actions.service.ReportDataGetValService;

public class ReportDataProcessV2Action
implements IReportDataProcessAction {
    private ReportDataSource report;
    private FundPlanSystem system;
    private ReportDataGetValService getValService;
    private boolean isSplit;

    public ReportDataProcessV2Action(FundPlanSystem system, ReportDataSource report) {
        this.report = report;
        this.system = system;
    }

    public ReportDataProcessV2Action(FundPlanSystem system, ReportDataSource report, ReportDataGetValService getValService) {
        this.report = report;
        this.system = system;
        this.getValService = getValService;
    }

    public ReportDataProcessV2Action(FundPlanSystem system, ReportDataSource report, boolean isSplit) {
        this.report = report;
        this.system = system;
        this.isSplit = isSplit;
    }

    @Override
    public void execute(ReportModel reportModel) {
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            IReportDataToCalcValStrategy strategy = this.getIReportDataToCalcValStrategy();
            strategy.transfer(this.report, reportCalcModel);
        }
    }

    public IReportDataToCalcValStrategy getIReportDataToCalcValStrategy() {
        TemplateType templateType = this.report.getTemplate().getTemplateType();
        if (templateType == TemplateType.FIXED) {
            return this.isSplit ? new FixReportDataToCalcValSplitStrategy(this.system) : new FixReportDataToCalcValStrategy(this.system);
        }
        return new DetailReportDataToCalcValStrategy(this.system, this.getValService);
    }
}

