/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;

public class ReportDataRowResetAction
implements IReportDataProcessAction {
    private ReportDataSource report;

    public ReportDataRowResetAction(ReportDataSource report) {
        this.report = report;
    }

    @Override
    public void execute(ReportModel reportModel) {
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        HashSet<Long> resetFlagSet = new HashSet<Long>(10);
        ReportTemplate template = this.report.getTemplate();
        TemplateType templateType = template.getTemplateType();
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            Long reportId;
            if (templateType == TemplateType.FIXED) continue;
            Optional<ReportCalcVal> find = reportCalcModel.getColDimValList().stream().filter(reportCalcVal -> reportCalcVal.getDimensionName().equals("BD_NAME")).findFirst();
            Optional<TemplateDim> expandDim = template.getAllTemplateDim().stream().filter(TemplateDim::isExpand).findFirst();
            if (!find.isPresent() || expandDim.isPresent() || !resetFlagSet.add(reportId = ((Report)this.report).getId())) continue;
            int maxRow = reportCalcModel.getColDimValList().stream().filter(reportCalcVal -> reportCalcVal.getDimensionName() != null).sorted(Comparator.comparing(ReportCalcVal::getDimensionName).reversed()).max(Comparator.comparing(ReportCalcVal::getRow)).map(reportCalcVal -> "BD_NAME".equals(reportCalcVal.getDimensionName()) || "BD_NUMBER".equals(reportCalcVal.getDimensionName()) ? reportCalcVal.getRow() + 1 : reportCalcVal.getRow()).orElse(0);
            this.report.getReportDataList().forEach(reportData -> reportData.setRow(reportData.getRow() + maxRow - 1));
        }
    }
}

