/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldsUseType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateConsultSeatType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.model.template.TemplateShowConfig;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcVirtualTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;

public class ReportTemplateBuildV2Action
implements IReportDataProcessAction {
    private Log logger = LogFactory.getLog(ReportTemplateBuildV2Action.class);
    protected FundPlanSystem system;
    protected ReportDataSource report;
    protected ReportModel reportModel;
    protected Map<Object, DimMember> dimMemberMap;
    protected Dimension periodDimension;
    protected boolean hasDetailPeriod;
    protected PeriodType detailPeriodType;
    protected List<DimensionType> needLevelShowDimList;
    protected Dimension metricDimension;
    protected Dimension subjectDimension;

    public ReportTemplateBuildV2Action(FundPlanSystem system, ReportDataSource report, List<DimensionType> needLevelShowDimList) {
        this.constrMethod(system, report, needLevelShowDimList);
    }

    private ReportTemplateBuildV2Action() {
    }

    public ReportTemplateBuildV2Action(FundPlanSystem system, ReportDataSource report) {
        ArrayList<DimensionType> levelShowList = new ArrayList<DimensionType>(1);
        levelShowList.add(DimensionType.SUBJECTS);
        levelShowList.add(DimensionType.ORG);
        this.constrMethod(system, report, levelShowList);
    }

    private void constrMethod(FundPlanSystem system, ReportDataSource report, List<DimensionType> needLevelShowDimList) {
        this.system = system;
        this.report = report;
        this.needLevelShowDimList = needLevelShowDimList;
        this.dimMemberMap = this.system.getMainDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, o -> o, (a, b) -> a));
        this.periodDimension = system.getMainDimensionByDimType(DimensionType.PERIOD);
        this.metricDimension = system.getMainDimensionByDimType(DimensionType.METRIC);
        this.subjectDimension = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        this.detailPeriodType = report.getReportPeriodType().getDetailPeriodType();
        this.hasDetailPeriod = this.detailPeriodType != null;
        this.memberSort();
    }

    @Override
    public void execute(ReportModel reportModel) {
        ReportCalcTree rowTree;
        this.reportModel = reportModel;
        this.initReportTemplateModel(reportModel);
        this.initEmptyData(reportModel.getTemplateModel());
        ReportCalcTree colTree = reportModel.getTemplateModel().getColTree();
        if (colTree != null) {
            colTree.refreshTree();
        }
        if ((rowTree = reportModel.getTemplateModel().getRowTree()) != null) {
            rowTree.refreshTree();
        }
    }

    private void initTotalSummary(ReportCalcValTreeNode colRoot, DimLocation location) {
        ReportTemplate template = this.report.getTemplate();
        TemplateShowConfig config = template.getConfig();
        TemplateType templateType = template.getTemplateType();
        if (templateType != TemplateType.FIXED) {
            return;
        }
        if (!template.isTotalSumVisible()) {
            return;
        }
        if (location != DimLocation.COL) {
            return;
        }
        TemplateDim firstTplDim = template.getColDimList().stream().filter(item -> item.getLevel() == 1).findFirst().get();
        ReportCalcValTreeNode treeNode = new ReportCalcValTreeNode();
        treeNode.setDimensionId(0L);
        treeNode.setDisplayVal(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ReportTemplateBuildV2Action_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        treeNode.setParent(colRoot);
        treeNode.setSummary(true);
        ArrayList<ReportCalcValTreeNode> children = new ArrayList<ReportCalcValTreeNode>(16);
        if (template.isTotalSumDictMem()) {
            ReportCalcValTreeNode treeNode1 = colRoot.getChildren().get(0);
            List<ReportCalcValTreeNode> isPeriod = new ArrayList<ReportCalcValTreeNode>(0);
            if (firstTplDim.getDimType() == DimensionType.PERIOD && org.apache.commons.collections.CollectionUtils.isNotEmpty(this.dimMemberMap.get(firstTplDim.getMemberScope().get(0)).getChildren())) {
                ReportCalcVirtualTreeNode virtualTreeNode = new ReportCalcVirtualTreeNode();
                virtualTreeNode.setNotVirtualParent(treeNode);
                virtualTreeNode.setChildren(treeNode1.getChildren().get(0).getChildren());
                isPeriod = Collections.singletonList(virtualTreeNode);
            } else if (null != treeNode1) {
                isPeriod = this.copyChildren(treeNode1.getChildren(), true);
            }
            treeNode.setChildren(this.setNeed(isPeriod, treeNode, true));
        } else {
            TemplateDim templateDim = template.getColDimList().stream().filter(e -> e.getDimType() == DimensionType.PERIOD).findFirst().get();
            Integer max = template.getColDimList().stream().map(TemplateDim::getLevel).max(Integer::compareTo).get();
            this.createChildren(treeNode, max, org.apache.commons.collections.CollectionUtils.isEmpty(this.dimMemberMap.get(templateDim.getMemberScope().get(0)).getChildren()) ? 1 : 0);
            TemplateDim metricTplDim = template.getMetricTplDim();
            if (metricTplDim != null) {
                ReportCalcValTreeNode leaf = treeNode;
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(treeNode.getAllChildren())) {
                    for (ReportCalcValTreeNode child : treeNode.getAllChildren()) {
                        if (child.getChildren() != null) continue;
                        leaf = child;
                        break;
                    }
                }
                List metricMemberList = metricTplDim.getMemberScope().stream().map(this.dimMemberMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                for (DimMember metricMember : metricMemberList) {
                    ReportCalcValTreeNode metricNode = new ReportCalcValTreeNode();
                    metricNode.setDimensionId(metricTplDim.getDimensionId());
                    metricNode.setDimensionName(metricTplDim.getDimensionName());
                    metricNode.setDisplayVal(metricMember.getName());
                    metricNode.setParent(leaf);
                    metricNode.setMetric(true);
                    metricNode.setValue(metricMember.getId());
                    metricNode.setTotalSummary(leaf.isTotalSummary());
                    leaf.addChild(metricNode);
                }
            }
        }
        if (Objects.nonNull(config) && config.isCombineShowLast()) {
            children.addAll(colRoot.getChildren());
            children.add(treeNode);
        } else {
            children.add(treeNode);
            children.addAll(colRoot.getChildren());
        }
        treeNode.setTotalSummary(true);
        colRoot.setChildren(children);
    }

    private List<ReportCalcValTreeNode> setNeed(List<ReportCalcValTreeNode> children, ReportCalcValTreeNode treeNode, Boolean isVirtual) {
        List<ReportCalcValTreeNode> list = isVirtual != false ? children : this.copyChildren(children, false);
        list.forEach(e -> {
            e.setParent(treeNode);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(e.getChildren())) {
                e.setChildren(this.setNeed(e.getChildren(), (ReportCalcValTreeNode)e, false));
            }
        });
        return list;
    }

    private void initReferencePeriod(ReportCalcValTreeNode colRoot, DimLocation location) {
        if (!(this.report instanceof Report)) {
            return;
        }
        Report currReport = (Report)this.report;
        ReportPeriodType referencePeriodType = currReport.getReferencePeriodType();
        PeriodMember referencePeriodMember = currReport.getReferencePeriodMember();
        ReportTemplate template = currReport.getTemplate();
        if (referencePeriodType == null || referencePeriodMember == null || template.getTemplateType() == TemplateType.DETAIL || location != DimLocation.COL) {
            return;
        }
        List<TemplateDim> colDimList = template.getColDimList();
        TemplateDim periodTemplateDim = colDimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get();
        int periodTemplateDimLevel = periodTemplateDim.getLevel();
        List<TemplateReportType> reportTypeList = template.getReportTypeList();
        TemplateReportType templateReportType = reportTypeList.stream().filter(item -> item.getReportTypeId().equals(this.report.getReportPeriodType().getReportPeriodId())).findFirst().get();
        ReportCalcValTreeNode reportCalcVal = new ReportCalcValTreeNode();
        reportCalcVal.setDimensionId(this.periodDimension.getId());
        reportCalcVal.setValue(referencePeriodMember.getId());
        reportCalcVal.setDisplayVal(referencePeriodMember.getName());
        boolean isScope = org.apache.commons.collections.CollectionUtils.isNotEmpty(this.dimMemberMap.get(periodTemplateDim.getMemberScope().get(0)).getChildren());
        if (isScope) {
            this.createChildren(reportCalcVal, 1, 0);
        }
        this.copyPeriodDownDim(periodTemplateDim, reportCalcVal, colRoot);
        List<AuxiliaryField> auxiliaryFieldList = templateReportType.getAuxiliaryFieldList();
        ArrayList<ReportCalcValTreeNode> measureList = new ArrayList<ReportCalcValTreeNode>(templateReportType.getReferencePosList().size() + auxiliaryFieldList.size());
        templateReportType.getReferencePosList().forEach(e -> {
            ReportCalcValTreeNode reportType = new ReportCalcValTreeNode();
            reportType.setValue(e.getId());
            reportType.setDisplayVal(e.getName());
            reportType.setParent(reportCalcVal);
            reportType.setValue(e.getId());
            reportType.setMetric(true);
            reportType.setReference(true);
            reportType.setDimensionId(this.metricDimension.getId());
            measureList.add(reportType);
        });
        ArrayList<AuxiliaryField> treeNodes = new ArrayList<AuxiliaryField>(2);
        int max = template.getColDimList().stream().map(TemplateDim::getLevel).max(Integer::compareTo).get();
        if (EmptyUtil.isNoEmpty(auxiliaryFieldList)) {
            if (periodTemplateDimLevel > 1) {
                max = max - periodTemplateDimLevel + 1;
            }
            max = org.apache.commons.collections.CollectionUtils.isEmpty(this.dimMemberMap.get(periodTemplateDim.getMemberScope().get(0)).getChildren()) ? max : max + 1;
            for (AuxiliaryField auxiliaryField : auxiliaryFieldList) {
                if (auxiliaryField.getUseType() == AuxiliaryFieldsUseType.EXEC_DEVIATION_ANALYSIS) {
                    treeNodes.add(auxiliaryField);
                    continue;
                }
                ReportCalcValTreeNode reportType = new ReportCalcValTreeNode();
                reportType.setDimensionId(auxiliaryField.getId());
                reportType.setValue(auxiliaryField.getId());
                reportType.setDisplayVal(auxiliaryField.getName());
                reportType.setParent(reportCalcVal);
                reportType.setRemark(true);
                reportType.setReference(true);
                reportType.setUseType(auxiliaryField.getUseType());
                measureList.add(reportType);
            }
        }
        BiConsumer<ReportCalcValTreeNode, ReportCalcValTreeNode> biConsumer = this.getReferencePeriodCallBack(templateReportType, treeNodes, max);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(reportCalcVal.getAllChildren())) {
            reportCalcVal.getAllChildren().stream().filter(e -> org.apache.commons.collections.CollectionUtils.isEmpty(e.getChildren())).forEach(e -> e.setChildren(this.copyChildren((List<ReportCalcValTreeNode>)measureList, true)));
        } else {
            reportCalcVal.setChildren(measureList);
        }
        if (periodTemplateDimLevel != 1) {
            TemplateDim rootTemplate = colDimList.stream().filter(item -> item.getLevel() == periodTemplateDimLevel - 1).findFirst().get();
            List<ReportCalcValTreeNode> rootNode = colRoot.getAllChildren().stream().filter(e -> rootTemplate.getMemberScope().contains(e.getValue())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(rootNode)) {
                rootNode.forEach(item -> {
                    List<ReportCalcValTreeNode> list = this.copyChildren(Collections.singletonList(reportCalcVal), true);
                    list.get(0).getAllChildren().stream().filter(e -> e instanceof ReportCalcVirtualTreeNode).forEach(e -> {
                        e.setParent((ReportCalcValTreeNode)list.get(0));
                        ((ReportCalcVirtualTreeNode)e).setNotVirtualParent((ReportCalcValTreeNode)list.get(0));
                    });
                    biConsumer.accept((ReportCalcValTreeNode)item, list.get(0));
                });
            }
        } else {
            biConsumer.accept(colRoot, reportCalcVal);
        }
    }

    private void copyPeriodDownDim(TemplateDim periodTemplateDim, ReportCalcValTreeNode reportCalcVal, ReportCalcValTreeNode colRoot) {
        List<ReportCalcValTreeNode> children;
        int level = periodTemplateDim.getLevel();
        ReportTemplate template = this.report.getTemplate();
        List<TemplateDim> colDimList = template.getColDimList();
        ReportCalcValTreeNode periodReference = reportCalcVal;
        Integer maxLevel = colDimList.stream().map(TemplateDim::getLevel).max(Comparator.comparing(Integer::intValue)).get();
        if (level == maxLevel) {
            return;
        }
        if (this.hasDetailPeriod) {
            ++level;
            maxLevel = maxLevel + 1;
            reportCalcVal.setChildren(null);
            ReportCalcVirtualTreeNode virtualTreeNode = new ReportCalcVirtualTreeNode();
            reportCalcVal.addChild(virtualTreeNode);
            periodReference = virtualTreeNode;
        }
        int depth = level;
        ReportCalcValTreeNode parent = colRoot;
        while (level > 0 && !EmptyUtil.isEmpty(children = parent.getChildren())) {
            int i = 0;
            parent = children.get(i);
            if (parent.isTotalSummary() && i < children.size()) {
                parent = children.get(++i);
            }
            --level;
        }
        children = parent.getChildren();
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        List<ReportCalcValTreeNode> treeNodes = this.copyChildren(children, maxLevel - depth - 1);
        periodReference.setChildren(treeNodes);
    }

    private BiConsumer<ReportCalcValTreeNode, ReportCalcValTreeNode> getReferencePeriodCallBack(TemplateReportType templateReportType, List<AuxiliaryField> execBiasAnalysNodeS, int max) {
        TemplateConsultSeatType consultSeatType = templateReportType.getConsultSeatType();
        if (Objects.isNull(consultSeatType)) {
            consultSeatType = TemplateConsultSeatType.BEFORE;
        }
        TemplateConsultSeatType seatType = consultSeatType;
        BiConsumer<ReportCalcValTreeNode, ReportCalcValTreeNode> biFunction = (node1, node2) -> {
            node2.setReference(true);
            switch (seatType) {
                case BEFORE: {
                    this.addExecBiasAnalysNode((ReportCalcValTreeNode)node1, execBiasAnalysNodeS, max, (n1, n2) -> n1.addChildFirst((ReportCalcValTreeNode)n2));
                    node1.addChildFirst((ReportCalcValTreeNode)node2);
                    break;
                }
                case AFTER: {
                    node1.addChild((ReportCalcValTreeNode)node2);
                    this.addExecBiasAnalysNode((ReportCalcValTreeNode)node1, execBiasAnalysNodeS, max, (n1, n2) -> n1.addChild((ReportCalcValTreeNode)n2));
                }
            }
        };
        return biFunction;
    }

    private void addExecBiasAnalysNode(ReportCalcValTreeNode node1, List<AuxiliaryField> execBiasAnalysNodeS, int max, BiConsumer<ReportCalcValTreeNode, ReportCalcValTreeNode> consumer) {
        for (AuxiliaryField auxiliaryField : execBiasAnalysNodeS) {
            ReportCalcValTreeNode remarkValTree = new ReportCalcValTreeNode();
            remarkValTree.setDimensionId(auxiliaryField.getId());
            remarkValTree.setValue(auxiliaryField.getId());
            remarkValTree.setDisplayVal(auxiliaryField.getName());
            remarkValTree.setParent(node1);
            remarkValTree.setRemark(true);
            remarkValTree.setReference(true);
            remarkValTree.setUseType(auxiliaryField.getUseType());
            this.createChildren(remarkValTree, max, 0);
            consumer.accept(node1, remarkValTree);
        }
    }

    private void fixRowColOffSet(ReportCalcModel templateModel) {
        List<ReportCalcVal> rowDimList = templateModel.getRowDimValList();
        List<ReportCalcVal> colDimList = templateModel.getColDimValList();
        List<ReportCalcVal> dataDimList = templateModel.getDataValList();
        int maxRowLevel = rowDimList.stream().map(ReportCalcVal::getCol).max(Integer::compareTo).orElse(-1) + 1;
        int maxColLevel = colDimList.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).orElse(-1) + 1;
        templateModel.setRowOffset(maxColLevel);
        templateModel.setColOffset(maxRowLevel);
        if (maxRowLevel != 0) {
            for (ReportCalcVal col : colDimList) {
                col.setCol(col.getCol() + maxRowLevel);
            }
        }
        if (maxColLevel != 0) {
            for (ReportCalcVal row : rowDimList) {
                row.setRow(row.getRow() + maxColLevel);
            }
        }
        if (maxRowLevel != 0 || maxColLevel != 0) {
            for (ReportCalcVal val : dataDimList) {
                if (maxRowLevel != 0) {
                    val.setCol(val.getCol() + maxRowLevel);
                }
                if (maxColLevel == 0) continue;
                val.setRow(val.getRow() + maxColLevel);
            }
        }
    }

    private void initReportTemplateModel(ReportModel reportModel) {
        ReportCalcModel templateModel = new ReportCalcModel();
        reportModel.setTemplateModel(templateModel);
        ReportTemplate template = this.report.getTemplate();
        List<TemplateDim> pageDimList = template.getPageDimList();
        TemplateUseType templateUse = template.getTemplateUse();
        if (!templateUse.isStatistic() && pageDimList.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u3010%1$s\u3011\u65e0\u9875\u9762\u7ef4\u4fe1\u606f, \u8bf7\u68c0\u67e5", (String)"ReportTemplateBuildV2Action_1", (String)"tmc-fpm-business", (Object[])new Object[0]), template.getNumber()));
        }
        List<TemplateDim> colDimList = template.getColDimList();
        if (colDimList == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u3010%1$s\u3011\u5217\u7ef4\u4fe1\u606f\u914d\u7f6e\u9519\u8bef\uff1a\u5217\u7ef4\u4fe1\u606f\u7f3a\u5931, \u8bf7\u68c0\u67e5", (String)"ReportTemplateBuildV2Action_2", (String)"tmc-fpm-business", (Object[])new Object[0]), template.getNumber()));
        }
        colDimList.sort(Comparator.comparing(TemplateDim::getLevel));
        if (template.getTemplateType() == TemplateType.FIXED) {
            if (template.getMetricTplDim() != null) {
                colDimList.add(template.getMetricTplDim());
            }
            List<ReportCalcVal> colList = this.buildRowColDimValList(colDimList, DimLocation.COL);
            templateModel.setColDimValList(colList);
            List<TemplateDim> rowDimList = template.getRowDimList();
            if (rowDimList == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u3010%1$s\u3011\u884c\u7ef4\u4fe1\u606f\u914d\u7f6e\u9519\u8bef\uff1a\u884c\u7ef4\u4fe1\u606f\u7f3a\u5931, \u8bf7\u68c0\u67e5", (String)"ReportTemplateBuildV2Action_3", (String)"tmc-fpm-business", (Object[])new Object[0]), template.getNumber()));
            }
            rowDimList.sort(Comparator.comparing(TemplateDim::getLevel));
            List<ReportCalcVal> rowList = this.buildRowColDimValList(rowDimList, DimLocation.ROW);
            templateModel.setRowDimValList(rowList);
        } else {
            List<ReportCalcVal> colList = this.buildDetailColDimValListForTree(colDimList);
            templateModel.setColDimValList(colList);
            templateModel.setRowDimValList(Collections.emptyList());
        }
    }

    protected List<ReportCalcVal> buildDetailColDimValListForTree(List<TemplateDim> dimList) {
        TemplateDim templateDim;
        ReportCalcValTreeNode colRoot = new ReportCalcValTreeNode();
        List<Dimension> systemDimList = this.system.getDimList();
        Map systemDimMap = systemDimList.stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        Optional<TemplateDim> first = dimList.stream().filter(dim -> !dim.isViDim()).filter(TemplateDim::isExpand).findFirst();
        Supplier<List> supplier = Collections::emptyList;
        int maxDepth = 1;
        if (first.isPresent()) {
            ReportCalcValTreeNode node = new ReportCalcValTreeNode();
            this.buildReportDimTree(Collections.singletonList(first.get()), 0, 1, node, null, DimLocation.COL, 0);
            List<ReportCalcValTreeNode> children = node.getChildren();
            while (EmptyUtil.isNoEmpty((Object)children)) {
                ReportCalcValTreeNode anyChild = (ReportCalcValTreeNode)children.get(0);
                children = anyChild.getChildren();
                ++maxDepth;
            }
            supplier = node::getChildren;
        }
        Long expandedDimensionId = 0L;
        for (TemplateDim currDim : dimList) {
            if (this.skipVirtualDim(currDim)) continue;
            ReportCalcValTreeNode treeNode = new ReportCalcValTreeNode();
            treeNode.setDimensionName(currDim.getDimensionName());
            treeNode.setDimensionId(currDim.getDimensionId());
            treeNode.setDisplayVal(currDim.getDimensionName());
            treeNode.setValue(currDim.getDimensionId());
            ReportValueType reportValueType = new ReportValueType();
            reportValueType.setReportCellType(ReportCellType.TEXT);
            treeNode.getCalcVal().setValueType(reportValueType);
            treeNode.getCalcVal().setVirtualCell(currDim.isViDim());
            Dimension dimension = (Dimension)systemDimMap.get(currDim.getDimensionId());
            if (!currDim.isViDim() && Objects.nonNull(dimension)) {
                if (dimension.isMustInput()) {
                    treeNode.setDisplayType(DisplayTypeEnum.MUSTRECORD);
                }
                this.setDimensionValueTypeIfNeed(dimension, treeNode, reportValueType);
            }
            if (currDim.isExpand()) {
                if (EmptyUtil.isNoEmpty((Long)expandedDimensionId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u3010%1$s\u3011\u5217\u7ef4\u4fe1\u606f\u914d\u7f6e\u9519\u8bef\uff1a\u4ec5\u5141\u8bb8\u4e00\u4e2a\u5217\u6210\u5458\u5e73\u94fa\u5c55\u5f00, \u8bf7\u68c0\u67e5", (String)"ReportTemplateBuildV2Action_4", (String)"tmc-fpm-business", (Object[])new Object[0]), this.report.getTemplate().getNumber()));
                }
                expandedDimensionId = currDim.getDimensionId();
                treeNode.setChildren(supplier.get());
                treeNode.setSkipVal(true);
            } else {
                if (!currDim.isVisible()) continue;
                this.createChildren(treeNode, maxDepth, 1);
            }
            colRoot.addChild(treeNode);
        }
        if (first.isPresent() && (templateDim = first.get()).getDimType() == DimensionType.PERIOD) {
            templateDim.setLevel(templateDim.getLevel() + 1);
            this.addVirtualNodeForPeriodHasDetailIfNeed(colRoot, Collections.singletonList(first.get()), DimLocation.COL);
            this.replaceDetailPeriodWithVirtualNode(colRoot, Collections.singletonList(first.get()), DimLocation.COL);
            templateDim.setLevel(templateDim.getLevel() - 1);
        }
        this.initRemarkCol(DimLocation.COL, colRoot, this.report.getTemplate());
        this.rebuildRowColInfo(colRoot, DimLocation.COL);
        this.removeVirtualNodeAndRebuildRowColSpan(colRoot, DimLocation.COL);
        if (this.report.getTemplate().isRemarkVisible()) {
            ReportCalcValTreeNode lastSecondNode = colRoot.getChildren().get(colRoot.getChildren().size() - 2);
            ReportCalcValTreeNode remarkColNode = colRoot.getChildren().get(colRoot.getChildren().size() - 1);
            int maxRowSpan = 1;
            for (int i = 0; i < colRoot.getChildren().size() - 1; ++i) {
                maxRowSpan = Math.max(colRoot.getChildren().get(i).getRowSpan(), maxRowSpan);
            }
            remarkColNode.setCol(lastSecondNode.getColEnd() + 1);
            remarkColNode.setColSpan(1);
            remarkColNode.setRowSpan(maxRowSpan);
        }
        this.reportModel.getTemplateModel().setColTree(new ReportCalcTree(colRoot));
        return colRoot.getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
    }

    private void setDimensionValueTypeIfNeed(Dimension dimension, ReportCalcValTreeNode treeNode, ReportValueType reportValueType) {
        if (dimension.getDimType() != DimensionType.DETAILDIM) {
            return;
        }
        DetailDimType detailDimType = dimension.getDetailDimType();
        switch (detailDimType) {
            case PLAN_AMOUNT: {
                treeNode.setSkipVal(true);
                break;
            }
            case CONNTERPARTY_TYPE: {
                reportValueType.setReportCellType(ReportCellType.MUTI_BASE_DATA);
                List extValList = JSONArray.parseArray((String)DetailDimType.CONNTERPARTY_TYPE.getExtVal().toString(), JSONObject.class);
                HashMap<String, String> extMap = new HashMap<String, String>(extValList.size());
                for (JSONObject o : extValList) {
                    extMap.put(o.getString("value"), o.getString("key"));
                }
                reportValueType.setValue(extMap);
                break;
            }
            default: {
                Object extVal = detailDimType.getExtVal();
                if (Objects.isNull(extVal)) break;
                reportValueType.setReportCellType(ReportCellType.BASE_DATA);
                reportValueType.setValue(extVal);
            }
        }
    }

    private List<ReportCalcVal> buildRowColDimValList(List<TemplateDim> dimList, DimLocation location) {
        ReportTemplate template = this.report.getTemplate();
        ArrayList<ReportCalcVal> colList = new ArrayList<ReportCalcVal>(10);
        ReportCalcValTreeNode root = new ReportCalcValTreeNode();
        List<TemplateDim> finalDimList = dimList.stream().filter(item -> DetailDimType.REMARK != item.getDetailDimType()).collect(Collectors.toList());
        this.buildReportDimTree(finalDimList, 0, 0, root, null, location, 0);
        this.initTotalSummary(root, location);
        this.initRemarkCol(location, root, template);
        this.addVirtualNodeForPeriodHasDetailIfNeed(root, dimList, location);
        this.addSummaryIfNeed(root, dimList, location);
        this.replaceDetailPeriodWithVirtualNode(root, dimList, location);
        this.initReferencePeriod(root, location);
        this.rebuildRowColInfo(root, location);
        this.removeVirtualNodeAndRebuildRowColSpan(root, location);
        this.fillSubjectHideInReport(template, root);
        this.fillTreeIntoModel(location, colList, root);
        return colList;
    }

    private void fillSubjectHideInReport(ReportTemplate template, ReportCalcValTreeNode root) {
        Map settingMap = template.getAccountSettings().stream().map(item -> {
            ArrayList<TemplateAccountSetting> result = new ArrayList<TemplateAccountSetting>(item.getAllChildSetting());
            result.add((TemplateAccountSetting)item);
            return result;
        }).flatMap(Collection::stream).collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity(), (a, b) -> a));
        List subjectNodes = root.getAllChildren().stream().filter(item -> Objects.nonNull(item.getCalcVal())).filter(item -> Objects.equals(item.getCalcVal().getDimensionId(), this.subjectDimension.getId())).collect(Collectors.toList());
        for (ReportCalcValTreeNode node : subjectNodes) {
            TemplateAccountSetting setting;
            ReportCalcVal calcVal = node.getCalcVal();
            if (!(calcVal.getValue() instanceof Long) || Objects.isNull(setting = (TemplateAccountSetting)settingMap.get((Long)calcVal.getValue()))) continue;
            calcVal.setHide(setting.isHideInReport());
        }
    }

    private void fillTreeIntoModel(DimLocation location, List<ReportCalcVal> colList, ReportCalcValTreeNode root) {
        List currColList = root.getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        colList.addAll(currColList);
        if (location == DimLocation.COL) {
            this.reportModel.getTemplateModel().setColTree(new ReportCalcTree(root));
        }
        if (location == DimLocation.ROW) {
            this.reportModel.getTemplateModel().setRowTree(new ReportCalcTree(root));
        }
    }

    private void initRemarkCol(DimLocation location, ReportCalcValTreeNode colRoot, ReportTemplate template) {
        if (template.isRemarkVisible() && location == DimLocation.COL) {
            int max = template.getColDimList().stream().map(TemplateDim::getLevel).max(Integer::compareTo).get();
            TemplateDim templateDim = template.getColDimList().stream().filter(e -> e.getDimType() == DimensionType.PERIOD).findFirst().get();
            max = org.apache.commons.collections.CollectionUtils.isEmpty(this.dimMemberMap.get(templateDim.getMemberScope().get(0)).getChildren()) ? max : max + 1;
            List<AuxiliaryField> remarkEntityList = template.getRemarkEntityList();
            for (AuxiliaryField remark : remarkEntityList) {
                ReportCalcValTreeNode remarkValTree = new ReportCalcValTreeNode();
                remarkValTree.setDimensionId(remark.getId());
                remarkValTree.setDimensionName(remark.getName());
                remarkValTree.setDisplayVal(remark.getName());
                remarkValTree.setRemark(true);
                remarkValTree.setParent(colRoot);
                colRoot.getChildren().add(remarkValTree);
                this.createChildren(remarkValTree, max, 0);
            }
        }
    }

    protected void replaceDetailPeriodWithVirtualNode(ReportCalcValTreeNode colRoot, List<TemplateDim> dimList, DimLocation location) {
        Optional<TemplateDim> first = this.getPeriodDimContainDetail(colRoot, dimList, location);
        if (!first.isPresent()) {
            return;
        }
        TemplateDim templateDim = first.get();
        List<Long> memberScope = templateDim.getMemberScope();
        Long reportTypeId = memberScope.stream().map(this.dimMemberMap::get).map(PeriodMember.class::cast).map(PeriodMember::getPeriodTypeId).findFirst().get();
        Optional<ReportPeriodType> reportPeriodType = this.system.getReportTypeList().stream().filter(rt -> Objects.equals(reportTypeId, rt.getReportPeriodId())).findFirst();
        if (!reportPeriodType.isPresent()) {
            return;
        }
        if (!(this.report instanceof Report) && !(this.report instanceof PlanChangeReport)) {
            return;
        }
        if (this.report.getPeriodMemberList().size() == 1) {
            return;
        }
        PeriodMember periodMember = this.report.getPeriodMemberList().get(0);
        boolean isRollContainsDetail = this.report instanceof Report ? ((Report)this.report).isRollContainsDetail() : ((PlanChangeReport)this.report).isRollContainsDetail();
        if (isRollContainsDetail) {
            return;
        }
        List<ReportCalcValTreeNode> periodParentNodes = Collections.singletonList(colRoot);
        List<ReportCalcValTreeNode> tempChildren = colRoot.getChildren();
        for (int level = templateDim.getLevel(); level > 1 && !EmptyUtil.isEmpty(tempChildren); --level) {
            periodParentNodes = tempChildren;
            tempChildren = tempChildren.stream().map(ReportCalcValTreeNode::getChildren).flatMap(Collection::stream).collect(Collectors.toList());
        }
        for (ReportCalcValTreeNode parentNode : periodParentNodes) {
            ArrayList<ReportCalcValTreeNode> children = new ArrayList<ReportCalcValTreeNode>(parentNode.getChildren().stream().filter(node -> Objects.equals(templateDim.getDimensionId(), node.getCalcVal().getDimensionId())).collect(Collectors.toList()));
            if (EmptyUtil.isEmpty(children)) continue;
            children.removeIf(node -> templateDim.getLevel() == 1 && node.isTotalSummary());
            if (!this.isCanReplaceRollDetail(children, templateDim)) continue;
            for (int i = 0; i < memberScope.size(); ++i) {
                ReportCalcValTreeNode treeNode;
                List<ReportCalcValTreeNode> rollChildren;
                Long periodMemberId = memberScope.get(i);
                PeriodMember dimMember = (PeriodMember)this.dimMemberMap.get(periodMemberId);
                if (dimMember.getStartDate().compareTo(periodMember.getEndDate()) <= 0 || EmptyUtil.isEmpty(rollChildren = (treeNode = (ReportCalcValTreeNode)children.get(i)).getChildren())) continue;
                ReportCalcValTreeNode rollDetailChildNode = rollChildren.get(0);
                rollChildren.clear();
                ReportCalcVirtualTreeNode virtualTreeNode = new ReportCalcVirtualTreeNode();
                virtualTreeNode.setChildren(rollDetailChildNode.getChildren());
                treeNode.addChild(virtualTreeNode);
                treeNode.setRollCell(true);
                treeNode.setSkipVal(false);
            }
        }
    }

    private boolean isCanReplaceRollDetail(List<ReportCalcValTreeNode> children, TemplateDim periodDim) {
        if (!periodDim.getDimType().isPeriodDim()) {
            return false;
        }
        if (children.size() == 1) {
            return false;
        }
        if (children.size() == periodDim.getMemberScope().size()) {
            return true;
        }
        if (children.size() == periodDim.getMemberScope().size() + 1) {
            return children.get(children.size() - 1).isSummary();
        }
        return false;
    }

    protected Optional<TemplateDim> getPeriodDimContainDetail(ReportCalcValTreeNode colRoot, List<TemplateDim> dimList, DimLocation location) {
        List<ReportCalcValTreeNode> children = colRoot.getChildren();
        Optional<TemplateDim> empty = Optional.empty();
        if (EmptyUtil.isEmpty(children)) {
            return empty;
        }
        if (!this.hasDetailPeriod) {
            return empty;
        }
        Optional<TemplateDim> first = dimList.stream().filter(templateDim -> templateDim.getLocation() == location).filter(templateDim -> templateDim.getDimType() == DimensionType.PERIOD).findFirst();
        return first;
    }

    protected void addVirtualNodeForPeriodHasDetailIfNeed(ReportCalcValTreeNode colRoot, List<TemplateDim> dimList, DimLocation location) {
        boolean hasPeriodSummary;
        if (location != DimLocation.COL) {
            return;
        }
        if (!this.hasDetailPeriod) {
            return;
        }
        Optional<TemplateDim> first = dimList.stream().filter(templateDim -> templateDim.getLocation() == location).filter(templateDim -> templateDim.getDimType() == DimensionType.PERIOD).findFirst();
        if (!first.isPresent()) {
            return;
        }
        TemplateDim templateDim2 = first.get();
        Long dimensionId = templateDim2.getDimensionId();
        if (!templateDim2.isIncludeSum()) {
            return;
        }
        List<Object> periodParentNodes = Collections.emptyList();
        List<ReportCalcValTreeNode> tempChildren = colRoot.getChildren();
        for (int level = templateDim2.getLevel(); level > 1 && !EmptyUtil.isEmpty(tempChildren); --level) {
            periodParentNodes = tempChildren;
            tempChildren = tempChildren.stream().map(ReportCalcValTreeNode::getChildren).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(periodParentNodes) && (hasPeriodSummary = tempChildren.stream().filter(i -> Objects.nonNull(i.getCalcVal().getDimensionId()) && NumberUtils.equals((Long)i.getCalcVal().getDimensionId(), (Long)dimensionId)).anyMatch(i -> i.isSummary() && !i.isTotalSummary()))) {
            periodParentNodes = Collections.singletonList(colRoot);
        }
        for (ReportCalcValTreeNode periodNode : periodParentNodes) {
            ReportCalcValTreeNode subSumNode;
            List<ReportCalcValTreeNode> periodAndSubSumNode = periodNode.getChildren();
            if (org.apache.commons.collections.CollectionUtils.isEmpty(periodAndSubSumNode) || ReportCalcVirtualTreeNode.class.isInstance(subSumNode = periodAndSubSumNode.get(periodAndSubSumNode.size() - 1))) continue;
            List<ReportCalcValTreeNode> children = subSumNode.getChildren();
            subSumNode.setChildren(null);
            ReportCalcVirtualTreeNode virtualTreeNode = new ReportCalcVirtualTreeNode();
            subSumNode.addChild(virtualTreeNode);
            virtualTreeNode.setChildren(children);
        }
    }

    protected void addSummaryIfNeed(ReportCalcValTreeNode colRoot, List<TemplateDim> dimList, DimLocation location) {
        if (location != DimLocation.COL) {
            return;
        }
        ReportTemplate template = this.report.getTemplate();
        TemplateShowConfig config = template.getConfig();
        if (Objects.isNull(config) || !config.isSummaryShow()) {
            return;
        }
        Optional<TemplateDim> first = dimList.stream().filter(templateDim -> templateDim.getLocation() == location).filter(templateDim -> templateDim.getDimType() == DimensionType.PERIOD).findFirst();
        if (!first.isPresent()) {
            return;
        }
        TemplateDim templateDim2 = first.get();
        if (!templateDim2.isIncludeSum()) {
            return;
        }
        List<Object> periodParentNodes = Collections.emptyList();
        List<ReportCalcValTreeNode> tempChildren = colRoot.getChildren();
        for (int level = templateDim2.getLevel(); level > 1 && !EmptyUtil.isEmpty(tempChildren); --level) {
            periodParentNodes = tempChildren;
            tempChildren = tempChildren.stream().map(ReportCalcValTreeNode::getChildren).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(periodParentNodes)) {
            return;
        }
        for (ReportCalcValTreeNode periodParentNode : periodParentNodes) {
            ReportCalcValTreeNode sumValTree = new ReportCalcValTreeNode();
            sumValTree.setDimensionId(0L);
            sumValTree.setDisplayVal(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ReportTemplateBuildV2Action_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
            sumValTree.setSummary(true);
            sumValTree.setRow(1);
            sumValTree.setRowSpan(0);
            sumValTree.setColSpan(1);
            sumValTree.setParent(periodParentNode);
            periodParentNode.getChildren().add(sumValTree);
            sumValTree.setChildren(this.copyChildren(periodParentNode.getChildren().get(0).getChildren(), true));
        }
    }

    protected int buildReportDimTree(List<TemplateDim> dimList, int index, int height, ReportCalcValTreeNode parent, List<Long> memberIdList, DimLocation location, int rowCol) {
        if (index > dimList.size() - 1) {
            return 1;
        }
        int leafCnt = 0;
        ReportTemplate template = this.report.getTemplate();
        TemplateDim currDim = dimList.get(index);
        if (memberIdList == null) {
            memberIdList = currDim.getMemberScope();
        }
        List dimMemberList = memberIdList.stream().map(this.dimMemberMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        boolean includeSum = currDim.isIncludeSum();
        Integer maxLevel = dimList.stream().map(item -> item.getLevel()).max(Integer::compareTo).get();
        if (includeSum && currDim.getLevel() < maxLevel) {
            DimMember dimMember = new DimMember();
            dimMember.setName(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ReportTemplateBuildV2Action_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
            dimMemberList.add(dimMember);
        }
        boolean isReportPeriodMember = false;
        ArrayList<ReportCalcValTreeNode> childList = new ArrayList<ReportCalcValTreeNode>(dimMemberList.size());
        ReportCalcValTreeNode valTree = null;
        Integer dimMemberMinLevel = dimMemberList.stream().map(DimMember::getLevel).min(Integer::compareTo).get();
        for (DimMember dimMember : dimMemberList) {
            int curLeafCnt;
            valTree = new ReportCalcValTreeNode();
            valTree.setParent(parent);
            valTree.setSkipVal(Boolean.FALSE);
            valTree.setDimensionName(currDim.getDimensionName());
            valTree.setDimensionId(currDim.getDimensionId());
            valTree.setValue(dimMember.getId());
            valTree.setDisplayVal(dimMember.getName());
            if (includeSum && dimMember.getId() == null) {
                valTree.setSummary(true);
            }
            if (dimMember instanceof MetricMember) {
                valTree.setMetric(true);
            }
            isReportPeriodMember = this.hasDetailPeriod && currDim.getDimensionId().equals(this.periodDimension.getId()) && dimMember instanceof PeriodMember && ((PeriodMember)dimMember).getPeriodType() != this.detailPeriodType;
            int tRowSpan = 1;
            Integer sumLevel = dimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).map(item -> item.getLevel()).min(Integer::compareTo).orElse(1);
            if (this.system.getMainDimensionByDimType(DimensionType.AMTTYPE) != null && currDim.getDimType() == DimensionType.PERIOD && this.hasDetailPeriod && !isReportPeriodMember && valTree.isSummary() && currDim.getLevel() < maxLevel && dimMember.getId() == null && height == sumLevel - 1) {
                tRowSpan = 1 + maxLevel - currDim.getLevel();
                valTree.setDisplayVal(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ReportTemplateBuildV2Action_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            if (isReportPeriodMember) {
                List<PeriodMember> detailPeriodMemberList = ((PeriodMember)dimMember).getChildMemberByPeriodTypeAndPeriodId(this.detailPeriodType, this.report.getReportPeriodType().getReportPeriodId());
                List<Long> detailPeriodMemberIdList = detailPeriodMemberList.stream().sorted(Comparator.comparing(DimMember::getLongNumber)).map(DimMember::getId).collect(Collectors.toList());
                curLeafCnt = this.buildReportDimTree(dimList, index, height + 1, valTree, detailPeriodMemberIdList, location, rowCol);
                valTree.setSkipVal(true);
                if (this.isRealNeedSum(currDim)) {
                    ReportCalcValTreeNode reportCalcValTree = valTree.getChildren().get(valTree.getChildren().size() - 1);
                    ReportCalcValTreeNode sumValTree = new ReportCalcValTreeNode();
                    sumValTree.setDimensionName(currDim.getDimensionName());
                    sumValTree.setDimensionId(currDim.getDimensionId());
                    sumValTree.setDisplayVal(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ReportTemplateBuildV2Action_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    sumValTree.setSummary(true);
                    sumValTree.setRow(reportCalcValTree.getRow());
                    sumValTree.setRowSpan(reportCalcValTree.getRowSpan());
                    sumValTree.setColSpan(reportCalcValTree.getColSpan());
                    valTree.getChildren().add(sumValTree);
                    if (CollectionUtils.isNotEmpty(reportCalcValTree.getChildren())) {
                        sumValTree.setCol(reportCalcValTree.getCol() + reportCalcValTree.getColSpan());
                        sumValTree.setChildren(this.moveChildren(reportCalcValTree.getColSpan(), this.copyChildren(reportCalcValTree.getChildren(), false)));
                        curLeafCnt += reportCalcValTree.getColSpan();
                    } else {
                        sumValTree.setCol(reportCalcValTree.getCol() + 1);
                        ++curLeafCnt;
                    }
                }
            } else {
                curLeafCnt = this.buildReportDimTree(dimList, index + 1, height + tRowSpan, valTree, null, location, rowCol);
            }
            if (location == DimLocation.ROW) {
                valTree.setRow(rowCol);
                valTree.setRowSpan(curLeafCnt);
                valTree.setCol(height);
                valTree.setColSpan(1);
            } else {
                valTree.setRow(height);
                valTree.setRowSpan(tRowSpan);
                valTree.setCol(rowCol);
                valTree.setColSpan(curLeafCnt);
            }
            if (this.needLevelShowDimList.contains((Object)currDim.getDimType())) {
                valTree.setLevel(dimMember.getLevel() - dimMemberMinLevel + 1);
            }
            leafCnt += curLeafCnt;
            rowCol += curLeafCnt;
            childList.add(valTree);
        }
        if (currDim.getLevel() == maxLevel.intValue() && valTree != null && includeSum && (currDim.getDimType() == DimensionType.PERIOD && isReportPeriodMember || !currDim.isIncludeSubSum() && currDim.getDimType() == DimensionType.PERIOD && !this.hasDetailPeriod || currDim.isIncludeSubSum() && currDim.getDimType() == DimensionType.PERIOD && this.hasDetailPeriod || currDim.getDimType() != DimensionType.PERIOD)) {
            ReportCalcValTreeNode sumValTree = new ReportCalcValTreeNode();
            sumValTree.setDimensionName(currDim.getDimensionName());
            sumValTree.setDimensionId(currDim.getDimensionId());
            sumValTree.setDisplayVal(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ReportTemplateBuildV2Action_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
            sumValTree.setSummary(true);
            if (location == DimLocation.ROW) {
                Integer maxChildCol = Optional.of(valTree.getAllChildren().stream().map(ReportCalcValTreeNode::getCol).max(Integer::compareTo)).get().orElse(height);
                sumValTree.setRow(rowCol);
                sumValTree.setCol(height);
                sumValTree.setRowSpan(1);
                sumValTree.setColSpan(maxChildCol - height + 1);
            } else {
                Integer maxChildRow = Optional.of(valTree.getAllChildren().stream().map(ReportCalcValTreeNode::getRow).max(Integer::compareTo)).get().orElse(height);
                sumValTree.setRow(height);
                sumValTree.setCol(rowCol);
                sumValTree.setRowSpan(maxChildRow - height + 1);
                sumValTree.setColSpan(1);
                TemplateDim metricTplDim = this.report.getTemplate().getMetricTplDim();
                if (metricTplDim != null && this.report.getTemplate().getTemplateType() != TemplateType.DETAIL) {
                    List metricMemberList = metricTplDim.getMemberScope().stream().map(this.dimMemberMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                    for (DimMember metricMember : metricMemberList) {
                        ReportCalcValTreeNode metricNode = new ReportCalcValTreeNode();
                        metricNode.setDimensionId(metricTplDim.getDimensionId());
                        metricNode.setDimensionName(metricTplDim.getDimensionName());
                        metricNode.setDisplayVal(metricMember.getName());
                        metricNode.setParent(sumValTree);
                        metricNode.setMetric(true);
                        metricNode.setValue(metricMember.getId());
                        metricNode.setTotalSummary(sumValTree.isTotalSummary());
                        sumValTree.addChild(metricNode);
                    }
                }
            }
            ++leafCnt;
            childList.add(sumValTree);
        }
        parent.setChildren(childList);
        return leafCnt;
    }

    private boolean isRealNeedSum(TemplateDim templateDim) {
        ReportTemplate template = this.report.getTemplate();
        Optional<TemplateDim> max = template.getAllTemplateDim().stream().collect(Collectors.toList()).stream().max(Comparator.comparing(item -> item.getLevel()));
        boolean subSumVisible = template.isSubSumVisible();
        if (!subSumVisible) {
            return false;
        }
        if (max.get().getDimType().isPeriodDim()) {
            return true;
        }
        if (!templateDim.getDimType().isPeriodDim()) {
            return templateDim.isIncludeSum();
        }
        if (templateDim.getDimType().isPeriodDim() && templateDim.isExpand()) {
            return true;
        }
        return !templateDim.isIncludeSum();
    }

    protected void createChildren(ReportCalcValTreeNode tree, Integer max, Integer index) {
        if (index < max) {
            ReportCalcVirtualTreeNode children = new ReportCalcVirtualTreeNode();
            tree.addChild(children);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            this.createChildren(children, max, index);
        }
    }

    private List<ReportCalcValTreeNode> moveChildren(int index, List<ReportCalcValTreeNode> children) {
        children.stream().forEach(item -> {
            item.setCol(item.getCol() + index);
            if (CollectionUtils.isNotEmpty(item.getChildren())) {
                item.setChildren(this.moveChildren(index, this.copyChildren(item.getChildren(), false)));
            }
        });
        return children;
    }

    private ReportCalcValTreeNode setReportCalc(ReportCalcValTreeNode tree) {
        if (tree instanceof ReportCalcVirtualTreeNode) {
            ReportCalcVirtualTreeNode virtualTreeNode = new ReportCalcVirtualTreeNode();
            virtualTreeNode.setChildren(tree.getChildren());
            return virtualTreeNode;
        }
        ReportCalcValTreeNode code = new ReportCalcValTreeNode();
        code.setChildren(tree.getChildren());
        code.setCol(tree.getCol());
        code.setRow(tree.getRow());
        code.setSummary(tree.isSummary());
        code.setTotalSummaryOfLittleSummary(tree.isSummary());
        code.setColSpan(tree.getColSpan());
        code.setRowSpan(tree.getRowSpan());
        code.setDimensionId(tree.getCalcVal().getDimensionId());
        code.setDisplayType(tree.getCalcVal().getDisplayType());
        code.setDisplayVal(tree.getDisplayVal());
        code.setValue(tree.getValue());
        code.setMetric(tree.getCalcVal().isMetric());
        code.setRemark(tree.isRemark());
        code.setParent(tree.getParent());
        code.setSkipVal(tree.isSkipVal());
        code.setUseType(tree.getCalcVal().getUseType());
        code.setSkipVal(tree.isSkipVal());
        return code;
    }

    public List<ReportCalcValTreeNode> copyChildren(List<ReportCalcValTreeNode> children, Boolean isDeep) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(children)) {
            ArrayList<ReportCalcValTreeNode> calcValTrees = new ArrayList<ReportCalcValTreeNode>(children.size());
            children.forEach(item -> {
                ReportCalcValTreeNode treeNode = this.setReportCalc((ReportCalcValTreeNode)item);
                if (isDeep.booleanValue()) {
                    treeNode.setChildren(this.copyChildren(item.getChildren(), true));
                }
                calcValTrees.add(treeNode);
            });
            return calcValTrees;
        }
        return children;
    }

    public List<ReportCalcValTreeNode> copyChildren(List<ReportCalcValTreeNode> children, int depth) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(children) || depth < 0) {
            return children;
        }
        ArrayList<ReportCalcValTreeNode> calcValTrees = new ArrayList<ReportCalcValTreeNode>(children.size());
        for (ReportCalcValTreeNode item : children) {
            int everyDepth = depth;
            ReportCalcValTreeNode treeNode = this.setReportCalc(item);
            treeNode.setChildren(new ArrayList<ReportCalcValTreeNode>(16));
            if (depth > 0) {
                treeNode.setChildren(this.copyChildren(item.getChildren(), --everyDepth));
            }
            calcValTrees.add(treeNode);
        }
        return calcValTrees;
    }

    private List<ReportCalcVal> setRowDimColName(List<ReportCalcVal> rowDimDataList, Map<Long, TemplateDim> dimMap) {
        ArrayList<ReportCalcVal> result = new ArrayList<ReportCalcVal>(rowDimDataList.size());
        Integer minRow = rowDimDataList.stream().map(ReportCalcVal::getRow).min(Integer::compareTo).get();
        Map<Integer, List<ReportCalcVal>> colMap = rowDimDataList.stream().collect(Collectors.groupingBy(ReportCalcVal::getCol));
        for (Map.Entry<Integer, List<ReportCalcVal>> next : colMap.entrySet()) {
            ReportCalcVal reportCalcVal = next.getValue().get(0);
            ReportCalcVal rowDimColNameVal = new ReportCalcVal();
            ReportValueType reportValueType = new ReportValueType();
            reportValueType.setReportCellType(ReportCellType.TEXT);
            rowDimColNameVal.setRow(0);
            rowDimColNameVal.setRowSpan(minRow);
            rowDimColNameVal.setCol(reportCalcVal.getCol());
            rowDimColNameVal.setColSpan(reportCalcVal.getColSpan());
            rowDimColNameVal.setDisplayVal(dimMap.get(reportCalcVal.getDimensionId()).getDimensionName());
            rowDimColNameVal.setValueType(reportValueType);
            result.add(rowDimColNameVal);
        }
        return result;
    }

    private void initEmptyData(ReportCalcModel templateModel) {
        int startRow;
        int endRow;
        int endCol = templateModel.getColDimValList().stream().map(ReportCalcVal::getCol).max(Integer::compareTo).orElse(0);
        int startCol = templateModel.getColDimValList().stream().map(ReportCalcVal::getCol).min(Integer::compareTo).orElse(0);
        ReportTemplate template = this.report.getTemplate();
        if (template.getTemplateType() == TemplateType.FIXED) {
            endRow = templateModel.getRowDimValList().stream().map(ReportCalcVal::getRow).max(Integer::compareTo).orElse(0);
            startRow = templateModel.getRowDimValList().stream().map(ReportCalcVal::getRow).min(Integer::compareTo).orElse(0);
        } else {
            endRow = this.report.getTemplate().getMaxLineCount() - 1;
            startRow = 0;
        }
        ArrayList<ReportCalcVal> emptyDataValList = new ArrayList<ReportCalcVal>();
        for (int col = startCol; col <= endCol; ++col) {
            for (int row = startRow; row <= endRow; ++row) {
                ReportCalcVal val = new ReportCalcVal();
                val.setRow(row);
                val.setCol(col);
                val.setRowSpan(1);
                val.setColSpan(1);
                ReportValueType reportValueType = new ReportValueType();
                reportValueType.setReportCellType(ReportCellType.TEXT);
                val.setValueType(reportValueType);
                emptyDataValList.add(val);
            }
        }
        templateModel.setDataValList(emptyDataValList);
        this.fixRowColOffSet(templateModel);
        if (template.getTemplateType() == TemplateType.FIXED && org.apache.commons.collections.CollectionUtils.isNotEmpty(templateModel.getRowDimValList())) {
            Map<Long, TemplateDim> dimMap = template.getAllTemplateDim().stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
            templateModel.getColDimValList().addAll(this.setRowDimColName(templateModel.getRowDimValList(), dimMap));
        }
    }

    protected List<ReportCalcVal> rebuildRowColInfo(ReportCalcValTreeNode root, DimLocation dimLocation) {
        if (EmptyUtil.isEmpty((Object)root)) {
            return Collections.emptyList();
        }
        List<ReportCalcValTreeNode> firstChildren = root.getChildren();
        if (EmptyUtil.isEmpty(firstChildren)) {
            return Collections.emptyList();
        }
        int depth = 0;
        int index = 0;
        for (int i = 0; i < firstChildren.size(); ++i) {
            ReportCalcValTreeNode firstChild = firstChildren.get(i);
            List<ReportCalcValTreeNode> children = firstChild.getChildren();
            if (EmptyUtil.isEmpty(children)) {
                firstChild.setCol(dimLocation == DimLocation.COL ? i : depth);
                firstChild.setRow(dimLocation == DimLocation.ROW ? i : depth);
                firstChild.setColSpan(1);
                firstChild.setRowSpan(1);
                firstChild.setParent(root);
                continue;
            }
            int maxLastChildCount = this.doRebuildRowColInfo(firstChild, depth + 1, dimLocation, index, 0);
            firstChild.setCol(dimLocation == DimLocation.COL ? index : depth);
            firstChild.setRow(dimLocation == DimLocation.ROW ? index : depth);
            firstChild.setColSpan(dimLocation == DimLocation.COL ? maxLastChildCount : 1);
            firstChild.setRowSpan(dimLocation == DimLocation.ROW ? maxLastChildCount : 1);
            firstChild.setParent(root);
            index += maxLastChildCount;
        }
        return Collections.emptyList();
    }

    private int doRebuildRowColInfo(ReportCalcValTreeNode child, int depth, DimLocation dimLocation, int index, int maxLastChildCount) {
        List<ReportCalcValTreeNode> children = child.getChildren();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(children)) {
            return maxLastChildCount + 1;
        }
        ReportCalcValTreeNode childChild = children.get(0);
        List<ReportCalcValTreeNode> childChildren = childChild.getChildren();
        if (EmptyUtil.isEmpty(childChildren)) {
            for (ReportCalcValTreeNode anyChild : children) {
                anyChild.setCol(dimLocation == DimLocation.COL ? maxLastChildCount + index : depth);
                anyChild.setRow(dimLocation == DimLocation.ROW ? maxLastChildCount + index : depth);
                anyChild.setColSpan(1);
                anyChild.setRowSpan(1);
                anyChild.setParent(child);
                ++maxLastChildCount;
            }
            return maxLastChildCount;
        }
        int childCount = maxLastChildCount;
        for (ReportCalcValTreeNode anyChild : children) {
            int span = this.doRebuildRowColInfo(anyChild, depth + 1, dimLocation, index, maxLastChildCount);
            anyChild.setCol(dimLocation == DimLocation.COL ? index : depth);
            anyChild.setRow(dimLocation == DimLocation.ROW ? index : depth);
            anyChild.setColSpan(dimLocation == DimLocation.COL ? span : 1);
            anyChild.setRowSpan(dimLocation == DimLocation.ROW ? span : 1);
            anyChild.setParent(child);
            index += span;
            childCount += span;
        }
        return childCount;
    }

    protected void removeVirtualNodeAndRebuildRowColSpan(ReportCalcValTreeNode root, DimLocation dimLocation) {
        if (EmptyUtil.isEmpty((Object)root)) {
            return;
        }
        List<ReportCalcValTreeNode> allChildren = root.getAllChildren();
        if (EmptyUtil.isEmpty(allChildren)) {
            return;
        }
        List virtualTreeNodeList = allChildren.stream().filter(ReportCalcVirtualTreeNode.class::isInstance).map(node -> (ReportCalcVirtualTreeNode)node).collect(Collectors.toList());
        Set valTreeNodes = virtualTreeNodeList.stream().map(ReportCalcVirtualTreeNode::getNotVirtualParent).filter(Objects::nonNull).collect(Collectors.toSet());
        for (ReportCalcValTreeNode valTreeNode : valTreeNodes) {
            ReportCalcValTreeNode virtualTreeNode;
            List<ReportCalcValTreeNode> children = valTreeNode.getChildren();
            int level = 0;
            while (EmptyUtil.isNoEmpty(children) && ReportCalcVirtualTreeNode.class.isInstance(virtualTreeNode = children.get(0))) {
                children = virtualTreeNode.getChildren();
                ++level;
            }
            valTreeNode.setChildren(children);
            valTreeNode.setRowSpan(dimLocation == DimLocation.COL ? valTreeNode.getRowSpan() + level : valTreeNode.getRowSpan());
            valTreeNode.setColSpan(dimLocation == DimLocation.ROW ? valTreeNode.getColSpan() + level : valTreeNode.getColSpan());
            if (EmptyUtil.isEmpty(children)) continue;
            for (ReportCalcValTreeNode treeNode : children) {
                treeNode.setParent(valTreeNode);
            }
        }
    }

    private boolean dimNeedSort(TemplateDim templateDim) {
        return !templateDim.getDimType().isMetric();
    }

    protected boolean skipVirtualDim(TemplateDim tplDim) {
        return tplDim.isViDim() && tplDim.getDimType() != DimensionType.ACCOUNTTYPE;
    }

    private void memberSort() {
        List<TemplateDim> allTemplateDim = this.report.getTemplate().getAllTemplateDim();
        if (Objects.nonNull(this.report.getTemplate().getMetricTplDim())) {
            allTemplateDim.add(this.report.getTemplate().getMetricTplDim());
        }
        allTemplateDim.stream().filter(Objects::nonNull).filter(this::dimNeedSort).forEach(templateDim -> {
            if (Objects.nonNull(templateDim.getDefaultDisplayMember())) {
                return;
            }
            templateDim.setMemberScope(templateDim.getMemberScope().stream().map(this.dimMemberMap::get).filter(Objects::nonNull).sorted(this.getDimMemberComparator()).map(DimMember::getId).distinct().collect(Collectors.toList()));
        });
    }

    private Comparator<DimMember> getDimMemberComparator() {
        return (o1, o2) -> {
            String sortCode2;
            String sortCode1 = EmptyUtil.isNoEmpty((String)o1.getSortCode()) ? o1.getSortCode() : o1.getLongNumber();
            int result = sortCode1.compareTo(sortCode2 = EmptyUtil.isNoEmpty((String)o2.getSortCode()) ? o2.getSortCode() : o2.getLongNumber());
            if (!NumberUtils.equalsZero((Integer)result)) {
                return result;
            }
            return 0;
        };
    }
}

