/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import org.apache.commons.collections4.CollectionUtils;

public class ReportTplVimDimBuildV2Action
implements IReportDataProcessAction {
    private FundPlanSystem system;
    private ReportDataSource report;

    public ReportTplVimDimBuildV2Action(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
    }

    @Override
    public void execute(ReportModel reportModel) {
        ReportCalcModel templateModel = reportModel.getTemplateModel();
        ReportCalcTree colTree = templateModel.getColTree();
        this.initReportTemplateModel(templateModel, colTree);
        colTree.refreshTree();
        int rowSpan = templateModel.getColDimValList().stream().map(ReportCalcVal::getRow).max(Integer::compareTo).orElse(-1) + 1;
        templateModel.setRowOffset(rowSpan);
    }

    private void initReportTemplateModel(ReportCalcModel templateModel, ReportCalcTree colTree) {
        ReportTemplate template = this.report.getTemplate();
        List<TemplateDim> colDimList = template.getColDimList();
        List<ReportCalcVal> colDimValList = templateModel.getColDimValList();
        if (template.getTemplateType() == TemplateType.DETAIL) {
            int addColCount = 0;
            Dimension expandDim = this.system.getDimList().stream().filter(item -> item.getDimType() == DimensionType.ADJUSTDATATYPE).findFirst().get();
            List<DimMember> expandDimMemberList = expandDim.getAllDimMemberList();
            Map expandDimMemberMap = expandDimMemberList.stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
            Optional<TemplateDim> expandDimOptional = colDimList.stream().filter(TemplateDim::isExpand).findFirst();
            TemplateDim adJustDim = colDimList.stream().filter(item -> item.getDimType() == DimensionType.ADJUSTDATATYPE).findFirst().get();
            List<Long> adJustMemberScope = adJustDim.getMemberScope();
            Integer colDimMaxRow = colDimValList.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).get();
            Integer vimDimStartColIndex = 0;
            List afterDataList = null;
            if (expandDimOptional.isPresent()) {
                TemplateDim expandTplDim = expandDimOptional.get();
                ReportCalcValTreeNode expandRoot = templateModel.getColTree().getRoot().getChildren().stream().filter(Objects::nonNull).filter(item -> Objects.equals(item.getCalcVal().getDimensionId(), expandTplDim.getDimensionId())).findAny().get();
                List expandCalcList = expandRoot.getAllLeafChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
                int startColIndex = expandCalcList.stream().map(ReportCalcVal::getCol).min(Integer::compareTo).get();
                int endColIndex = expandCalcList.stream().map(ReportCalcVal::getCol).max(Integer::compareTo).get();
                afterDataList = colDimValList.stream().filter(item -> item.getCol() > endColIndex).collect(Collectors.toList());
                vimDimStartColIndex = startColIndex;
                for (ReportCalcVal reportCalcVal : expandCalcList) {
                    for (int i = 0; i < adJustMemberScope.size(); ++i) {
                        Long expandMemberId = adJustMemberScope.get(i);
                        DimMember dimMember = (DimMember)expandDimMemberMap.get(expandMemberId);
                        ReportCalcVal reportCalcValNew = new ReportCalcVal();
                        ReportValueType reportValueTypeNew = new ReportValueType();
                        reportValueTypeNew.setReportCellType(ReportCellType.TEXT);
                        reportCalcValNew.setCol(startColIndex++);
                        reportCalcValNew.setRow(colDimMaxRow + 1);
                        reportCalcValNew.setRowSpan(1);
                        reportCalcValNew.setColSpan(1);
                        reportCalcValNew.setDataCell(false);
                        reportCalcValNew.setValueType(reportValueTypeNew);
                        reportCalcValNew.setDimensionId(expandDim.getId());
                        reportCalcValNew.setDimensionName(expandDim.getName());
                        reportCalcValNew.setDisplayVal(dimMember.getName());
                        reportCalcValNew.setValue(dimMember.getId());
                        reportCalcValNew.setEnable(false);
                        colDimValList.add(reportCalcValNew);
                        this.buildCalcTreeNode(colTree, reportCalcValNew, reportCalcVal.getRow(), reportCalcVal.getCol(), false, false);
                    }
                }
                addColCount = expandCalcList.size() * adJustMemberScope.size() - expandCalcList.size();
                this.updateExpandDimTreeNodeColInfo(expandRoot, vimDimStartColIndex);
            } else {
                int startColIndex;
                TemplateDim planAmtDim = colDimList.stream().filter(item -> item.getDetailDimType() == DetailDimType.PLAN_AMOUNT).findFirst().get();
                ReportCalcVal reportCalcVal = colDimValList.stream().filter(item -> item.getDimensionId().equals(planAmtDim.getDimensionId())).findFirst().get();
                int afterColIndex = startColIndex = reportCalcVal.getCol();
                afterDataList = colDimValList.stream().filter(item -> item.getCol() > afterColIndex).collect(Collectors.toList());
                vimDimStartColIndex = startColIndex;
                for (int i = 0; i < adJustMemberScope.size(); ++i) {
                    Long expandMemberId = adJustMemberScope.get(i);
                    DimMember dimMember = (DimMember)expandDimMemberMap.get(expandMemberId);
                    ReportCalcVal reportCalcValNew = new ReportCalcVal();
                    ReportValueType reportValueTypeNew = new ReportValueType();
                    reportValueTypeNew.setReportCellType(ReportCellType.TEXT);
                    reportCalcValNew.setCol(startColIndex++);
                    reportCalcValNew.setRow(colDimMaxRow + 1);
                    reportCalcValNew.setRowSpan(1);
                    reportCalcValNew.setColSpan(1);
                    reportCalcValNew.setDataCell(true);
                    reportCalcValNew.setValueType(reportValueTypeNew);
                    reportCalcValNew.setDimensionId(expandDim.getId());
                    reportCalcValNew.setDimensionName(expandDim.getName());
                    reportCalcValNew.setDisplayVal(dimMember.getName());
                    reportCalcValNew.setValue(dimMember.getId());
                    reportCalcValNew.setEnable(true);
                    colDimValList.add(reportCalcValNew);
                    this.buildCalcTreeNode(colTree, reportCalcValNew, reportCalcValNew.getRow() - 1, vimDimStartColIndex, false, false);
                }
                addColCount = adJustMemberScope.size() - 1;
                reportCalcVal.setColSpan(adJustMemberScope.size());
            }
            int beforeIndex = vimDimStartColIndex;
            List beforeDataList = colDimValList.stream().filter(item -> item.getCol() < beforeIndex).collect(Collectors.toList());
            for (ReportCalcVal reportCalcVal : beforeDataList) {
                reportCalcVal.setRowSpan(reportCalcVal.getRowSpan() + 1);
            }
            if (afterDataList != null) {
                for (ReportCalcVal reportCalcVal : afterDataList) {
                    reportCalcVal.setRowSpan(reportCalcVal.getRowSpan() + 1);
                    reportCalcVal.setCol(reportCalcVal.getCol() + addColCount);
                }
            }
        }
    }

    private void buildCalcTreeNode(ReportCalcTree colTree, ReportCalcVal currCalcVal, int row, int col, boolean isSkip, boolean isFrist) {
        List<ReportCalcValTreeNode> childrens;
        ReportCalcValTreeNode parentNode = colTree.findNode(row, col);
        if (parentNode == null) {
            parentNode = colTree.getRoot();
        }
        if (EmptyUtil.isEmpty(childrens = parentNode.getChildren())) {
            childrens = new ArrayList<ReportCalcValTreeNode>(10);
        }
        ReportCalcValTreeNode virtualDimTreeNode = new ReportCalcValTreeNode();
        virtualDimTreeNode.setCalcVal(currCalcVal);
        virtualDimTreeNode.setParent(parentNode);
        virtualDimTreeNode.setSkipVal(isSkip);
        if (isFrist) {
            childrens.add(0, virtualDimTreeNode);
        } else {
            childrens.add(virtualDimTreeNode);
        }
        parentNode.setChildren(childrens);
        if (isSkip) {
            parentNode.setLeafChildCnt(childrens.size());
        }
    }

    private int updateExpandDimTreeNodeColInfo(ReportCalcValTreeNode root, int startCol) {
        if (root == null || CollectionUtils.isEmpty(root.getChildren())) {
            return 1;
        }
        int rootColSpan = 0;
        int rootCol = startCol;
        for (ReportCalcValTreeNode child : root.getChildren()) {
            int childColSpan = this.updateExpandDimTreeNodeColInfo(child, startCol);
            startCol += childColSpan;
            rootColSpan += childColSpan;
        }
        ReportCalcVal reportCalcVal = root.getCalcVal();
        reportCalcVal.setCol(rootCol);
        reportCalcVal.setColSpan(rootColSpan);
        return rootColSpan;
    }
}

