/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataProcessFixAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.SynthesisReportDataProcessDetailAction;

public class SynthesisReportDataProcessAction
implements IReportDataProcessAction {
    private ReportDataSource report;
    private FundPlanSystem system;

    public SynthesisReportDataProcessAction(FundPlanSystem system, ReportDataSource report) {
        this.report = report;
        this.system = system;
    }

    @Override
    public void execute(ReportModel reportModel) {
        IReportDataProcessAction action = this.getStrategy();
        action.execute(reportModel);
    }

    public IReportDataProcessAction getStrategy() {
        TemplateType templateType = this.report.getTemplate().getTemplateType();
        if (templateType == TemplateType.FIXED) {
            return new ReportDataProcessFixAction(this.system, this.report);
        }
        return new SynthesisReportDataProcessDetailAction(this.system, this.report);
    }
}

