/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcVirtualTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;

public class SynthesisReportTemplateBuildAction
extends ReportTemplateBuildV2Action {
    public SynthesisReportTemplateBuildAction(FundPlanSystem system, ReportDataSource report, List<DimensionType> needLevelShowDimList) {
        super(system, report, needLevelShowDimList);
    }

    public SynthesisReportTemplateBuildAction(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
    }

    @Override
    protected void replaceDetailPeriodWithVirtualNode(ReportCalcValTreeNode colRoot, List<TemplateDim> dimList, DimLocation location) {
        Optional<TemplateDim> first = this.getPeriodDimContainDetail(colRoot, dimList, location);
        if (!first.isPresent()) {
            return;
        }
        TemplateDim templateDim = first.get();
        List<Long> memberScope = templateDim.getMemberScope();
        ReportPeriodType reportPeriodType = this.system.getReportTypeList().get(0);
        if (reportPeriodType.getDetailPeriodType() == null) {
            return;
        }
        if (!(this.report instanceof Report)) {
            return;
        }
        Report report$ = (Report)this.report;
        if (report$.getPeriodMemberList().size() == 1) {
            return;
        }
        List<ReportCalcValTreeNode> periodParentNodes = Collections.singletonList(colRoot);
        List<ReportCalcValTreeNode> tempChildren = colRoot.getChildren();
        for (int level = templateDim.getLevel(); level > 1 && !EmptyUtil.isEmpty(tempChildren); --level) {
            periodParentNodes = tempChildren;
            tempChildren = tempChildren.stream().map(ReportCalcValTreeNode::getChildren).flatMap(Collection::stream).collect(Collectors.toList());
        }
        for (ReportCalcValTreeNode parentNode : periodParentNodes) {
            ArrayList<ReportCalcValTreeNode> children = new ArrayList<ReportCalcValTreeNode>(parentNode.getChildren().stream().filter(node -> Objects.equals(templateDim.getDimensionId(), node.getCalcVal().getDimensionId())).collect(Collectors.toList()));
            if (EmptyUtil.isEmpty(children)) continue;
            children.removeIf(node -> templateDim.getLevel() == 1 && node.isTotalSummary());
            for (int i = 0; i < memberScope.size(); ++i) {
                ReportCalcValTreeNode treeNode;
                List<ReportCalcValTreeNode> rollChildren;
                Long periodMemberId = memberScope.get(i);
                PeriodMember periodMember = (PeriodMember)this.dimMemberMap.get(periodMemberId);
                if (periodMember.getChildren().size() != 1 || !Objects.equals(periodMember.getNumber(), periodMember.getChildren().get(0).getNumber()) || EmptyUtil.isEmpty(rollChildren = (treeNode = (ReportCalcValTreeNode)children.get(i)).getChildren())) continue;
                ReportCalcValTreeNode rollDetailChildNode = rollChildren.get(0);
                rollChildren.clear();
                ReportCalcVirtualTreeNode virtualTreeNode = new ReportCalcVirtualTreeNode();
                virtualTreeNode.setChildren(rollDetailChildNode.getChildren());
                treeNode.addChild(virtualTreeNode);
                treeNode.setRollCell(true);
                treeNode.setSkipVal(false);
            }
        }
    }
}

