/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldsUseType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateReferencePosType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.provider.ReportBaseDataProvider;
import kd.tmc.fpm.business.spread.generator.actions.service.IReportDataToCalcValStrategy;
import kd.tmc.fpm.business.spread.generator.actions.service.ReportDataGetValService;
import kd.tmc.fpm.business.spread.generator.actions.service.ReportDataSmartValVerService;
import kd.tmc.fpm.business.spread.generator.actions.service.SumReportDataGetValService;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.enums.SpecialColorEnum;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;

public class DetailReportDataToCalcValStrategy
implements IReportDataToCalcValStrategy {
    private ReportDataGetValService getValService;
    private FundPlanSystem system;
    private Map<Long, AuxiliaryField> auxiliaryFieldMap;
    private QueryIndexInfo<String, ReportData> auxiliaryInfoQueryIndex;
    private QueryIndexInfo<Long, ReportData> queryIndexInfo;
    private Map<Long, Dimension> dimensionMap;

    public DetailReportDataToCalcValStrategy(FundPlanSystem system, ReportDataGetValService getValService) {
        this.getValService = getValService;
        this.system = system;
        this.auxiliaryFieldMap = system.getAuxiliaryFieldList().stream().collect(Collectors.toMap(AuxiliaryField::getId, v -> v, (k1, k2) -> k1));
        this.dimensionMap = system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
    }

    private void generateIndex(ReportDataSource report) {
        List warpBeanList = report.getReportDataList().stream().map(item -> {
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(item, rd -> !rd.getDimType().isVirtualDim());
            return new WarpBean<String, ReportData>(UUID.randomUUID().toString(), dimensionInfoBean, (ReportData)item);
        }).collect(Collectors.toList());
        this.auxiliaryInfoQueryIndex = QueryIndexInfoMapGenerator.build(warpBeanList, this.system, ReportData::isAuxiliaryInfo);
        this.queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(report.getReportDataList(), this.system, rd -> !rd.isAuxiliaryInfo());
    }

    @Override
    public void transfer(ReportDataSource report, ReportCalcModel reportCalcModel) {
        this.generateIndex(report);
        List pageIDList = reportCalcModel.getPageDimValList().stream().map(ReportCalcVal::getValue).collect(Collectors.toList());
        Map<Integer, List<ReportData>> rowAndRDMap = report.getReportDataList().stream().filter(o -> o.getDimValList().containsAll(pageIDList)).collect(Collectors.groupingBy(ReportData::getRow));
        List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
        Map<Integer, Object> colAndMetricMap = colDimValList.stream().filter(ReportCalcVal::isMetric).collect(Collectors.toMap(ReportCalcVal::getCol, ReportCalcVal::getValue));
        Map<Integer, Object> colAndMReferenceMap = colDimValList.stream().filter(item -> item.isReferenceCell() && item.getColSpan() == 1).collect(Collectors.toMap(ReportCalcVal::getCol, ReportCalcVal::getValue, (o1, o2) -> o2));
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        Map<Integer, List<ReportCalcVal>> dataValRowMap = dataValList.stream().filter(item -> !item.isSummary()).collect(Collectors.groupingBy(ReportCalcVal::getRow));
        for (Map.Entry<Integer, List<ReportCalcVal>> next : dataValRowMap.entrySet()) {
            Integer currRow = next.getKey();
            List<ReportCalcVal> rowReportCalcValList = next.getValue();
            List<ReportData> rowReportDataList = rowAndRDMap.get(currRow);
            if (CollectionUtils.isEmpty(rowReportDataList)) continue;
            List sortRowReportCalcValList = rowReportCalcValList.stream().sorted(Comparator.comparing(ReportCalcVal::isDataCell)).collect(Collectors.toList());
            for (ReportCalcVal reportCalcVal : sortRowReportCalcValList) {
                int currCol = reportCalcVal.getCol();
                ReportData currRowFirstRD = rowReportDataList.get(0);
                if (reportCalcVal.isDataCell()) {
                    ReportValueType valueType;
                    List targetRDList;
                    DimensionInfoBean currDimInfo = reportCalcModel.getDimensionInfo(currCol, currRow);
                    this.filterEmpty(currDimInfo);
                    List<ReportData> list = this.queryIndexInfo.findList(currDimInfo);
                    if (EmptyUtil.isEmpty(list) || CollectionUtils.isEmpty(targetRDList = list.stream().filter(rd -> rd.getRow() == reportCalcVal.getRow()).collect(Collectors.toList()))) continue;
                    if (targetRDList.size() > 1) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u540c\u4e00\u884c\u5217\u5b58\u5728\u91cd\u590d\u6570\u636e\u3002", (String)"DetailReportDataToCalcValStrategy_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    }
                    ReportData targetReportData = (ReportData)targetRDList.get(0);
                    if (targetReportData != null) {
                        BigDecimal amtVal = targetReportData.getPlanAmt();
                        if (reportCalcVal.isReferenceCell()) {
                            Object reference = colAndMReferenceMap.get(reportCalcVal.getCol());
                            TemplateReferencePosType referenceType = TemplateReferencePosType.getByNumber(reference.toString());
                            if (referenceType == TemplateReferencePosType.ACTMAT) {
                                amtVal = targetReportData.getActAmt();
                            } else if (referenceType == TemplateReferencePosType.AVLIABLEBANLANCE) {
                                amtVal = targetReportData.getPlanAmt().subtract(targetReportData.getActAmt()).subtract(targetReportData.getLockAmt());
                            } else if (referenceType == TemplateReferencePosType.BANLANCE) {
                                amtVal = targetReportData.getPlanAmt().subtract(targetReportData.getActAmt());
                            }
                        } else if (this.getValService != null && colAndMetricMap.containsKey(reportCalcVal.getCol())) {
                            BigDecimal val;
                            Object metric = colAndMetricMap.get(reportCalcVal.getCol());
                            TemplateMetricType metricType = TemplateMetricType.valueOf(metric.toString());
                            amtVal = this.getValService.getVal(targetReportData, metricType);
                            if (this.getValService instanceof SumReportDataGetValService && metricType == TemplateMetricType.ORIGINALPLANAMT && amtVal.compareTo(val = this.getValService.getVal(targetReportData, TemplateMetricType.REPORTPLANAMT)) != 0) {
                                reportCalcVal.setSpecialColor(SpecialColorEnum.APPROVED_COLOR);
                            }
                        } else if (this.getValService instanceof ReportDataSmartValVerService) {
                            amtVal = this.getValService.getVal(targetReportData, null);
                        }
                        reportCalcVal.setValue(amtVal);
                        if (report instanceof SumPlanReport) {
                            reportCalcVal.setDataId(targetReportData.getSourceIdList());
                        } else {
                            reportCalcVal.setDataId(targetReportData.getId());
                        }
                        reportCalcVal.setSourceIdList(targetReportData.getSourceIdList());
                        reportCalcVal.setDisplayVal(amtVal == null ? "" : amtVal.toString());
                    }
                    valueType = (valueType = reportCalcVal.getValueType()) == null ? new ReportValueType() : valueType;
                    valueType.setReportCellType(ReportCellType.AMOUNT);
                    reportCalcVal.setValueType(valueType);
                    reportCalcVal.setDataCell(true);
                    continue;
                }
                if (currRowFirstRD == null) continue;
                List<TemplateDim> dimList = currRowFirstRD.getDimList();
                List<Object> dimValList = currRowFirstRD.getDimValList();
                Long dimensionId = reportCalcVal.getDimensionId() == null ? Long.valueOf(0L) : reportCalcVal.getDimensionId();
                Optional<TemplateDim> dimOptional = dimList.stream().filter(item -> item.getDimensionId().equals(dimensionId)).findFirst();
                if (!dimOptional.isPresent() && reportCalcVal.isRemarkCell()) {
                    this.dealRemarkCell(reportCalcVal, reportCalcModel, report, this.auxiliaryInfoQueryIndex);
                    continue;
                }
                if (!dimOptional.isPresent()) continue;
                TemplateDim templateDim = dimOptional.get();
                int dimIndex = dimList.indexOf(templateDim);
                Object data = dimValList.get(dimIndex);
                reportCalcVal.setValue(data);
                if (data != null) {
                    reportCalcVal.setDisplayVal(data.toString());
                }
                this.setDetailDimInfoIfNeed(reportCalcVal, currRowFirstRD, templateDim, data);
            }
        }
        this.bdDisplayValHandle(reportCalcModel, report.getTemplate());
        reportCalcModel.initDetailReportCalcValGroupMap();
    }

    private void bdDisplayValHandle(ReportCalcModel reportCalcModel, ReportTemplate reportTemplate) {
        ReportBaseDataProvider reportBaseDataProvider = new ReportBaseDataProvider(Collections.singletonList(reportCalcModel));
        Set numberColSet = reportCalcModel.getColDimValList().stream().filter(c -> c.getDisplayType() == DisplayTypeEnum.NUMBER).map(ReportCalcVal::getCol).collect(Collectors.toSet());
        for (ReportCalcVal reportCalcVal : reportCalcModel.getDataValList()) {
            ReportValueType valueType = reportCalcVal.getValueType();
            ReportCellType reportCellType = valueType.getReportCellType();
            if (ReportCellType.BASE_DATA == reportCellType && valueType.getValue() != null && reportCalcVal.getValue() != null) {
                DynamicObject baseData = reportBaseDataProvider.getBaseData(valueType.getValue().toString(), reportCalcVal.getValue());
                if (baseData == null) continue;
                reportCalcVal.setDisplayVal(baseData.getString("name"));
                if (CollectionUtils.isNotEmpty(numberColSet) && numberColSet.contains(reportCalcVal.getCol())) {
                    reportCalcVal.setDisplayVal(baseData.getString("number"));
                }
                this.setSubjectFlowValIfNeed(reportCalcVal, baseData, reportCalcModel, reportTemplate);
                continue;
            }
            if (ReportCellType.MUTI_BASE_DATA != reportCellType) continue;
            Map value = (Map)valueType.getValue();
            for (Map.Entry next : value.entrySet()) {
                if (!next.getValue().equals(reportCalcVal.getValue())) continue;
                reportCalcVal.setDisplayVal((String)next.getKey());
            }
        }
    }

    private void dealRemarkCell(ReportCalcVal reportCalcVal, ReportCalcModel reportCalcModel, ReportDataSource report, QueryIndexInfo<String, ReportData> auxiliaryInfoQueryIndex) {
        ReportDataIndexQueryMap<String> remarkIndexQueryMap = auxiliaryInfoQueryIndex.getIndexQueryMap();
        Map<String, ReportData> remarkDataMap = auxiliaryInfoQueryIndex.getDataMap();
        if (!reportCalcVal.isRemarkCell() || MapUtils.isEmpty(remarkDataMap)) {
            return;
        }
        ReportData reportData = this.findAuxiliaryValue(reportCalcModel, reportCalcVal, remarkIndexQueryMap, remarkDataMap, report);
        if (reportData != null) {
            String remark = reportData.getAuxiliaryVal(reportCalcVal.getDimensionId());
            reportCalcVal.setDisplayVal(remark);
            reportCalcVal.setValue(remark);
            if (!(report instanceof Report) || !((Report)report).getInitFlag().booleanValue()) {
                reportData.setCol(reportCalcVal.getCol());
                reportData.setRow(reportCalcVal.getRow());
            }
            reportCalcVal.setDataId(reportData.getId());
            ReportValueType valueType = reportCalcVal.getValueType();
            valueType = valueType == null ? new ReportValueType() : valueType;
            valueType.setReportCellType(ReportCellType.TEXT);
            reportCalcVal.setValueType(valueType);
        }
    }

    private ReportData findAuxiliaryValue(ReportCalcModel reportCalcModel, ReportCalcVal reportCalcVal, ReportDataIndexQueryMap<String> remarkIndexQueryMap, Map<String, ReportData> remarkDataMap, ReportDataSource report) {
        PeriodMember referencePeriodMember;
        DimensionInfoBean dimensionInfoBean = reportCalcModel.getDimensionInfo(reportCalcVal.getCol(), reportCalcVal.getRow());
        List<String> list = remarkIndexQueryMap.findList(dimensionInfoBean);
        if (EmptyUtil.isEmpty(list)) {
            return null;
        }
        List reportDataList = list.stream().map(remarkDataMap::get).collect(Collectors.toList());
        ReportData reportData = null;
        Long dimensionId = reportCalcVal.getDimensionId();
        AuxiliaryField auxiliaryField = this.auxiliaryFieldMap.get(dimensionId);
        PeriodMember periodMember = report.getPeriodMemberList().get(0);
        Predicate<ReportData> predicate = auxiliaryField != null && auxiliaryField.getUseType() == AuxiliaryFieldsUseType.EXEC_DEVIATION_ANALYSIS ? ((referencePeriodMember = ((Report)report).getReferencePeriodMember()) == null ? r -> r.getReportPeriodId().equals(periodMember.getId()) : r -> r.getReportPeriodId().equals(referencePeriodMember.getId())) : r -> r.getReportPeriodId().equals(periodMember.getId());
        Optional<ReportData> find = reportDataList.stream().filter(predicate).findFirst();
        if (find.isPresent()) {
            reportData = find.get();
        }
        return reportData;
    }

    private DimensionInfoBean getMainDimensionInfoBean(DimensionInfoBean dimensionInfo, List<TemplateDim> simpleDimList) {
        LinkedList dimensionIdList = new LinkedList();
        LinkedList memberIdList = new LinkedList();
        for (int i = 0; i < simpleDimList.size(); ++i) {
            OptionalInt idxOpt;
            TemplateDim templateDim = simpleDimList.get(i);
            if (templateDim.isDetailDim() || templateDim.isViDim() || !(idxOpt = IntStream.range(0, dimensionInfo.getDimensionIdList().size()).filter(j -> ((Long)dimensionInfo.getDimensionIdList().get(j)).compareTo(templateDim.getDimensionId()) == 0).findAny()).isPresent()) continue;
            dimensionIdList.add(dimensionInfo.getDimensionIdList().get(idxOpt.getAsInt()));
            memberIdList.add(dimensionInfo.getMemberIdList().get(idxOpt.getAsInt()));
        }
        return new DimensionInfoBean(dimensionIdList, memberIdList);
    }

    private void setSubjectFlowValIfNeed(ReportCalcVal subjectCalcVal, DynamicObject subjectBaseData, ReportCalcModel reportCalcModel, ReportTemplate reportTemplate) {
        Long currCalcDimId = subjectCalcVal.getDimensionId();
        Optional<Long> subjectDimIdOpt = ReportHelper.getSubjectDimIdIfNeedUpdateSubjectFlow(reportTemplate);
        if (!subjectDimIdOpt.isPresent() || !Objects.equals(subjectDimIdOpt.get(), currCalcDimId)) {
            return;
        }
        ReportCalcVal subjectFlowCalcVal = reportCalcModel.getReportCalcVal(subjectCalcVal.getCol() + 1, subjectCalcVal.getRow());
        String val = subjectBaseData.getString("flow");
        Optional<String> displayValOpt = Arrays.stream(FlowEnum.values()).filter(flowEnum -> Objects.equals(flowEnum.getValue(), val)).map(FlowEnum::getName).findAny();
        Optional<Long> memberIdOpt = Arrays.stream(FlowType.values()).filter(flowType -> Objects.equals(flowType.getNumber(), val)).map(FlowType::getVirtualId).findAny();
        subjectFlowCalcVal.setValue(memberIdOpt.orElse(null));
        subjectFlowCalcVal.setDisplayVal(displayValOpt.orElse(""));
    }

    private void setDetailDimInfoIfNeed(ReportCalcVal reportCalcVal, ReportData reportData, TemplateDim templateDim, Object data) {
        if (DetailDimType.COUNTERPARTY_NAME == templateDim.getDetailDimType()) {
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dimValList = reportData.getDimValList();
            Optional<TemplateDim> typeDimOptional = dimList.stream().filter(item -> DetailDimType.CONNTERPARTY_TYPE == item.getDetailDimType()).findFirst();
            if (typeDimOptional.isPresent()) {
                TemplateDim typeDim = typeDimOptional.get();
                int typeDimIndex = dimList.indexOf(typeDim);
                Object currType = dimValList.get(typeDimIndex);
                reportCalcVal.getValueType().setValue(currType);
            }
            if ("0".equalsIgnoreCase(reportCalcVal.getDisplayVal())) {
                reportCalcVal.setDisplayVal("");
            }
        } else if (DetailDimType.PLAN_DATE == templateDim.getDetailDimType() || data instanceof Date) {
            String dateStr = data == null ? null : String.format("%s", ((Date)data).getTime());
            reportCalcVal.setDisplayVal(dateStr);
        } else if (reportCalcVal.getValueType().getReportCellType() == ReportCellType.BASE_DATA) {
            if ("0".equalsIgnoreCase(reportCalcVal.getDisplayVal())) {
                reportCalcVal.setDisplayVal("");
            }
        } else if (reportCalcVal.getValueType().getReportCellType() == ReportCellType.AMOUNT) {
            String memStr = data.toString();
            BigDecimal amount = BigDecimal.ZERO;
            if (NumberUtils.isNumber((String)memStr)) {
                amount = new BigDecimal(memStr);
            }
            reportCalcVal.setDisplayVal(amount.toString());
            reportCalcVal.setValue(amount);
        }
    }

    private void filterEmpty(DimensionInfoBean dimensionInfo) {
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        List memberIdList = dimensionInfo.getMemberIdList();
        for (int i = dimensionIdList.size() - 1; i >= 0; --i) {
            Long dimensionId = (Long)dimensionIdList.get(i);
            Dimension dimension = this.dimensionMap.get(dimensionId);
            if (Objects.isNull(dimension) || dimension.getDimType() == DimensionType.DETAILDIM) {
                memberIdList.remove(i);
                dimensionIdList.remove(i);
                continue;
            }
            Object memberId = memberIdList.get(i);
            if (!EmptyUtil.isEmpty(memberId)) continue;
            memberIdList.remove(i);
            dimensionIdList.remove(i);
        }
    }
}

