/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.DetailReportFormulaProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.DetailTotalRowBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PeriodStartEndSummaryFormulaDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataDefaultProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataProcessDetailAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataProcessFixAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportStructBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;

public class AnalysisReportExecutorOfExport
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList;

    public AnalysisReportExecutorOfExport(FundPlanSystem system, ReportDataSource report, AnalysisHeader headerInfo) {
        this.initActions(system, report, headerInfo);
    }

    private void initActions(FundPlanSystem system, ReportDataSource report, AnalysisHeader header) {
        this.actionList = new ArrayList<IReportDataProcessAction>(4);
        ArrayList<DimensionType> levelShowList = new ArrayList<DimensionType>();
        levelShowList.add(DimensionType.SUBJECTS);
        levelShowList.add(DimensionType.ORG);
        this.actionList.add(new ReportTemplateBuildV2Action(system, report, levelShowList));
        this.actionList.add(new ReportStructBuildAction(system, report));
        this.actionList.add(new DetailTotalRowBuildAction(system, report));
        this.actionList.add(this.getIReportDataProcessAction(system, report));
        this.actionList.add(new PeriodStartEndSummaryFormulaDataProcessAction(new DetailReportFormulaProcessAction(system, report)));
        this.actionList.add(new ReportDataDefaultProcessAction());
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        for (IReportDataProcessAction iReportDataProcessAction : this.actionList) {
            iReportDataProcessAction.execute(reportModel);
        }
    }

    private IReportDataProcessAction getIReportDataProcessAction(FundPlanSystem system, ReportDataSource report) {
        TemplateType templateType = report.getTemplate().getTemplateType();
        if (templateType == TemplateType.DETAIL) {
            return new ReportDataProcessDetailAction(system, report);
        }
        return new ReportDataProcessFixAction(system, report);
    }
}

