/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ExecBiasExtProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PeriodStartEndSummaryFormulaDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataProcessV2Action;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportStructSplitBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;

public class ExecBiasAnalysisDataProcessExecutor
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList;

    public ExecBiasAnalysisDataProcessExecutor(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS) {
        this.initActions(system, report, pageDimS);
    }

    private void initActions(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS) {
        this.actionList = new ArrayList<IReportDataProcessAction>(5);
        this.actionList.add(new ReportTemplateBuildV2Action(system, report));
        if (pageDimS == null) {
            this.actionList.add(new ReportStructSplitBuildAction(system, report));
        } else {
            this.actionList.add(new ReportStructSplitBuildAction(system, report, pageDimS));
        }
        this.actionList.add(new ReportDataProcessV2Action(system, report, true));
        this.actionList.add(new PeriodStartEndSummaryFormulaDataProcessAction(system, report));
        this.actionList.add(new ExecBiasExtProcessAction());
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ExecBiasAnalysisDataProcessExecutor.class.getSimpleName());){
            for (IReportDataProcessAction iReportDataProcessAction : this.actionList) {
                span.addTag(iReportDataProcessAction.getClass().getSimpleName());
                iReportDataProcessAction.execute(reportModel);
            }
        }
    }
}

