/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.DetailReportFormulaProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.DetailTotalRowBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PeriodStartEndSummaryFormulaDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReferenceReportNotExistsLockReferenceCellAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataProcessV2Action;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportStructSplitBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;

public class ReportDataProcessExecutor
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList;

    public ReportDataProcessExecutor(FundPlanSystem system, ReportDataSource report, boolean isSmartVersion) {
        this.initActions(system, report, null, null, isSmartVersion);
    }

    public ReportDataProcessExecutor(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS, boolean isSmartVersion) {
        this.initActions(system, report, pageDimS, null, isSmartVersion);
    }

    public ReportDataProcessExecutor(FundPlanSystem system, ReportDataSource report, Integer pageIndex, boolean isSmartVersion) {
        this.initActions(system, report, null, pageIndex, isSmartVersion);
    }

    private void initActions(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS, Integer pageIndex, boolean isSmartVersion) {
        this.actionList = new ArrayList<IReportDataProcessAction>(5);
        this.actionList.add(new ReportTemplateBuildV2Action(system, report));
        if (pageDimS == null && pageIndex == null) {
            this.actionList.add(new ReportStructSplitBuildAction(system, report));
        } else if (pageDimS != null) {
            this.actionList.add(new ReportStructSplitBuildAction(system, report, pageDimS));
        } else {
            this.actionList.add(new ReportStructSplitBuildAction(system, report, pageIndex));
        }
        this.actionList.add(new DetailTotalRowBuildAction(system, report));
        this.actionList.add(new ReportDataProcessV2Action(system, report, true));
        this.actionList.add(new PeriodStartEndSummaryFormulaDataProcessAction(new DetailReportFormulaProcessAction(system, report)));
        this.actionList.add(new ReferenceReportNotExistsLockReferenceCellAction(report));
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ReportDataProcessExecutor.class.getSimpleName());){
            for (IReportDataProcessAction iReportDataProcessAction : this.actionList) {
                span.addTag(iReportDataProcessAction.getClass().getSimpleName());
                iReportDataProcessAction.execute(reportModel);
            }
        }
    }
}

