/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.factory.ReportDataProcessActionFactory;
import kd.tmc.fpm.business.spread.generator.actions.impl.DataCellDisableAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PeriodStartEndSummaryFormulaDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReferenceReportNotExistsLockReferenceCellAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportStructBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;

public class SumPlanReportExecutor
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList;

    public SumPlanReportExecutor(FundPlanSystem system, ReportDataSource report) {
        this.initActions(system, report, null);
    }

    public SumPlanReportExecutor(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS) {
        this.initActions(system, report, pageDimS);
    }

    private void initActions(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS) {
        this.actionList = new ArrayList<IReportDataProcessAction>(5);
        Integer pageIndex = null;
        this.actionList.add(new ReportTemplateBuildV2Action(system, report));
        if (pageDimS == null) {
            this.actionList.add(new ReportStructBuildAction(system, report));
        } else if (pageDimS != null) {
            this.actionList.add(new ReportStructBuildAction(system, report, pageDimS));
        } else {
            this.actionList.add(new ReportStructBuildAction(system, report, pageIndex));
        }
        this.actionList.add(ReportDataProcessActionFactory.getReportDataProcessAction(report, system));
        this.actionList.add(new PeriodStartEndSummaryFormulaDataProcessAction(system, report));
        this.actionList.add(new ReferenceReportNotExistsLockReferenceCellAction(report));
        this.actionList.add(new DataCellDisableAction());
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        for (IReportDataProcessAction iReportDataProcessAction : this.actionList) {
            iReportDataProcessAction.execute(reportModel);
        }
    }
}

