/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.update.strategy;

import java.math.BigDecimal;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.spread.update.AbsCellValueUpdate;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;

public class TextCellValueUpdate
extends AbsCellValueUpdate {
    public TextCellValueUpdate(CellValueEvent event, Cell originCell) {
        super(event, originCell);
    }

    @Override
    protected Tuple<Boolean, String> check(CellValueEvent event, CellTypeEnum cellType) {
        if (EmptyUtil.isEmpty((Object)event.getNewValue())) {
            return CHECK_NOTCLEAR_MSG;
        }
        String newValue = event.getNewValue().toString();
        if (newValue.length() > 250) {
            event.setNewValue((Object)newValue.substring(0, 250));
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u6587\u672c\u957f\u5ea6\u8bf7\u63a7\u5236\u5728250\u4ee5\u5185", (String)"TextCellValueUpdate_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return CHECK_NOTCLEAR_MSG;
    }

    @Override
    protected void dealValue(Cell cell, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            BigDecimal bd = new BigDecimal(value.toString());
            value = String.format("%s", bd.toPlainString());
        }
        cell.setValue(value);
        cell.setNewValue(value);
        cell.setDisplayValue(value);
    }

    @Override
    public void custom(CellStyleInfo cellStyle) {
        super.custom(cellStyle);
        cellStyle.setFm("@");
    }
}

