/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.model.smartcollect.CollectLog;
import kd.tmc.fpm.business.mvc.service.smartcollect.CollectLogQueryService;
import kd.tmc.fpm.business.mvc.service.smartcollect.CollectLogService;
import kd.tmc.fpm.business.mvc.service.smartcollect.impl.CollectLogQueryServiceImpl;
import kd.tmc.fpm.business.mvc.service.smartcollect.impl.CollectLogServiceImpl;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.common.utils.NumberUtils;

public class CollectLogCleanTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CollectLogCleanTask.class);
    public static final String TIME_RANGE = "timeRange";
    public static final String MAX_LIMIT = "maxLimit";
    private CollectLogQueryService queryService = new CollectLogQueryServiceImpl();
    private CollectLogService logService = new CollectLogServiceImpl();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object timeParam = map.getOrDefault(TIME_RANGE, "15");
        Object maxLimitParam = map.getOrDefault(MAX_LIMIT, "500");
        int interval = Integer.parseInt(timeParam.toString());
        int maxLimit = Integer.parseInt(maxLimitParam.toString());
        FpmAssertUtil.isFalse((boolean)NumberUtils.greaterThan((Integer)interval, (Integer)90), (String)ResManager.loadKDString((String)"\u65e5\u671f\u95f4\u9694\u4e0d\u80fd\u8d85\u8fc790\u5929\u3002", (String)"CollectLogCleanTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        FpmAssertUtil.isFalse((boolean)NumberUtils.lessThan((Integer)interval, (Integer)0), (String)ResManager.loadKDString((String)"\u65e5\u671f\u95f4\u9694\u4e0d\u80fd\u5c0f\u4e8e0\u5929\u3002", (String)"CollectLogCleanTask_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        FpmAssertUtil.isFalse((boolean)NumberUtils.greaterThan((Integer)maxLimit, (Integer)1000), (String)ResManager.loadKDString((String)"\u6700\u5927\u6e05\u7406\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc71000\u6761\u3002", (String)"CollectLogCleanTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        FpmAssertUtil.isFalse((boolean)NumberUtils.lessThan((Integer)maxLimit, (Integer)0), (String)ResManager.loadKDString((String)"\u6700\u5927\u6e05\u7406\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u6761\u3002", (String)"CollectLogCleanTask_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        Timestamp currentTime = DateUtils.getCurrentTime();
        Date endTime = DateUtils.getLastDay((Date)currentTime, (int)interval);
        int realDelCount = 0;
        int count = this.queryService.countCollectLogsByEndTime(endTime);
        if (count <= 0) {
            logger.info("\u91c7\u96c6\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1\u5df2\u7ed3\u675f\uff0c\u67e5\u8be2\u65e0\u5f85\u6e05\u7406\u65e5\u5fd7");
            return;
        }
        int pageSize = count / maxLimit + 1;
        logger.info("\u91c7\u96c6\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1\u5df2\u542f\u52a8\uff0c\u5f53\u524d\u5f85\u6e05\u7406\u6570\u91cf\uff1a{}\uff0c\u6279\u6b21\u6700\u5927\u6267\u884c\u6570\u91cf\uff1a{}\uff0c\u603b\u9875\u6570\uff1a{}", new Object[]{count, maxLimit, pageSize});
        for (int i = 0; i < pageSize; ++i) {
            try {
                int delNum = this.handleDeleteLog(maxLimit, endTime);
                realDelCount += delNum;
                if (delNum > 0) continue;
                break;
            }
            catch (Exception e) {
                logger.error("\u91c7\u96c6\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
            }
        }
        logger.info("\u91c7\u96c6\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1\u5df2\u7ed3\u675f\uff0c\u5171\u8ba1\u5904\u7406:{}", (Object)realDelCount);
    }

    private int handleDeleteLog(int maxLimit, Date endTime) {
        List<CollectLog> collectLogs = this.queryService.queryCollectLogsByEndTime(endTime, maxLimit);
        if (CollectionUtils.isEmpty(collectLogs)) {
            logger.info("\u91c7\u96c6\u65e5\u5fd7\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u9700\u8fdb\u884c\u65e5\u5fd7\u6e05\u7406.");
            return 0;
        }
        List<Long> collectIds = collectLogs.stream().map(CollectLog::getId).collect(Collectors.toList());
        this.logService.batchDeleteCollectLogs(collectIds);
        return collectIds.size();
    }
}

