/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.opservice.inoutpool.CronPlanCollectGenerateBillService;
import org.apache.commons.collections.CollectionUtils;

public class CronPlanGenInoutCollectBillTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CronPlanGenInoutCollectBillTask.class);
    public static final int SINGLE_EXEC_LIMIT = 10;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int futureDays = this.getParamValOrDefault(map);
        logger.info("\u5468\u671f\u6027\u4efb\u52a1\u6267\u884c\u53c2\u6570\uff1afutureDays:{}", (Object)futureDays);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_cronplanmaintain", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (load == null || load.length == 0) {
            String errorMessage = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6a21\u677f\u3002", (String)"CronPlanGenInoutCollectBillTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
            logger.info(errorMessage);
            throw new KDBizException(errorMessage);
        }
        List stringList = Arrays.stream(load).map(DataEntityBase::getPkValue).filter(EmptyUtil::isNoEmpty).map(String::valueOf).collect(Collectors.toList());
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("GENERATE_OPERATOR_VARIABLE_DAYS", String.valueOf(futureDays));
        int count = 1;
        List partitionIds = Lists.partition(stringList, (int)10);
        for (List partitionId : partitionIds) {
            String templateIdStr = String.join((CharSequence)",", partitionId.toArray(new String[0]));
            operateOption.setVariableValue("GENERATE_OPERATOR_VARIABLE_TEMPLATE_ID", templateIdStr);
            OperationResult operationResult = this.doGenerateBill(operateOption);
            this.processResult(operationResult, count);
            ++count;
        }
    }

    private OperationResult doGenerateBill(OperateOption operateOption) {
        logger.info("\u4efb\u52a1\u8c03\u5ea6-\u5f00\u59cb\u6267\u884c\u5355\u636e\u751f\u6210");
        CronPlanCollectGenerateBillService cronPlanCollectGenerateBillService = new CronPlanCollectGenerateBillService();
        cronPlanCollectGenerateBillService.setOperationResult(new OperationResult());
        cronPlanCollectGenerateBillService.setOperationVariable(operateOption.getVariables());
        cronPlanCollectGenerateBillService.process(null);
        OperationResult operationResult = cronPlanCollectGenerateBillService.getOperationResult();
        logger.info("\u4efb\u52a1\u8c03\u5ea6-\u5355\u636e\u751f\u6210\u6267\u884c\u7ed3\u675f");
        return operationResult;
    }

    private void processResult(OperationResult operationResult, int count) {
        if (operationResult.isSuccess()) {
            logger.info("\u7b2c{}\u6279\u751f\u6210\u5355\u636e\u7ed3\u679c\uff1a " + operationResult.getMessage(), (Object)count);
            return;
        }
        List allErrorInfo = operationResult.getAllErrorInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorInfo)) {
            logger.info("\u7b2c{}\u6279\u751f\u6210\u5355\u636e\u7ed3\u679c\uff1a " + operationResult.getMessage(), (Object)count);
        }
        OperateErrorInfo operateErrorInfo = (OperateErrorInfo)allErrorInfo.get(0);
        logger.info("\u7b2c{}\u6279\u751f\u6210\u5355\u636e\u7ed3\u679c\uff1a " + operateErrorInfo.getMessage(), (Object)count);
    }

    private int getParamValOrDefault(Map<String, Object> map) {
        Object futureDaySObj = map.get("futuredays");
        int futureDays = 30;
        if (EmptyUtil.isEmpty((Object)futureDaySObj)) {
            logger.info("\u6ca1\u6709\u914d\u7f6e\u53c2\u6570\u3010{}\u3011\u6216\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1a30\u5929", (Object)"futuredays");
        } else if (futureDaySObj instanceof Integer) {
            futureDays = (Integer)futureDaySObj;
            logger.info("{}:\u53c2\u6570\u503c\u4e3a:{}", (Object)"futuredays", (Object)futureDays);
        } else if (futureDaySObj instanceof String) {
            try {
                futureDays = Integer.parseInt((String)futureDaySObj);
                logger.info("{}:\u53c2\u6570\u503c\u4e3a:{}", (Object)"futuredays", (Object)futureDays);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return futureDays;
    }
}

