/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.AbstractOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.common.enums.WaysEnum;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import kd.tmc.fpm.common.property.MemberManagerListProp;
import kd.tmc.fpm.common.result.TreeDataSelectedNode;
import kd.tmc.fpm.common.result.TreeDataSelectedReturnData;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DimMemberImportTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DimMemberImportTask.class);
    private IFormView formView;
    private IPageCache pageCache;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map == null) {
            return;
        }
        String pageId = (String)map.get("pageId");
        String dimNumber = (String)map.get("dimNumber");
        String treeDataSelectedReturnDataJson = (String)map.get("treeDataSelectedReturnDataJson");
        TreeDataSelectedReturnData treeDataSelectedReturnData = (TreeDataSelectedReturnData)JSON.parseObject((String)treeDataSelectedReturnDataJson, TreeDataSelectedReturnData.class);
        DimsionEnums dimensionEnum = DimsionEnums.getDimsionByNumber((String)dimNumber);
        Long dimId = (Long)map.get("dimId");
        Long systemId = (Long)map.get("systemId");
        IFormView view = SessionManager.getCurrent().getView(pageId);
        PageCache pageCache = new PageCache(pageId);
        view.addService(IPageCache.class, (Object)pageCache);
        this.formView = view;
        this.pageCache = pageCache;
        this.doExecute(dimId, dimensionEnum, systemId, treeDataSelectedReturnData);
    }

    private void doExecute(Long dimId, DimsionEnums dimensionEnum, Long systemId, TreeDataSelectedReturnData returnData) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(8);
        returnDataMap.put("success", true);
        try {
            this.updatePercent(0, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85", (String)"SystemBackupsTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
            List<DynamicObject> memberDOList = this.nodeToDynamicObjectList(returnData, systemId, dimId, dimensionEnum);
            if (CollectionUtils.isEmpty(memberDOList)) {
                this.feedbackCustomdata(returnDataMap);
                this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"SystemBackupsTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
                return;
            }
            OperationResult execOperateResult = null;
            if (Objects.nonNull(MemberManagerListProp.DIM_MEMBER_SAVE_OP_MAP.get(dimensionEnum.getNumber()))) {
                execOperateResult = OperationServiceHelper.executeOperate((String)((String)MemberManagerListProp.DIM_MEMBER_SAVE_OP_MAP.get(dimensionEnum.getNumber())), (String)dimensionEnum.getMetadata(), (DynamicObject[])memberDOList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            if (execOperateResult == null || execOperateResult.isSuccess()) {
                execOperateResult = OperationServiceHelper.executeOperate((String)"save", (String)dimensionEnum.getMetadata(), (DynamicObject[])memberDOList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            if (!execOperateResult.isSuccess()) {
                returnDataMap.put("success", false);
                ValidateResultCollection tValidateResult = execOperateResult.getValidateResult();
                ArrayList errorMsgList = new ArrayList(10);
                tValidateResult.getValidateErrors().stream().map(AbstractOperationResult::getAllErrorInfo).flatMap(Collection::stream).forEach(operateErrorInfo -> {
                    String[] errMsg = operateErrorInfo.getMessage().split(":");
                    if (errMsg.length > 1) {
                        errorMsgList.add(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011%2$s", (String)"DimensionManagerList_28", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMsg[0], errMsg[1].trim()));
                    } else {
                        errorMsgList.add(operateErrorInfo.getMessage());
                    }
                });
                returnDataMap.put("errorMessages", errorMsgList);
            } else {
                for (Object pkId : execOperateResult.getSuccessPkIds()) {
                    OperationServiceHelper.executeOperate((String)"submitop", (String)dimensionEnum.getMetadata(), (Object[])new Object[]{pkId}, (OperateOption)OperateOption.create());
                }
                if (FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
                    OperationServiceHelper.executeOperate((String)"syncdim_mdd", (String)"fpm_dimension", (Object[])new Object[]{dimId}, (OperateOption)OperateOption.create());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            returnDataMap.put("success", false);
            String errMsg = StringUtils.isEmpty((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DimMemberImportTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]) : e.getMessage();
            returnDataMap.put("errorMessages", Collections.singletonList(errMsg));
        }
        this.feedbackCustomdata(returnDataMap);
        this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"SystemBackupsTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
    }

    public void updatePercent(int process, String message, Map<String, Object> customData) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.feedbackProgress(process, message, customData);
        } else {
            this.feedbackProgress(process);
        }
    }

    private List<DynamicObject> nodeToDynamicObjectList(TreeDataSelectedReturnData returnData, Long modelId, Long dimId, DimsionEnums dimEnums) {
        DynamicObject parent;
        Long realId;
        ArrayList<DynamicObject> newMemberList = new ArrayList<DynamicObject>(0);
        List tRightNodeList = returnData.getRightNodeList().stream().filter(TreeDataSelectedNode::isNew).collect(Collectors.toList());
        if (tRightNodeList.size() < 1) {
            return newMemberList;
        }
        String metadata = dimEnums.getMetadata();
        DynamicObject bodysystem = (DynamicObject)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage").createInstance();
        bodysystem.set("id", (Object)modelId);
        HashMap bosOrgMap = Collections.emptyMap();
        Map<Object, Object> tFundFlowMap = Collections.emptyMap();
        DynamicObject bodySysManager = null;
        if (DimsionEnums.ORG.getNumber().equals(dimEnums.getNumber()) || DimsionEnums.COMPANY.getNumber().equals(dimEnums.getNumber())) {
            MainEntityType bosOrgEntityType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            bosOrgMap = Maps.newHashMapWithExpectedSize((int)tRightNodeList.size());
            for (TreeDataSelectedNode item2 : tRightNodeList) {
                DynamicObject bosOrgDy = (DynamicObject)bosOrgEntityType.createInstance();
                bosOrgDy.set("id", (Object)item2.getId());
                bosOrgMap.put(String.valueOf(item2.getId()), bosOrgDy);
            }
        } else if (DimsionEnums.SUBJECT.getNumber().equals(dimEnums.getNumber())) {
            bodySysManager = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"id,number,org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
            DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"cas_fundflowitem", (String)"id,direction", (QFilter[])new QFilter[]{new QFilter("id", "in", tRightNodeList.stream().map(item -> Long.valueOf(item.getId())).collect(Collectors.toList()))});
            tFundFlowMap = queryResult.stream().collect(Collectors.toMap(item -> item.getString("id"), Function.identity(), (key1, key2) -> key2));
        }
        String userId = RequestContext.get().getUserId();
        Date curTime = new Date();
        long[] newIDArr = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)metadata).getAlias(), (int)tRightNodeList.size());
        Deque newIdQueue = Arrays.stream(newIDArr).boxed().collect(Collectors.toCollection(LinkedList::new));
        HashMap<Long, Long> realIdMap = new HashMap<Long, Long>(newIdQueue.size());
        for (TreeDataSelectedNode tRightNode : tRightNodeList) {
            DynamicObject treeMem = BusinessDataServiceHelper.newDynamicObject((String)metadata);
            realId = (Long)newIdQueue.poll();
            treeMem.set("id", (Object)realId);
            realIdMap.put(Long.valueOf(tRightNode.getId()), realId);
            treeMem.set("number", (Object)tRightNode.getNumber());
            treeMem.set("name", (Object)tRightNode.getName());
            treeMem.set("fullname", (Object)tRightNode.getName());
            treeMem.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            treeMem.set("creator", (Object)userId);
            treeMem.set("enable", (Object)"1");
            treeMem.set("modifier", (Object)userId);
            treeMem.set("masterid", (Object)Long.valueOf(tRightNode.getId()));
            treeMem.set("createtime", (Object)curTime);
            treeMem.set("modifytime", (Object)curTime);
            treeMem.set("bodysystem", (Object)bodysystem);
            treeMem.set("dimtype", (Object)dimEnums.getNumber());
            treeMem.set("serial", (Object)System.nanoTime());
            if (DimsionEnums.ORG.getNumber().equals(dimEnums.getNumber()) || DimsionEnums.SUBJECT.getNumber().equals(dimEnums.getNumber())) {
                treeMem.set("level", (Object)tRightNode.getLevel());
                treeMem.set("isleaf", (Object)tRightNode.isLeaf());
                if (tRightNode.getParentId() != null && tRightNode.getParentId().length() > 0) {
                    parent = BusinessDataServiceHelper.newDynamicObject((String)metadata);
                    parent.set("id", (Object)Long.valueOf(tRightNode.getParentId()));
                    treeMem.set("parent", (Object)parent);
                    treeMem.set("sourceparentid", (Object)Long.valueOf(tRightNode.getParentId()));
                }
                if (DimsionEnums.ORG.getNumber().equals(dimEnums.getNumber())) {
                    treeMem.set("caporg", bosOrgMap.get(tRightNode.getId()));
                }
            } else {
                treeMem.set("level", (Object)1);
                treeMem.set("isleaf", (Object)Boolean.TRUE);
                treeMem.set("sumtype", (Object)MemberSumEnum.PLUS.getCode());
            }
            treeMem.set("sourceid", (Object)Long.valueOf(tRightNode.getId()));
            treeMem.set("dimension", (Object)dimId);
            if (DimsionEnums.COMPANY.getNumber().equals(dimEnums.getNumber())) {
                treeMem.set("relcaporg", bosOrgMap.get(tRightNode.getId()));
            } else if (DimsionEnums.SUBJECT.getNumber().equals(dimEnums.getNumber())) {
                DynamicObject fundflowitem;
                treeMem.set("bodysysmanage", (Object)bodysystem);
                if (bodySysManager != null) {
                    treeMem.set("org", bodySysManager.get("org"));
                }
                if ((fundflowitem = (DynamicObject)tFundFlowMap.get(tRightNode.getId())) != null) {
                    treeMem.set("flow", (Object)fundflowitem.getString("direction"));
                }
                if (tRightNode.isLeaf()) {
                    treeMem.set("ways", (Object)WaysEnum.MANUAL_INPUT.getValue());
                } else {
                    treeMem.set("ways", (Object)WaysEnum.SUMMARY_ITEM.getValue());
                }
            }
            newMemberList.add(treeMem);
        }
        ArrayList<DynamicObject> updateMemberList = new ArrayList(newMemberList.size());
        for (DynamicObject newMember : newMemberList) {
            realId = (Long)realIdMap.get(newMember.getLong("parent.id"));
            if (realId != null) {
                parent = BusinessDataServiceHelper.newDynamicObject((String)metadata);
                parent.set("id", (Object)realId);
                newMember.set("parent", (Object)parent);
            }
            updateMemberList.add(newMember);
        }
        updateMemberList = updateMemberList.stream().sorted(Comparator.comparingInt(v -> v.getInt("level"))).collect(Collectors.toList());
        return updateMemberList;
    }
}

