/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtConsistencyLog;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtExceptionInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.dto.InspectLogQueryParamDTO;
import kd.tmc.fpm.business.mvc.service.inspection.query.InspectLogQueryService;
import kd.tmc.fpm.business.mvc.service.inspection.query.impl.InspectLogQueryServiceImpl;

public class InspectionMonitorTask
implements FIDataCheckTask {
    private static final Log LOGGER = LogFactory.getLog(InspectionMonitorTask.class);
    private InspectLogQueryService queryService = new InspectLogQueryServiceImpl();
    private ReportRepository reportRepository = new ReportRepository();

    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        String checkMsg = this.check();
        if (EmptyUtil.isNoEmpty((String)checkMsg)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u8ba1\u5212\u63a7\u5236\u6570\u636e\u68c0\u67e5\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff1a\n\t %1$s", (String)"InspectionMonitorTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]), checkMsg);
            FIDataCheckUtil.saveResult((String)"InspectionMonitorTask", (String)"fpm", (boolean)false, (String)errorMsg, (String)"kd.tmc.fpm.business.task.InspectionMonitorTask");
            return false;
        }
        return true;
    }

    private String check() {
        DynamicObject[] bodySystems;
        Timestamp currentDate = DateUtils.getCurrentTime();
        Date lastDay = DateUtils.getLastDay((Date)currentDate, (int)1);
        StringBuilder result = new StringBuilder();
        for (DynamicObject bodySystem : bodySystems = BusinessDataServiceHelper.load((String)"fpm_bodysysmanage", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))})) {
            List errorInspectionDetails;
            InspectLogQueryParamDTO inspectLogQueryParamDTO = new InspectLogQueryParamDTO();
            inspectLogQueryParamDTO.setSystemId(bodySystem.getLong("id"));
            inspectLogQueryParamDTO.setInspectLogScope(InspectionScope.REPORT_INSPECTION.getNumber());
            inspectLogQueryParamDTO.setExecuteTimeStart(lastDay);
            inspectLogQueryParamDTO.setExecuteTimeEnd(currentDate);
            List<AmtConsistencyLog> inspectionLogs = this.queryService.queryErrorLogsByParam(inspectLogQueryParamDTO);
            if (CollectionUtils.isEmpty(inspectionLogs) || CollectionUtils.isEmpty(errorInspectionDetails = inspectionLogs.stream().map(AmtConsistencyLog::getAmtExceptionInfoList).flatMap(Collection::stream).filter(item -> item.getRepairResult() == InspectionRepairResult.PENDING).limit(50L).collect(Collectors.toList()))) continue;
            Set<Long> reportIds = errorInspectionDetails.stream().map(AmtExceptionInfo::getReportId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(reportIds)) {
                LOGGER.info("\u4f53\u7cfb\uff1a{}\u4e0b\u6267\u884c\u989d\u5ea6\u4e0d\u4e00\u81f4\u5de1\u68c0\u65e5\u5fd7\u4e2d\u5173\u8054\u7684\u7f16\u5236\u8868\u6570\u636e\u4e3a\u7a7a", (Object)bodySystem.getString("number"));
                continue;
            }
            List<Report> reports = this.reportRepository.loadSimpleReport(reportIds, t -> {
                t.setNeedCompanyMember(true);
                t.setNeedPeriodMember(true);
                t.setNeedReportPeriodType(true);
            });
            if (CollectionUtils.isEmpty(reports)) {
                LOGGER.info("\u4f53\u7cfb\uff1a{}\u4e0b\u5de1\u68c0\u65e5\u5fd7\u67e5\u8be2\u7f16\u5236\u8868\u6570\u636e\u4e3a\u7a7a", (Object)bodySystem.getString("number"));
                continue;
            }
            Map<Long, Report> reportMap = reports.stream().collect(Collectors.toMap(Report::getId, v -> v));
            String checkMsg = ResManager.loadKDString((String)"\u4f53\u7cfb\uff1a%1$s\uff0c\u8ba1\u5212\u7f16\u5236\u8868\uff1a%2$s\uff0c\u7f16\u62a5\u4e3b\u4f53\uff1a%3$s\uff0c\u7f16\u62a5\u671f\u95f4\uff1a%4$s\uff0c\u5b58\u5728\u5f02\u5e38\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%5$s\uff0c\u5f02\u5e38\u60c5\u51b5\uff1a%6$s\u3002", (String)"InspectionMonitorTask_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
            for (AmtExceptionInfo exceptionInfo : errorInspectionDetails) {
                Long reportId = exceptionInfo.getReportId();
                Report report = reportMap.get(reportId);
                if (Objects.isNull(report)) continue;
                String format = String.format(checkMsg, bodySystem.getString("number"), report.getNumber() + "-" + report.getName(), report.getCompanyMemberList().get(0).getName(), report.getCurrentReportPeriod().getName(), exceptionInfo.getDimensionCombo(), exceptionInfo.getErrorInfo());
                result.append(format).append("\n\t");
            }
        }
        return result.toString();
    }
}

