/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.AbstractOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fpm.business.task.DimMemberImportTask;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportAsyncOpTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DimMemberImportTask.class);
    private IFormView formView;
    private IPageCache pageCache;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map == null) {
            return;
        }
        String pageId = (String)map.get("pageId");
        List ids = (List)map.get("ids");
        String entityNumber = (String)map.get("entityNumber");
        String opKey = (String)map.get("opKey");
        IFormView view = SessionManager.getCurrent().getView(pageId);
        PageCache pageCache = new PageCache(pageId);
        view.addService(IPageCache.class, (Object)pageCache);
        this.formView = view;
        this.pageCache = pageCache;
        this.doExecute(ids, entityNumber, opKey);
    }

    private void doExecute(List<Long> ids, String entityNumber, String opKey) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(8);
        returnDataMap.put("success", true);
        try {
            this.updatePercent(0, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85", (String)"SystemBackupsTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
            if (CollectionUtils.isEmpty(ids)) {
                this.feedbackCustomdata(returnDataMap);
                this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"SystemBackupsTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
                return;
            }
            OperationResult execOperateResult = OperationServiceHelper.executeOperate((String)opKey, (String)entityNumber, (Object[])ids.toArray(new Object[0]), (OperateOption)OperateOption.create());
            if (!execOperateResult.isSuccess()) {
                returnDataMap.put("success", false);
                ValidateResultCollection tValidateResult = execOperateResult.getValidateResult();
                ArrayList errorMsgList = new ArrayList(10);
                tValidateResult.getValidateErrors().stream().map(AbstractOperationResult::getAllErrorInfo).flatMap(Collection::stream).forEach(operateErrorInfo -> {
                    String[] errMsg = operateErrorInfo.getMessage().split(":");
                    if (errMsg.length > 1) {
                        errorMsgList.add(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011%2$s", (String)"DimensionManagerList_28", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMsg[0], errMsg[1].trim()));
                    } else {
                        errorMsgList.add(operateErrorInfo.getMessage());
                    }
                });
                returnDataMap.put("errorMessages", errorMsgList);
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            returnDataMap.put("success", false);
            String errMsg = StringUtils.isEmpty((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DimMemberImportTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]) : e.getMessage();
            returnDataMap.put("errorMessages", Collections.singletonList(errMsg));
        }
        this.feedbackCustomdata(returnDataMap);
        this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"SystemBackupsTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
    }

    public void updatePercent(int process, String message, Map<String, Object> customData) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.feedbackProgress(process, message, customData);
        } else {
            this.feedbackProgress(process);
        }
    }
}

