/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.ReportImportTypeEnum;
import kd.tmc.fpm.business.mvc.service.IReportImportDataBizService;
import kd.tmc.fpm.business.mvc.service.impl.ReportImportDataBizServiceImpl;
import kd.tmc.fpm.business.utils.ImportDataHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportImportDataTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ReportImportDataTask.class);
    private IFormView formView;
    private IPageCache pageCache;
    private IReportImportDataBizService reportImportDataBizService;
    private ReportImportTypeEnum reportImportType;
    public static final String MUTEX_GROUP_ID = "default_netctrl";
    public static final String MUTEX_OP_KEY = "modify";
    private List<String> lockRequestSuccessIdList = new ArrayList<String>(16);

    public ReportImportDataTask() {
        this.reportImportDataBizService = new ReportImportDataBizServiceImpl();
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map == null) {
            return;
        }
        String pageId = (String)map.get("pageId");
        this.reportImportType = ReportImportTypeEnum.getByCode((String)map.get("reportImportType"));
        IFormView view = SessionManager.getCurrent().getView(pageId);
        PageCache pageCache = new PageCache(pageId);
        view.addService(IPageCache.class, (Object)pageCache);
        this.formView = view;
        this.pageCache = pageCache;
        this.pageCache.put("reportFileUrl", (String)map.get("reportFileUrl"));
        this.doExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute() {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        returnDataMap.put("success", true);
        try {
            this.updatePercent(0, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"ReportImportDataTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
            this.handleImportData();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25 ", (Throwable)e);
            returnDataMap.put("success", false);
            String errMsg = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportImportDataTask_1", (String)"tmc-fpm-business", (Object[])new Object[0]) : e.getMessage();
            returnDataMap.put("errorMessage", errMsg);
        }
        finally {
            if (!CollectionUtils.isEmpty(this.lockRequestSuccessIdList)) {
                MutexServiceHelper.batchRelease(new ArrayList<String>(this.lockRequestSuccessIdList), (String)MUTEX_GROUP_ID, (String)"fpm_report", (String)MUTEX_OP_KEY);
            }
        }
        this.feedbackCustomdata(returnDataMap);
        this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\u3002", (String)"ReportImportDataTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
    }

    private void handleImportData() throws IOException {
        List<InputStream> importStreamFromCache = this.getImportStreamFromCache(this.pageCache);
        int size = importStreamFromCache.size();
        if (size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bfc\u5165\u4e00\u4e2aExcel\u6587\u4ef6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataTask_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        XSSFWorkbook xssfWorkBook = this.getXssfWorkBook(importStreamFromCache.get(0));
        if (xssfWorkBook.getNumberOfSheets() > 300) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u4e2d\u6700\u591a\u4ec5\u652f\u6301\u5bfc\u5165300\u4e2asheet\u9875\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataTask_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        this.validateImportData(xssfWorkBook);
        Map<String, List<Sheet>> sheetReportMap = this.groupSheet(xssfWorkBook);
        this.importWorkBookData(sheetReportMap, xssfWorkBook.getNumberOfSheets());
    }

    private void validateImportData(XSSFWorkbook xssfWorkBook) {
        HashMap<String, Sheet> sheetMap = new HashMap<String, Sheet>(1);
        StringBuilder errMsg = null;
        HashMap<String, String> reportNumberMap = new HashMap<String, String>(16);
        for (Sheet sheet : xssfWorkBook) {
            if (xssfWorkBook.isSheetHidden(xssfWorkBook.getSheetIndex(sheet))) continue;
            String systemNum = ImportDataHelper.getSystemNum(sheet);
            String reportNumber = ImportDataHelper.getReportNumber(sheet);
            String reportPeriodNum = ImportDataHelper.getReportPeriodNum(sheet);
            DynamicObject report = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reportNumber), new QFilter("billstatus", "=", (Object)BillStatus.STAGE.getNumber())});
            sheetMap.put(systemNum + reportPeriodNum, sheet);
            if (report == null) {
                errMsg = new StringBuilder(String.format(ResManager.loadKDString((String)"\u6309\u201c\u62a5\u8868\u7f16\u7801\u201d\u65e0\u6cd5\u5339\u914d\u5230\u7cfb\u7edf\u4e2d\u6682\u5b58\u72b6\u6001\u7684\u8ba1\u5212\u7f16\u5236\u8868\u201c%1$s\u201d\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ReportImportDataTask_6", (String)"tmc-fpm-business", (Object[])new Object[0]), reportNumber));
                break;
            }
            if (this.reportImportType == ReportImportTypeEnum.IMPORT_SINGLE) {
                long currentReportId = this.formView.getModel().getDataEntity().getLong("reportid");
                if (report.getLong("id") != currentReportId) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6309\u201c\u62a5\u8868\u7f16\u7801\u201d\u65e0\u6cd5\u5339\u914d\u5230\u5f53\u524d\u8ba1\u5212\u7f16\u5236\u8868\u201c%1$s\u201d\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ReportImportDataTask_5", (String)"tmc-fpm-business", (Object[])new Object[0]), reportNumber));
                }
            }
            reportNumberMap.put(report.getPkValue().toString(), reportNumber);
        }
        if (this.needLock()) {
            this.batchGetLock(reportNumberMap);
        }
        if (errMsg != null) {
            throw new KDBizException(errMsg.toString());
        }
        if (sheetMap.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u4ec5\u652f\u6301\u5bfc\u5165\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u7684\u8ba1\u5212\u8868\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReportImportDataTask_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    private boolean needLock() {
        return this.reportImportType != ReportImportTypeEnum.IMPORT_SINGLE;
    }

    private void batchGetLock(Map<String, String> reportNumberMap) {
        StringBuilder errMsg = null;
        ArrayList<String> requestFailIds = new ArrayList<String>(reportNumberMap.size());
        Set<String> reportIdSet = reportNumberMap.keySet();
        Map request = MutexServiceHelper.batchRequest(new ArrayList<String>(reportIdSet), (String)MUTEX_GROUP_ID, (String)"fpm_report", (String)MUTEX_OP_KEY);
        for (Map.Entry entry : request.entrySet()) {
            String key = (String)entry.getKey();
            if (((Boolean)entry.getValue()).booleanValue()) {
                this.lockRequestSuccessIdList.add(key);
                continue;
            }
            requestFailIds.add(key);
        }
        if (!CollectionUtils.isEmpty(requestFailIds)) {
            errMsg = new StringBuilder();
            for (String requestFailId : requestFailIds) {
                String mutexMsg = this.getMutexMsg(requestFailId, reportNumberMap.get(requestFailId));
                errMsg.append(mutexMsg).append("\n");
            }
        }
        if (errMsg != null) {
            throw new KDBizException(errMsg.toString());
        }
    }

    private Map<String, List<Sheet>> groupSheet(XSSFWorkbook xssfWorkBook) {
        HashMap<String, List<Sheet>> resultMap = new HashMap<String, List<Sheet>>(16);
        for (Sheet sheet : xssfWorkBook) {
            String reportNumber = ImportDataHelper.getReportNumber(sheet);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reportNumber)) continue;
            if (resultMap.containsKey(reportNumber)) {
                ((List)resultMap.get(reportNumber)).add(sheet);
                continue;
            }
            ArrayList<Sheet> sheetList = new ArrayList<Sheet>();
            sheetList.add(sheet);
            resultMap.put(reportNumber, sheetList);
        }
        return resultMap;
    }

    private void importWorkBookData(Map<String, List<Sheet>> sheetReportMap, int size) {
        int idx = 0;
        for (Map.Entry<String, List<Sheet>> entry : sheetReportMap.entrySet()) {
            String reportNumber = entry.getKey();
            DynamicObject report = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reportNumber), new QFilter("billstatus", "=", (Object)BillStatus.STAGE.getNumber())});
            this.reportImportDataBizService.importReportBatch(report.getLong("id"), entry.getValue());
            int percent = (size - (idx + entry.getValue().size())) / size * 100;
            this.updatePercent(percent, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"ReportImportDataTask_8", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
        }
    }

    public void updatePercent(int process, String message, Map<String, Object> customData) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)message)) {
            this.feedbackProgress(process, message, customData);
        } else {
            this.feedbackProgress(process);
        }
    }

    private List<InputStream> getImportStreamFromCache(IPageCache pageCache) {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String fileUrl = pageCache.get("reportFileUrl");
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(16);
        if (fileUrl != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
            try {
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    inputStreams.add(inputStream);
                }
            }
            catch (MalformedURLException e) {
                logger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportImportDataTask_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
        if (inputStreams.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"ReportImportDataTask_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return inputStreams;
    }

    private XSSFWorkbook getXssfWorkBook(InputStream inputStream) throws IOException {
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try {
            XSSFWorkbook xSSFWorkbook = (XSSFWorkbook)WorkbookFactory.create((InputStream)inputStream);
            return xSSFWorkbook;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMutexMsg(String dataId, String reportNumber) {
        try (DataMutex dataMutex = DataMutex.create();){
            Map lockInfo = dataMutex.getLockInfo(dataId, MUTEX_GROUP_ID, "fpm_report");
            if (MapUtils.isEmpty((Map)lockInfo)) {
                String string = this.defaultMessage(reportNumber);
                return string;
            }
            String userid = (String)lockInfo.get("userid");
            if (StringUtils.isEmpty((Object)userid)) {
                String string = this.defaultMessage(reportNumber);
                return string;
            }
            Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong((String)lockInfo.get("userid")));
            if (MapUtils.isEmpty((Map)userInfo)) {
                String string = this.defaultMessage(reportNumber);
                return string;
            }
            Object name = userInfo.get("name");
            if (StringUtils.isEmpty(name)) {
                String string = this.defaultMessage(reportNumber);
                return string;
            }
            String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u5df2\u88ab\u7528\u6237\u3010%2$s\u3011\u5360\u7528\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ReportImportDataTask_11", (String)"tmc-fpm-business", (Object[])new Object[0]), reportNumber, name);
            return string;
        }
        catch (IOException e) {
            logger.warn("\u6253\u5f00\u9875\u9762\u67e5\u770b\u5360\u7528\u7528\u6237\u4fe1\u606f\u4fe1\u606f\u62a5\u9519", (Throwable)e);
            return this.defaultMessage(reportNumber);
        }
    }

    private String defaultMessage(String number) {
        return String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u5df2\u88ab\u5360\u7528\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ReportImportDataTask_12", (String)"tmc-fpm-business", (Object[])new Object[0]), number);
    }
}

