/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.CalcExprParser;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillUtils {
    public static Set<String> parseFieldsFormCondition(String conditionStr, String entityType) {
        if (EmptyUtil.isEmpty((String)conditionStr)) {
            return Collections.emptySet();
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionStr, CRCondition.class);
        Set<String> fieldNames = BillUtils.doParseFilterCondition(entityType, condition);
        String expression = condition.getExpression();
        if (EmptyUtil.isEmpty((String)expression)) {
            return fieldNames;
        }
        String[] exprVariables = CalcExprParser.getExprVariables((String)expression);
        Arrays.stream(exprVariables).forEach(fieldNames::add);
        return fieldNames;
    }

    private static Set<String> doParseFilterCondition(String entityType, CRCondition condition) {
        FilterCondition filterCondition = condition.getFilterCondition();
        List filterFiledRows = filterCondition.getFilterRow();
        HashSet<String> set = new HashSet<String>(16);
        if (EmptyUtil.isEmpty((Collection)filterFiledRows)) {
            return set;
        }
        Map<String, String> propEntryMap = BillUtils.getPropEntryMap(entityType);
        for (SimpleFilterRow simpleFilterRow : filterFiledRows) {
            String fieldName = simpleFilterRow.getFieldName();
            if (EmptyUtil.isEmpty((String)fieldName)) continue;
            if (propEntryMap.containsKey(fieldName)) {
                set.add(String.join((CharSequence)".", propEntryMap.get(fieldName), fieldName));
                continue;
            }
            set.add(fieldName);
        }
        return set;
    }

    public static Map<String, String> getPropEntryMap(String entityType) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map allEntities = dataEntityType.getAllEntities();
        HashMap<String, String> map = new HashMap<String, String>(128);
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType entryEntityType = (EntityType)entry.getValue();
            if (entryEntityType instanceof LinkEntryType || entryEntityType instanceof BillEntityType) continue;
            String prefix = (String)entry.getKey();
            Map fields = entryEntityType.getFields();
            fields.keySet().forEach(field -> map.putIfAbsent((String)field, prefix));
        }
        return map;
    }
}

