/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataSetUtil {
    private static Log logger = LogFactory.getLog(DataSetUtil.class);
    public static final String COLUMN_SEPARATOR = ",";
    public static final String ALIAS_SEPARATOR = ".";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDataSet(DataSet ... dataSets) {
        if (Objects.isNull(dataSets)) {
            return;
        }
        for (DataSet dataSet : dataSets) {
            if (Objects.isNull(dataSet)) continue;
            try {
                dataSet.close();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            finally {
                if (Objects.nonNull(dataSet)) {
                    dataSet = null;
                }
            }
        }
    }

    public static String getSelectFields(DataSet dataSet, String ... filters) {
        return DataSetUtil.getSelectFieldsIfConvertAlias(dataSet, false, filters);
    }

    public static String getSelectFieldsIfConvertAlias(DataSet dataSet, boolean convertAlias, String ... filters) {
        Field[] fields = dataSet.getRowMeta().getFields();
        Set<Object> filterSet = Objects.isNull(filters) ? new HashSet(2) : Arrays.stream(filters).collect(Collectors.toSet());
        List collect = Arrays.stream(fields).map(Field::getName).filter(name -> !filterSet.contains(name)).map(name -> convertAlias ? DataSetUtil.getSelectFieldAlias(name) : name).collect(Collectors.toList());
        return String.join((CharSequence)COLUMN_SEPARATOR, collect);
    }

    public static String getSelectFieldAlias(String name) {
        return DataSetUtil.getSelectFieldAlias(name, true);
    }

    public static String getSelectFieldAlias(String name, boolean isSelect) {
        if (!name.contains(ALIAS_SEPARATOR)) {
            return name;
        }
        String alias = name.replace(ALIAS_SEPARATOR, "");
        return isSelect ? name + " " + alias : alias;
    }

    public static DataSet createRow(String className, String[] fieldNames, DataType[] dataTypes, Collection<Object[]> values) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        CollectionInput inputs = new CollectionInput(rowMeta, values);
        DataSet dataSet = Algo.create((String)className).createDataSet(new Input[]{inputs});
        return dataSet;
    }
}

