/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.constant.ExecutePlanConstant;
import kd.tmc.fpm.business.constant.ReportConstant;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.common.property.EvaluateAmtDetailProp;
import kd.tmc.fpm.common.property.ReportLinkExecRecordProp;

public class DimensionMappingHelper {
    public static final String REPORT_DETAIL_PREFIX = "detailext";
    public static final String LINK_EXECUTE_RECORD_DETAIL_PREFIX = "limit_detailext";
    public static final String DETAIL_DETAIL_PREFIX = "detail_detailext";
    public static final Map<String, String> ENTITY_DETAIL_FIELD_NAME_MAP = new HashMap<String, String>(){
        {
            this.put("fpm_report", DimensionMappingHelper.REPORT_DETAIL_PREFIX);
            this.put("fpm_report_bak", DimensionMappingHelper.REPORT_DETAIL_PREFIX);
            this.put("fpm_executeplan", DimensionMappingHelper.REPORT_DETAIL_PREFIX);
            this.put("fpm_report_process", DimensionMappingHelper.REPORT_DETAIL_PREFIX);
            this.put("fpm_linkexecrecord", DimensionMappingHelper.LINK_EXECUTE_RECORD_DETAIL_PREFIX);
            this.put("fpm_querybalance", DimensionMappingHelper.DETAIL_DETAIL_PREFIX);
            this.put("fpm_detailamtevaluate", DimensionMappingHelper.DETAIL_DETAIL_PREFIX);
            this.put("fpm_reportplan_adjust", DimensionMappingHelper.DETAIL_DETAIL_PREFIX);
        }
    };

    public static Map<Long, Map<String, String>> getDetailExtraFieldsMappings(Collection<Long> systemIds, String appId) {
        HashMap<Long, Map<String, String>> detailFieldsMappingMap = new HashMap<Long, Map<String, String>>(systemIds.size());
        String detailPrefix = ENTITY_DETAIL_FIELD_NAME_MAP.get(appId);
        Map<Object, DynamicObject> loadFromCache = DetailPlanFieldsRepository.loadFromCache("id,detaildimtype,bodysys.id", new QFilter[]{new QFilter("bodysys", "in", systemIds)});
        Map<Long, List<DynamicObject>> systemMap = loadFromCache.values().stream().collect(Collectors.groupingBy(d -> d.getLong("bodysys.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : systemMap.entrySet()) {
            Long systemId = entry.getKey();
            List<DynamicObject> detailFields = entry.getValue();
            HashMap<String, String> detailMappingMap = new HashMap<String, String>(32);
            for (DynamicObject dynamicObject : detailFields) {
                String detailDimTypeStr = dynamicObject.getString("detaildimtype");
                DetailDimType detailDimType = DetailDimType.getDimsionByNumber(detailDimTypeStr);
                if (detailDimType == null || !DetailDimType.isExtraField(detailDimType)) continue;
                String suffix = detailDimType.getNumber().split("_")[1];
                String detailField = detailPrefix + suffix;
                detailMappingMap.put(detailDimType.getNumber(), detailField);
            }
            detailFieldsMappingMap.put(systemId, detailMappingMap);
        }
        return detailFieldsMappingMap;
    }

    public static Map<String, String> getDetailExtraFieldsMapping(Long systemId, String appId) {
        if (EmptyUtil.isEmpty((Long)systemId)) {
            return new HashMap<String, String>(0);
        }
        HashMap map = DimensionMappingHelper.getDetailExtraFieldsMappings(Collections.singletonList(systemId), appId).get(systemId);
        return map != null ? map : new HashMap(0);
    }

    public static Map<String, String> getLinkExecDetailMappingWithoutEntry(Long systemId) {
        Map<String, String> linkExecExtraMappingWithoutEntry = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_linkexecrecord");
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(ReportLinkExecRecordProp.detailPlanFieldMap);
        detailMappingMap.putAll(linkExecExtraMappingWithoutEntry);
        return detailMappingMap;
    }

    public static Map<String, String> getQueryBalanceExtraMappingWithoutEntry(Long systemId) {
        return DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_querybalance");
    }

    public static Map<String, String> getReportPlanDetailMappingWithEntry(Long systemId) {
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(ReportDataQueryService.DETAILDIM_ENTRY_MAPPING_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_report");
        detailExtraFieldsMapping.forEach((k, v) -> detailMappingMap.put((String)k, String.join((CharSequence)".", "detailentry", v)));
        return detailMappingMap;
    }

    public static Map<Long, Map<String, String>> getReportPlanDetailMappingWithEntrys(Collection<Long> systemIds) {
        HashMap<Long, Map<String, String>> detailFiledsMappingMap = new HashMap<Long, Map<String, String>>(systemIds.size());
        Map<Long, Map<String, String>> detailExtraFieldsMappingMap = DimensionMappingHelper.getDetailExtraFieldsMappings(systemIds, "fpm_report");
        for (Map.Entry<Long, Map<String, String>> entry : detailExtraFieldsMappingMap.entrySet()) {
            Long systemId = entry.getKey();
            Map<String, String> detailExtraFieldsMapping = entry.getValue();
            HashMap<String, String> detailMappingMap = new HashMap<String, String>(ReportDataQueryService.DETAILDIM_ENTRY_MAPPING_MAP);
            detailExtraFieldsMapping.forEach((k, v) -> detailMappingMap.put((String)k, String.join((CharSequence)".", "detailentry", v)));
            detailFiledsMappingMap.put(systemId, detailMappingMap);
        }
        return detailFiledsMappingMap;
    }

    public static Map<String, String> getEvaluateDetailMappingWithoutEntry(Long systemId) {
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(EvaluateAmtDetailProp.DETAIL_ENTRY_DIM_TYPE_FIELD_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_detailamtevaluate");
        detailMappingMap.putAll(detailExtraFieldsMapping);
        return detailMappingMap;
    }

    public static Map<String, String> getExecutePlanMappingWithoutEntry(Long systemId) {
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(ExecutePlanConstant.DETAILDIM_ENTRY_MAPPING_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_executeplan");
        detailMappingMap.putAll(detailExtraFieldsMapping);
        return detailMappingMap;
    }

    public static Map<String, String> getAdjustDetailMappingWithEntry(Long systemId) {
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(ReportConstant.DETAIL_DIM_ENTRY_ENTIRE_NAME_MAPPING_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_reportplan_adjust");
        detailExtraFieldsMapping.forEach((k, v) -> detailMappingMap.put((String)k, String.join((CharSequence)".", "detail_entryentity", v)));
        return detailMappingMap;
    }

    public static Map<String, String> getAdjustAllDimMappingWithoutEntry(Long systemId) {
        HashMap<String, String> mappingMap = new HashMap<String, String>(ReportConstant.TYPE_MAPPING_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_reportplan_adjust");
        mappingMap.putAll(detailExtraFieldsMapping);
        return mappingMap;
    }
}

