/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DynamicObjectUtils {
    public static List<DynamicObject> toPlainDynamicObjectCollection(DynamicObject[] selectBills, Set<String> needProps) {
        if (EmptyUtil.isEmpty((Object[])selectBills)) {
            return Collections.emptyList();
        }
        DynamicObject sb = selectBills[0];
        String mappingEntryNumber = DynamicObjectUtils.getEntryNameIfHas(sb, needProps);
        boolean isBillHead = EmptyUtil.isEmpty((String)mappingEntryNumber);
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        HashMap<String, Boolean> relations = new HashMap<String, Boolean>(16);
        for (String fieldName : needProps) {
            Class<Object> propertyType = Object.class;
            String tureProp = fieldName;
            String entrySign = String.format("%s.", mappingEntryNumber);
            if (!isBillHead) {
                tureProp = fieldName.equals(String.format("%s.id", mappingEntryNumber)) ? fieldName : fieldName.replace(entrySign, "");
            }
            relations.put(tureProp, !fieldName.contains(entrySign));
            DynamicSimpleProperty property = new DynamicSimpleProperty(tureProp, propertyType, null);
            property.setEnableNull(true);
            dt.registerSimpleProperty(property);
        }
        DynamicSimpleProperty[] properties = (DynamicSimpleProperty[])dt.getProperties().toArray((Object[])new DynamicSimpleProperty[0]);
        DynamicObjectCollection ret = new DynamicObjectCollection(dt, null);
        for (DynamicObject selectBill : selectBills) {
            if (isBillHead) {
                DynamicObject obj = new DynamicObject(dt, true);
                obj.beginInit();
                for (int i = 0; i < properties.length; ++i) {
                    DynamicSimpleProperty simplePropertie = properties[i];
                    String name = simplePropertie.getName();
                    properties[i].setValueFast((Object)obj, selectBill.get(name));
                }
                obj.endInit();
                ret.add((Object)obj);
                continue;
            }
            DynamicObjectCollection entrys = selectBill.getDynamicObjectCollection(mappingEntryNumber);
            for (DynamicObject entry : entrys) {
                DynamicObject obj = new DynamicObject(dt, true);
                obj.beginInit();
                for (int i = 0; i < properties.length; ++i) {
                    DynamicSimpleProperty simplePropertie = properties[i];
                    String name = simplePropertie.getName();
                    Boolean isHeadProp = (Boolean)relations.get(name);
                    Object value = null;
                    if (isHeadProp.booleanValue()) {
                        value = selectBill.get(name);
                    } else {
                        if (name.equals(String.format("%s.id", mappingEntryNumber))) {
                            name = "id";
                        }
                        value = entry.get(name);
                    }
                    if (value instanceof OrmLocaleValue) {
                        value = ((OrmLocaleValue)value).getLocaleValue();
                    }
                    simplePropertie.setValueFast((Object)obj, value);
                }
                obj.endInit();
                ret.add((Object)obj);
            }
        }
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)ret);
    }

    public static String getEntryNameIfHas(DynamicObject selectBill, Set<String> needProps) {
        MainEntityType mainEntityType = (MainEntityType)selectBill.getDataEntityType();
        Set entryNames = mainEntityType.getAllEntities().keySet();
        List entryNameList = needProps.stream().filter(Objects::nonNull).map(String::trim).map(prop -> prop.split("\\.")).map(item -> item[0]).map(String::trim).filter(entryNames::contains).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(entryNameList)) {
            return "";
        }
        if (entryNameList.size() > 2) {
            throw new KDBizException("too many entries");
        }
        return (String)entryNameList.get(0);
    }

    public static String getEntryPropertyWithOutEntryName(String entryName, String propertyName) {
        String entryNameAddSplit = entryName + ".";
        if (propertyName.startsWith(entryNameAddSplit)) {
            return propertyName.replace(entryNameAddSplit, "");
        }
        return propertyName;
    }

    public static List<DynamicObject> reStoreDynamicObject(List<DynamicObject> dynamicObjectList, String entityName) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return new ArrayList<DynamicObject>(0);
        }
        HashMap<Long, DynamicObject> dynamicObjectMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject planDynamicObject : dynamicObjectList) {
            DynamicObject dy;
            Long id;
            if (Objects.isNull(planDynamicObject)) continue;
            DynamicProperty property = planDynamicObject.getDynamicObjectType().getProperty("id");
            if (Objects.isNull(property) || EmptyUtil.isEmpty((Long)(id = Long.valueOf(planDynamicObject.getLong("id"))))) {
                dy = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                dynamicObjectMap.put(DB.genGlobalLongId(), dy);
            } else {
                dy = dynamicObjectMap.computeIfAbsent(id, k -> {
                    DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                    newDynamicObject.set("id", (Object)id);
                    return newDynamicObject;
                });
            }
            DynamicObjectUtils.initEntryIfNeed(planDynamicObject, dy);
            DynamicObjectUtils.reStoreDynamicObject(planDynamicObject, dy);
        }
        return new ArrayList<DynamicObject>(dynamicObjectMap.values());
    }

    public static DynamicObject reStoreDynamicObject(DynamicObject planDynamicObject, String entityName) {
        if (Objects.isNull(planDynamicObject)) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DynamicObjectUtils.initEntryIfNeed(planDynamicObject, dynamicObject);
        DynamicObjectUtils.reStoreDynamicObject(planDynamicObject, dynamicObject);
        return dynamicObject;
    }

    private static void initEntryIfNeed(DynamicObject planDynamicObject, DynamicObject dynamicObject) {
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)dynamicObjectType.getName());
        Map allEntities = dataEntityType.getAllEntities();
        DataEntityPropertyCollection properties = planDynamicObject.getDynamicObjectType().getProperties();
        HashSet<String> initEntries = new HashSet<String>(16);
        for (IDataEntityProperty property : properties) {
            String prefix;
            EntityType entityType;
            int index;
            String name = property.getName();
            if (EmptyUtil.isEmpty((String)name) || (index = name.indexOf(".")) == -1 || !EmptyUtil.isNoEmpty((Object)(entityType = (EntityType)allEntities.get(prefix = name.substring(0, index)))) || !(entityType instanceof EntryType) || !initEntries.add(prefix)) continue;
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(prefix);
            dynamicObjectCollection.addNew();
        }
    }

    public static DynamicObject reStoreDynamicObject(DynamicObject planDynamicObject, DynamicObject dynamicObject) {
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)dynamicObjectType.getName());
        Map allEntities = dataEntityType.getAllEntities();
        DataEntityPropertyCollection properties = planDynamicObject.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            DynamicObjectUtils.setProperty(allEntities, dynamicObject, planDynamicObject.get(property), property.getName(), 0);
        }
        return dynamicObject;
    }

    private static void setProperty(Map<String, EntityType> allEntities, DynamicObject dynamicObject, Object value, String propertyName, int depth) {
        EntityType entityType;
        int index = propertyName.indexOf(".");
        if (index == -1) {
            DynamicProperty property = dynamicObject.getDynamicObjectType().getProperty(propertyName);
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                DynamicObject baseData = BusinessDataServiceHelper.newDynamicObject((String)basedataProp.getBaseEntityId());
                baseData.set("id", value);
                property.setValueFast((Object)dynamicObject, (Object)baseData);
            } else if (depth == 0 && allEntities.containsKey(propertyName)) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(propertyName);
                DynamicObject entry = (DynamicObject)dynamicObjectCollection.get(dynamicObjectCollection.size() - 1);
                entry.set("id", value);
            } else {
                dynamicObject.set(propertyName, value);
            }
            return;
        }
        String prefix = propertyName.substring(0, index);
        String suffix = propertyName.replace(prefix + ".", "");
        if (depth == 0 && Objects.nonNull(entityType = allEntities.get(prefix)) && entityType instanceof EntryType) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(prefix);
            DynamicObject entry = (DynamicObject)dynamicObjectCollection.get(dynamicObjectCollection.size() - 1);
            DynamicObjectUtils.setProperty(allEntities, entry, value, suffix, depth + 1);
            return;
        }
        DynamicProperty property = dynamicObject.getDynamicObjectType().getProperty(prefix);
        if (property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            DynamicObject baseData = dynamicObject.getDynamicObject((IDataEntityProperty)property);
            if (EmptyUtil.isEmpty((DynamicObject)baseData)) {
                baseData = BusinessDataServiceHelper.newDynamicObject((String)basedataProp.getBaseEntityId());
                property.setValueFast((Object)dynamicObject, (Object)baseData);
            }
            DynamicObjectUtils.setProperty(allEntities, baseData, value, suffix, depth + 1);
        } else {
            dynamicObject.set(propertyName, value);
        }
    }
}

