/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.utils.POIHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ImportDataHelper {
    public static String getReportNumber(Sheet sheet) {
        return ImportDataHelper.getCellValue(sheet, 1, 2);
    }

    public static String getSystemNum(Sheet sheet) {
        return ImportDataHelper.getCellValue(sheet, 1, 1);
    }

    public static String getReportPeriodNum(Sheet sheet) {
        return ImportDataHelper.getCellValue(sheet, 1, 4);
    }

    public static String getCellValue(Sheet sheet, int rowIndex, int colIndex) {
        if (EmptyUtil.isEmpty((Object)sheet)) {
            return null;
        }
        Row row = sheet.getRow(rowIndex);
        if (EmptyUtil.isEmpty((Object)row)) {
            return null;
        }
        Cell cell = row.getCell(colIndex);
        if (EmptyUtil.isEmpty((Object)row)) {
            return null;
        }
        Object cellValue = POIHelper.getCellValue(cell);
        return cellValue.toString();
    }

    public static DynamicObject loadBaseData(String baseDataEntityKey, String number, String name, String selectors, int rowIndex, Sheet sheet) {
        return ImportDataHelper.loadBaseData(baseDataEntityKey, null, number, name, selectors, rowIndex, sheet);
    }

    public static DynamicObject loadBaseData(String baseDataEntityKey, String displayName, String number, String name, String selectors, int rowIndex, Sheet sheet) {
        BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)baseDataEntityKey);
        String nameProperty = basedataEntityType.getNameProperty();
        String numberProperty = basedataEntityType.getNumberProperty();
        if (selectors == null) {
            selectors = String.join((CharSequence)",", "id", nameProperty, numberProperty);
        }
        QFilter filter = null;
        if (StringUtils.isNotEmpty((CharSequence)number) && StringUtils.isNotEmpty((CharSequence)name)) {
            filter = new QFilter(numberProperty, "=", (Object)number).and(new QFilter(nameProperty, "like", (Object)("%" + name + "%")));
        } else if (StringUtils.isNotEmpty((CharSequence)number)) {
            filter = new QFilter(numberProperty, "=", (Object)number);
        } else if (StringUtils.isNotEmpty((CharSequence)name)) {
            filter = new QFilter(nameProperty, "=", (Object)name);
        }
        DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)baseDataEntityKey, (String)selectors, (QFilter[])new QFilter[]{filter});
        if (baseData == null) {
            if (displayName == null) {
                displayName = basedataEntityType.getDisplayName().getLocaleValue();
            }
            if (StringUtils.isNotEmpty((CharSequence)number) && StringUtils.isNotEmpty((CharSequence)name)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c\u3010%3$s\u3011\u7f16\u7801\u3010%4$s\u3011\u548c\u540d\u79f0\u3010%5$s\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u5339\u914d\u5230\u53ef\u7528\u72b6\u6001\u4e0b\u7684\u8bb0\u5f55\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportDataHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIndex + 1, displayName, number, name));
            }
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c\u3010%3$s\u3011\u7f16\u7801\u3010%4$s\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u5339\u914d\u5230\u53ef\u7528\u72b6\u6001\u4e0b\u7684\u8bb0\u5f55\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportDataHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIndex + 1, displayName, number));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c\u3010%3$s\u3011\u540d\u79f0\u3010%4$s\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u5339\u914d\u5230\u53ef\u7528\u72b6\u6001\u4e0b\u7684\u8bb0\u5f55\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportDataHelper_2", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIndex + 1, displayName, name));
        }
        return baseData;
    }
}

