/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;

public class ImportDateTimeHelper {
    private static final String UTC_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String GMT_TIME_FORMAT = "EEE MMM dd yyyy hh:mm:ss z";
    private static final String REGEXP_OA_DATE = "^/OADate\\(-?\\d{1,10}(\\.\\d{1,2})?\\)/$";
    private static final String REGEXP_DIGITAL = "-?\\d{1,10}(\\.\\d{1,2})?";
    private static final String REGEXP_DATE = "((^((1[8-9]\\d{2})|([2-9]\\d{3}))([-/._])(10|12|0?[13578])([-/._])(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-/._])(11|0?[469])([-/._])(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-/._])(0?2)([-/._])(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-/._])(0?2)([-/._])(29)$)|(^([3579][26]00)([-/._])(0?2)([-/._])(29)$)|(^([1][89][0][48])([-/._])(0?2)([-/._])(29)$)|(^([2-9][0-9][0][48])([-/._])(0?2)([-/._])(29)$)|(^([1][89][2468][048])([-/._])(0?2)([-/._])(29)$)|(^([2-9][0-9][2468][048])([-/._])(0?2)([-/._])(29)$)|(^([1][89][13579][26])([-/._])(0?2)([-/._])(29)$)|(^([2-9][0-9][13579][26])([-/._])(0?2)([-/._])(29)$)|\\\\d{2}Z)";
    private static final String REGEXP_UTC_DATE = "[0-9]{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[1-2][0-9]|3[0-1])T16:00:00.000Z";
    private static final String REGEXP_GMT_DATE = "(((Mon)|(Tues)|(Wed)|(Thur)|(Fri)|(Sat)|(Sun))\\s((Jan)|(Feb)|(Mar)|(Apr)|(May)|(Jun)|(Jul)|(Aug)|(Sep)|(Oct)|(Nov)|(Dec))\\s[0-9]{2}\\s[0-9]{4}\\s00:00:00\\s(GMT\\+)[0-9]{2}\\:[0-5][0-9])";

    public static Date handleDateValue(Object cellValue, int rowIdx, Sheet sheet) {
        if (cellValue == null || StringUtils.isBlank((CharSequence)cellValue.toString())) {
            return null;
        }
        Date parseResult = null;
        String dateStr = cellValue.toString();
        if (dateStr.matches(REGEXP_UTC_DATE)) {
            SimpleDateFormat sdf = new SimpleDateFormat(UTC_TIME_FORMAT, Locale.ENGLISH);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                parseResult = sdf.parse(dateStr);
            }
            catch (ParseException e) {
                String errMsg = String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0cUTC\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff08%3$s\uff09\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"ImportDateTimeHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIdx, cellValue);
                throw new KDBizException(errMsg);
            }
            return parseResult;
        }
        if (dateStr.matches(REGEXP_GMT_DATE)) {
            SimpleDateFormat sdf = new SimpleDateFormat(GMT_TIME_FORMAT, Locale.ENGLISH);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                parseResult = sdf.parse(dateStr);
            }
            catch (ParseException e) {
                String errMsg = String.format(ResManager.loadKDString((String)"Sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0cGMT\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff08%3$s\uff09\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"ImportDateTimeHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIdx, cellValue);
                throw new KDBizException(errMsg);
            }
            return parseResult;
        }
        boolean oaResult = dateStr.matches(REGEXP_OA_DATE);
        boolean dateResult = dateStr.matches(REGEXP_DATE);
        if (!dateResult && !oaResult) {
            String errMsg = String.format(ResManager.loadKDString((String)"Sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff08%3$s\uff09\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"ImportDateTimeHelper_2", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIdx, cellValue);
            throw new KDBizException(errMsg);
        }
        if (oaResult) {
            Pattern pattern = Pattern.compile(REGEXP_DIGITAL);
            Matcher matcher = pattern.matcher(dateStr);
            if (matcher.find()) {
                Date baseDate;
                String group = matcher.group();
                double oaDate = Double.parseDouble(group);
                double mantissa = oaDate - (double)((long)oaDate);
                double hour = mantissa * 24.0;
                double min = (hour - (double)((long)hour)) * 60.0;
                double sec = (min - (double)((long)min)) * 60.0;
                SimpleDateFormat myFormat = new SimpleDateFormat("dd MM yyyy");
                try {
                    baseDate = myFormat.parse("30 12 1899");
                }
                catch (ParseException e) {
                    String errMsg = String.format(ResManager.loadKDString((String)"Sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0cOA\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\u3002\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"ImportDateTimeHelper_3", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIdx);
                    throw new KDBizException(errMsg);
                }
                Calendar c = Calendar.getInstance();
                c.setTime(baseDate);
                c.add(5, (int)oaDate);
                c.add(10, (int)hour);
                c.add(12, (int)min);
                c.add(13, (int)sec);
                parseResult = c.getTime();
            }
        } else {
            String[] patterns;
            for (String pattern : patterns = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"}) {
                SimpleDateFormat parser = new SimpleDateFormat(pattern);
                try {
                    parseResult = parser.parse(dateStr);
                    return parseResult;
                }
                catch (ParseException parseException) {
                }
            }
            String errMsg = String.format(ResManager.loadKDString((String)"Sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\u3002\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"ImportDateTimeHelper_4", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIdx);
            throw new KDBizException(errMsg);
        }
        return parseResult;
    }
}

