/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexTreeGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategyFactory;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class LogFormatUtil {
    public static String formatReportData(ReportData reportData, FundPlanSystem fundPlanSystem) {
        return LogFormatUtil.formatReportData(Collections.singletonList(reportData), fundPlanSystem);
    }

    public static String checkRepeatData(Report report, FundPlanSystem fundPlanSystem) {
        IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.createReportDataStrategy(report, fundPlanSystem);
        DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
        DimensionIndexTree indexTree = generator.build();
        for (ReportData reportData : report.getReportDataList()) {
            ArrayList<Long> dimIdList = new ArrayList<Long>(reportData.getDimList().size());
            ArrayList<Object> dimMemIdList = new ArrayList<Object>(reportData.getDimList().size());
            List<Object> prepareDatas = reportData.getDimValList();
            for (int inx = 0; inx < reportData.getDimList().size(); ++inx) {
                TemplateDim templateDim = reportData.getDimList().get(inx);
                if (templateDim.getDimType() == DimensionType.DETAILDIM) continue;
                dimIdList.add(templateDim.getDimensionId());
                dimMemIdList.add(prepareDatas.get(inx));
            }
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            dimensionInfoBean.setDimensionIdList(dimIdList);
            dimensionInfoBean.setMemberIdList(dimMemIdList);
            TreeNode node = indexTree.find(dimensionInfoBean);
            if (node == null) continue;
            node.addData(reportData);
            if (CollectionUtils.isEmpty(node.getDataList()) || node.getDataList().size() <= 1) continue;
            List<ReportData> repeatData = node.getDataList().stream().map(item -> (ReportData)item).collect(Collectors.toList());
            return LogFormatUtil.formatReportData(repeatData, fundPlanSystem);
        }
        return "";
    }

    public static String formatReportData(List<ReportData> reportDataList, FundPlanSystem fundPlanSystem) {
        StringBuilder sb = new StringBuilder();
        for (ReportData reportData : reportDataList) {
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dataDimValList = reportData.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                Long dimensionId;
                Dimension dimension;
                DimMember dimMember;
                TemplateDim templateDim = dimList.get(i);
                if (templateDim.isDetailDim() || (dimMember = (dimension = fundPlanSystem.getMainDimensionByDimensionId(dimensionId = templateDim.getDimensionId())).getDimMemberById((Long)dataDimValList.get(i))) == null) continue;
                sb.append(dimMember.getName()).append("/");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("planAmt:").append(CommonUtils.getValueIfNull(reportData.getPlanAmt()).toPlainString()).append(",reportPlanAmt:").append(CommonUtils.getValueIfNull(reportData.getReportPlanAmt()).toPlainString()).append(",originalPlanAmt:").append(CommonUtils.getValueIfNull(reportData.getOriginalPlanAmt()).toPlainString()).append(",offsetAmt:").append(CommonUtils.getValueIfNull(reportData.getOffsetAmt()).toPlainString()).append(",lockAmt:").append(CommonUtils.getValueIfNull(reportData.getLockAmt()).toPlainString()).append(",holdLockAmt:").append(CommonUtils.getValueIfNull(reportData.getHoldLockAmt()).toPlainString()).append(",actAmt:").append(CommonUtils.getValueIfNull(reportData.getActAmt()).toPlainString()).append(",holdActAmt:").append(CommonUtils.getValueIfNull(reportData.getHoldActAmt()).toPlainString()).append(",reportDataId:").append(reportData.getId()).append(",reportId:").append(reportData.getReportId());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String formatDimensionBeanInfo(DimensionInfoBean dimensionInfoBean, FundPlanSystem system) {
        return LogFormatUtil.formatDimensionBeanInfo(Collections.singletonList(dimensionInfoBean), system);
    }

    public static String formatDimensionBeanInfo(List<DimensionInfoBean> dimensionInfoBeanList, FundPlanSystem system) {
        StringBuilder sb = new StringBuilder();
        Map dimMemberMap = system.getMainDimList().stream().map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        for (DimensionInfoBean dimensionInfoBean : dimensionInfoBeanList) {
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            List memberIdList = dimensionInfoBean.getMemberIdList();
            for (int i = 0; i < dimensionIdList.size(); ++i) {
                DimMember dimMember = (DimMember)dimMemberMap.get((Long)memberIdList.get(i));
                if (Objects.isNull(dimMember)) continue;
                sb.append(dimMember.getName()).append("/");
            }
            sb.append("\r\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String formatReportDataByFilter(List<ReportData> sourceData, Predicate<ReportData> ... filter) {
        FundPlanSystem system = new DimensionRepository().loadSystem(sourceData.get(0).getSystemId());
        List<ReportData> res = sourceData.stream().filter(Arrays.stream(filter).reduce(Predicate::and).orElse(t -> true)).collect(Collectors.toList());
        return LogFormatUtil.formatReportData(res, system);
    }

    public static String getPaths(List<TreeNode> treeNodeList, FundPlanSystem fundPlanSystem) {
        List<DimensionInfoBean> dimensionInfoBeanList = treeNodeList.stream().map(TreeNode::getDimInfoBean).filter(Objects::nonNull).collect(Collectors.toList());
        return LogFormatUtil.formatDimensionBeanInfo(dimensionInfoBeanList, fundPlanSystem);
    }

    public static String formatRDDimensionValue(ReportData reportData, Map<Object, DimMember> dimMemberMap) {
        if (reportData == null || EmptyUtil.isEmpty(dimMemberMap)) {
            return "";
        }
        return reportData.getDimValList().stream().filter(Objects::nonNull).map(dimMemberMap::get).filter(Objects::nonNull).map(DimMember::getName).collect(Collectors.joining("/"));
    }

    public static String formatReportData(ReportData reportData) {
        StringBuilder print = new StringBuilder("-------------------------------------------");
        print.append("\n\t");
        List<TemplateDim> dimList = reportData.getDimList();
        for (TemplateDim templateDim : dimList) {
            print.append("|").append(templateDim.getDimensionName()).append("|");
        }
        print.append("| planAmt |");
        print.append("\n\t");
        for (int i = 0; i < dimList.size(); ++i) {
            print.append("\u2014\u2014");
        }
        print.append("\u2014\u2014");
        print.append("\n\t");
        List<Object> dimValList = reportData.getDimValList();
        DynamicObjectCollection memberResult = QueryServiceHelper.query((String)"fpm_member", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", dimValList)});
        Map<Long, String> memMap = memberResult.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("name")));
        for (Object memId : dimValList) {
            if (!(memId instanceof Long)) {
                print.append("|").append(memId).append("|");
                continue;
            }
            String name = memMap.get((Long)memId);
            print.append("|").append(name).append("|");
        }
        print.append("|").append(reportData.getPlanAmt()).append("|");
        return print.toString();
    }
}

