/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.message.MessageParam;

public class MessageHelper {
    private static final Log logger = LogFactory.getLog(MessageHelper.class);

    public static long sendMessage(MessageParam param) {
        MessageInfo message = new MessageInfo();
        message.setTag(param.getTag());
        message.setTitle(param.getTitle());
        message.setContent(param.getContent());
        message.setUserIds(new ArrayList<Long>(param.getUserIds()));
        message.setType("message");
        message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + param.getFormId() + "&pkId=" + param.getPkId());
        Consumer<MessageInfo> warpMessage = param.getWarpMessage();
        if (Objects.nonNull(warpMessage)) {
            warpMessage.accept(message);
        }
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static long sendMessageByTemplate(MessageParam param) {
        MessageInfo message = MessageHelper.getMessageInfo(param);
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    private static MessageInfo getMessageInfo(MessageParam param) {
        String type = param.getType();
        if (EmptyUtil.isEmpty((String)type)) {
            type = "message";
        }
        MessageInfo message = new MessageInfo();
        message.setTitle(param.getTitle());
        message.setUserIds(new ArrayList<Long>(param.getUserIds()));
        message.setType(type);
        message.setTplScene(param.getTplScene());
        message.setEntityNumber(param.getEntityName());
        message.setNotifyType(MessageCenterServiceHelper.getChannelsOfMsgType((String)type));
        message.setTag(param.getTag());
        message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        message.setMessageSenderName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"MessageHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0])));
        message.setBizDataId(Long.valueOf(DB.genGlobalLongId()));
        message.setNestBillId(Long.valueOf(DB.genGlobalLongId()));
        Consumer<MessageInfo> warpMessage = param.getWarpMessage();
        if (Objects.nonNull(warpMessage)) {
            warpMessage.accept(message);
        }
        if (Objects.nonNull(param.getFormId()) && Objects.nonNull(param.getPkId())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + param.getFormId() + "&pkId=" + param.getPkId());
        }
        return message;
    }

    public static void batchSendMessageByTemplate(List<MessageParam> paramList) {
        if (EmptyUtil.isEmpty(paramList)) {
            return;
        }
        try {
            MessageCenterServiceHelper.batchSendMessages(paramList.stream().map(MessageHelper::getMessageInfo).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            paramList.forEach(MessageHelper::sendMessage);
        }
    }
}

