/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportValueFormulaTypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.BatchSaveSDKReportData;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateMetric;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.impl.DimMemberRepository;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;
import org.apache.commons.collections4.MapUtils;

public class MetricValueUtils {
    private static Log logger = LogFactory.getLog(MetricValueUtils.class);

    public static void fillMetricValMap(ReportData reportData, Report report) {
        MetricValueUtils.fillMetricValMap(reportData, report, false);
    }

    public static void fillMetricValMap(ReportData reportData, Report report, boolean isReference) {
        if (EmptyUtil.isEmpty((Object)report) || EmptyUtil.isEmpty((Object)report.getTemplate())) {
            return;
        }
        ReportTemplate reportTemplate = report.getTemplate();
        if (isReference) {
            List metrics = reportTemplate.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportTypeId(), report.getReportPeriodType().getReportPeriodId())).map(TemplateReportType::getReferencePosList).flatMap(Collection::stream).collect(Collectors.toList());
            for (MetricMember metric : metrics) {
                String formula = metric.getValStr();
                if (EmptyUtil.isNoEmpty((String)formula)) {
                    reportData.putMetricVal(metric.getId(), MetricValueUtils.evalMetricValue(formula, reportData));
                    continue;
                }
                reportData.putMetricVal(metric.getId(), MetricValueUtils.getMetricValue(metric.getTemplateMetricType(), reportData));
            }
            return;
        }
        List<TemplateMetric> metrics = reportTemplate.getMetrics();
        if (EmptyUtil.isEmpty(metrics)) {
            return;
        }
        for (TemplateMetric metric : metrics) {
            MetricMember metricMember = metric.getMetricMember();
            reportData.putMetricVal(metricMember.getId(), MetricValueUtils.getMetricValue(metricMember.getTemplateMetricType(), reportData));
        }
    }

    public static void fillMetricValMap(ReportDataQueryResult reportDataQueryResult, ReportTemplate reportTemplate) {
        if (EmptyUtil.isEmpty((Object)reportTemplate)) {
            return;
        }
        MetricValueUtils.fillMetricValMap(reportDataQueryResult, reportTemplate, Collections.emptyList());
    }

    public static void fillMetricValMap(ReportDataQueryResult reportDataQueryResult, ReportTemplate reportTemplate, List<Long> metricIds) {
        Map metricMemberMap;
        List<TemplateMetric> metrics = reportTemplate.getMetrics();
        if (EmptyUtil.isEmpty(metrics)) {
            return;
        }
        List metricMemberList = metrics.stream().map(TemplateMetric::getMetricMember).collect(Collectors.toList());
        List<TemplateReportType> reportTypeList = reportTemplate.getReportTypeList();
        if (EmptyUtil.isNoEmpty(reportTypeList)) {
            metricMemberList.addAll(reportTypeList.stream().map(TemplateReportType::getReferencePosList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(metricMemberMap = metricMemberList.stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a)))) {
            return;
        }
        List metricMembers = EmptyUtil.isNoEmpty(metricIds) ? metricMemberMap.entrySet().stream().filter(entry -> metricIds.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()) : metrics.stream().map(TemplateMetric::getMetricMember).collect(Collectors.toList());
        for (MetricMember metricMember : metricMembers) {
            reportDataQueryResult.putMetricVal(metricMember.getId(), MetricValueUtils.getMetricValue(metricMember.getTemplateMetricType(), MetricValueUtils.convert(reportDataQueryResult)));
        }
    }

    public static Object getMetricValue(TemplateMetricType type, ReportData reportData) {
        if (EmptyUtil.isEmpty((Object)type)) {
            return BigDecimal.ZERO;
        }
        switch (type) {
            case PLANAMT: {
                return reportData.getPlanAmt();
            }
            case ORIGINALPLANAMT: {
                return reportData.getOriginalPlanAmt();
            }
            case REPORTPLANAMT: {
                return reportData.getReportPlanAmt();
            }
            case PLANREFERENCEAMT: {
                return reportData.getPlanReferenceAmt();
            }
            case ACTMAT: {
                return reportData.getActAmt();
            }
            case LOCKAMT: {
                return reportData.getLockAmt();
            }
        }
        return BigDecimal.ZERO;
    }

    public static void setMetricValue(TemplateMetricType type, ReportData sourceData, ReportData targetData) {
        if (type == null) {
            return;
        }
        switch (type) {
            case PLANAMT: {
                targetData.setPlanAmt(sourceData.getBigDecimalValue());
                break;
            }
            case ORIGINALPLANAMT: {
                targetData.setOriginalPlanAmt(sourceData.getBigDecimalValue());
                break;
            }
            case REPORTPLANAMT: {
                targetData.setReportPlanAmt(sourceData.getBigDecimalValue());
                break;
            }
            case PLANREFERENCEAMT: {
                targetData.setPlanReferenceAmt(sourceData.getBigDecimalValue());
                break;
            }
            case ACTMAT: {
                targetData.setActAmt(sourceData.getBigDecimalValue());
                break;
            }
            case LOCKAMT: {
                targetData.setLockAmt(sourceData.getBigDecimalValue());
                break;
            }
        }
    }

    public static void setMetricValue(TemplateMetricType type, ReportDataQueryResult sourceData, BigDecimal value) {
        if (type == null) {
            return;
        }
        value = CommonUtils.getValueIfNull(value);
        switch (type) {
            case PLANAMT: {
                sourceData.setPlanAmt(value);
                break;
            }
            case ORIGINALPLANAMT: {
                sourceData.setOriginalPlanAmt(value);
                break;
            }
            case REPORTPLANAMT: {
                sourceData.setReportPlanAmt(value);
                break;
            }
            case PLANREFERENCEAMT: {
                sourceData.setPlanReferenceAmt(value);
                break;
            }
            case ACTMAT: {
                sourceData.setActAmt(value);
                break;
            }
            case LOCKAMT: {
                sourceData.setLockAmt(value);
                break;
            }
        }
    }

    public static void setMetricValue(TemplateMetricType type, ReportData sourceData, BigDecimal value) {
        if (type == null) {
            return;
        }
        value = CommonUtils.getValueIfNull(value);
        switch (type) {
            case PLANAMT: {
                sourceData.setPlanAmt(value);
                break;
            }
            case ORIGINALPLANAMT: {
                sourceData.setOriginalPlanAmt(value);
                break;
            }
            case REPORTPLANAMT: {
                sourceData.setReportPlanAmt(value);
                break;
            }
            case PLANREFERENCEAMT: {
                sourceData.setPlanReferenceAmt(value);
                break;
            }
            case ACTMAT: {
                sourceData.setActAmt(value);
                break;
            }
            case LOCKAMT: {
                sourceData.setLockAmt(value);
                break;
            }
        }
    }

    public static List<ReportValueFormulaTypeEnum> splitFormulaBaseMetricType(String formula) {
        ArrayList<ReportValueFormulaTypeEnum> metricTypeList = new ArrayList<ReportValueFormulaTypeEnum>(5);
        for (ReportValueFormulaTypeEnum formulaTypeEnum : ReportValueFormulaTypeEnum.values()) {
            if (!formula.contains(formulaTypeEnum.getValue())) continue;
            metricTypeList.add(formulaTypeEnum);
        }
        return metricTypeList;
    }

    public static Object evalMetricValue(String formula, ReportData reportData) {
        Object result;
        formula = MetricValueUtils.handleNum(formula);
        Expr expr = FormulaEngine.parseFormula((String)formula);
        HashMap<String, BigDecimal> variableMap = new HashMap<String, BigDecimal>(16);
        for (ReportValueFormulaTypeEnum formulaTypeEnum : ReportValueFormulaTypeEnum.values()) {
            String formulaType = formulaTypeEnum.getValue();
            if (!formula.contains(formulaType)) continue;
            BigDecimal value = BigDecimal.ZERO;
            switch (formulaTypeEnum) {
                case PRE_QUOTA: {
                    value = reportData.getLockAmt();
                    break;
                }
                case PLAN_QUOTA: {
                    value = reportData.getPlanAmt();
                    break;
                }
                case ORIGIN_QUOTA: {
                    value = reportData.getOriginalPlanAmt();
                    break;
                }
                case REPORT_QUOTA: {
                    value = reportData.getReportPlanAmt();
                    break;
                }
                case EXECUTED_QUOTA: {
                    value = reportData.getActAmt();
                    break;
                }
                case PLAN_TEM_QUOTA: {
                    value = reportData.getPlanReferenceAmt();
                    break;
                }
            }
            variableMap.put(formulaType, value);
        }
        try {
            result = FormulaEngine.execExcelFormula((Expr)expr, variableMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ArithmeticException) {
                result = BigDecimal.ZERO;
            }
            if (ex instanceof FormulaException) {
                result = BigDecimal.ZERO;
            }
            throw new KDBizException(ex.getMessage());
        }
        if (result instanceof Double) {
            if (Double.isNaN((Double)result)) {
                return BigDecimal.ZERO;
            }
            if (Double.isInfinite((Double)result)) {
                return BigDecimal.ZERO;
            }
        }
        return result;
    }

    public static String handleNum(String formula) {
        StringBuilder formulaBuilder = new StringBuilder();
        for (int i = 0; i < formula.length(); ++i) {
            if (i > 0 && formula.charAt(i) == '-') {
                if (formula.charAt(i - 1) == '-') {
                    formulaBuilder.deleteCharAt(formulaBuilder.length() - 1);
                    formulaBuilder.append('+');
                    continue;
                }
                if (formula.charAt(i - 1) == '+') {
                    formulaBuilder.deleteCharAt(formulaBuilder.length() - 1);
                    formulaBuilder.append('-');
                    continue;
                }
            }
            formulaBuilder.append(formula.charAt(i));
        }
        formula = formulaBuilder.toString();
        return formula;
    }

    private static ReportData convert(ReportDataQueryResult reportDataQueryResult) {
        return ReportHelper.convert(Collections.singletonList(reportDataQueryResult)).get(0);
    }

    public static MetricMember getMetricMember(FundPlanSystem system, TemplateMetricType type) {
        Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
        Optional<MetricMember> first = metricDim.getAllDimMemberList().stream().map(MetricMember.class::cast).filter(metricMember -> metricMember.getTemplateMetricType() == type).findFirst();
        return first.orElse(null);
    }

    public static BigDecimal computeByExpress(FundPlanSystem system, TemplateMetricType type, Map<TemplateMetricType, String> param) {
        return MetricValueUtils.computeByExpress(MetricValueUtils.getMetricMember(system, type), param);
    }

    public static BigDecimal computeByExpress(MetricMember metricMember, Map<TemplateMetricType, String> param) {
        Object result;
        if (metricMember == null) {
            return BigDecimal.ZERO;
        }
        String valStr = metricMember.getValStr();
        logger.info("MetricValueUtils.computeByExpress \u6267\u884c\u516c\u5f0f\uff1a{}", (Object)valStr);
        Expr expr = FormulaEngine.parseFormula((String)valStr);
        HashMap<String, BigDecimal> variableMap = new HashMap<String, BigDecimal>(param.size());
        for (ReportValueFormulaTypeEnum formulaTypeEnum : ReportValueFormulaTypeEnum.values()) {
            String formulaType = formulaTypeEnum.getValue();
            if (!valStr.contains(formulaType)) continue;
            String value = param.getOrDefault(MetricValueUtils.switchType(formulaTypeEnum), String.valueOf(BigDecimal.ZERO));
            variableMap.put(formulaType, new BigDecimal(value));
        }
        try {
            result = FormulaEngine.execExcelFormula((Expr)expr, variableMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ArithmeticException) {
                result = BigDecimal.ZERO;
            }
            if (ex instanceof FormulaException) {
                result = BigDecimal.ZERO;
            }
            throw new KDBizException(ex.getMessage());
        }
        logger.info("MetricValueUtils.computeByExpress \u8ba1\u7b97\u7ed3\u679c\uff1a{}", result);
        return result == null ? BigDecimal.ZERO : new BigDecimal(result.toString());
    }

    public static TemplateMetricType switchType(ReportValueFormulaTypeEnum typeEnum) {
        switch (typeEnum) {
            case PRE_QUOTA: {
                return TemplateMetricType.LOCKAMT;
            }
            case PLAN_QUOTA: {
                return TemplateMetricType.PLANAMT;
            }
            case ORIGIN_QUOTA: {
                return TemplateMetricType.ORIGINALPLANAMT;
            }
            case REPORT_QUOTA: {
                return TemplateMetricType.REPORTPLANAMT;
            }
            case EXECUTED_QUOTA: {
                return TemplateMetricType.ACTMAT;
            }
            case PLAN_TEM_QUOTA: {
                return TemplateMetricType.PLANREFERENCEAMT;
            }
        }
        return TemplateMetricType.CUSTOM;
    }

    public static void splitMetric(Report report, List<Long> metricMemberIds) {
        DynamicObjectCollection metricDOS = new DimMemberRepository().queryMetricDimMembers(metricMemberIds, null);
        MetricValueUtils.splitReportMetric(report, metricDOS);
    }

    public static List<ReportData> splitMetric(List<ReportData> reportDataList, ReportTemplate reportTemplate, List<Long> metricMemberIds) {
        DynamicObjectCollection metricDOS = new DimMemberRepository().queryMetricDimMembers(metricMemberIds, null);
        return MetricValueUtils.splitMetric(reportDataList, reportTemplate, metricDOS);
    }

    public static DynamicObjectCollection queryMetricMemberBySystemId(Long systemId) {
        return new DimMemberRepository().queryMetricDimMembers(null, Collections.singletonList(systemId));
    }

    public static void splitMetric(Report report) {
        MetricValueUtils.splitReportMetric(report, MetricValueUtils.queryMetricMemberBySystemId(report.getSystemId()));
    }

    public static void splitReportMetric(Report report, DynamicObjectCollection metricDOS) {
        report.setReportDataList(MetricValueUtils.splitMetric(report.getReportDataList(), report.getTemplate(), metricDOS));
    }

    private static List<ReportData> splitMetric(List<ReportData> reportDataList, ReportTemplate reportTemplate, DynamicObjectCollection metricDOS) {
        ArrayList<ReportData> newReportDataList = new ArrayList<ReportData>();
        for (ReportData reportData : reportDataList) {
            if (MapUtils.isNotEmpty(reportData.getAuxiliaryValMap()) || reportData.isAuxiliaryInfo()) {
                newReportDataList.add(reportData);
                continue;
            }
            for (DynamicObject metricDO : metricDOS) {
                ReportData currReportData = new ReportData(reportData);
                MetricValueUtils.zeroReportDataAmt(currReportData);
                currReportData.setDimList(new ArrayList<TemplateDim>(reportData.getDimList()));
                currReportData.setDimValList(new ArrayList<Object>(reportData.getDimValList()));
                newReportDataList.add(currReportData);
                TemplateMetricType type = ITypeEnum.getByNumber(metricDO.getString("metricpresettype"), TemplateMetricType.class);
                String formula = metricDO.getString("computeformulavalue_tag");
                if (EmptyUtil.isNoEmpty((String)formula)) {
                    currReportData.setBigDecimalValueOrDefault(MetricValueUtils.evalMetricValue(formula, reportData));
                } else {
                    currReportData.setValue(MetricValueUtils.getMetricValue(type, reportData));
                }
                currReportData.getDimList().add(reportTemplate.getMetricTplDim());
                currReportData.getDimValList().add(metricDO.getLong("id"));
                if (type != TemplateMetricType.PLANAMT) continue;
                currReportData.setId(reportData.getId());
                if (!EmptyUtil.isNoEmpty(reportData.getSourceIdList())) continue;
                currReportData.setSourceIdList(reportData.getSourceIdList());
            }
        }
        return newReportDataList;
    }

    private static void zeroReportDataAmt(ReportData reportData) {
        reportData.setPlanAmt(BigDecimal.ZERO);
        reportData.setActAmt(BigDecimal.ZERO);
        reportData.setPlanReferenceAmt(BigDecimal.ZERO);
        reportData.setOriginalPlanAmt(BigDecimal.ZERO);
        reportData.setLockAmt(BigDecimal.ZERO);
        reportData.setReportPlanAmt(BigDecimal.ZERO);
    }

    public static void mergeMetric(Report report) {
        MetricValueUtils.mergeMetric(report, MetricValueUtils.queryMetricMemberBySystemId(report.getSystemId()));
    }

    public static void mergeMetric(Report report, DynamicObjectCollection metricDOS) {
        Map<List, List<ReportData>> collect = report.getReportDataList().stream().collect(Collectors.groupingBy(reportData -> Collections.singletonList(EvalDimensionCombination.getEvalDimensionCombinationByReportData(reportData, t -> t.getDimType() != DimensionType.METRIC))));
        ArrayList<ReportData> newReportDataList = new ArrayList<ReportData>(collect.size());
        Map<Object, String> metricPresetTypeMap = metricDOS.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("metricpresettype")));
        for (List<ReportData> rdList : collect.values()) {
            ReportData result = rdList.stream().filter(reportData -> reportData.getId() != null).findFirst().orElseGet(() -> (ReportData)rdList.get(0));
            boolean dirty = false;
            for (ReportData data : rdList) {
                Object dimVal;
                if (data.isDirty() != null && data.isDirty().booleanValue()) {
                    dirty = true;
                }
                if (EmptyUtil.isEmpty((Object)(dimVal = data.getDimValByDimType(DimensionType.METRIC, null)))) {
                    result.setPlanAmt(data.getBigDecimalValue());
                    result.setOriginalPlanAmt(data.getBigDecimalValue());
                    continue;
                }
                if (!metricPresetTypeMap.containsKey(dimVal)) continue;
                TemplateMetricType type = ITypeEnum.getByNumber(metricPresetTypeMap.get(dimVal), TemplateMetricType.class);
                MetricValueUtils.setMetricValue(type, data, result);
                if (type != TemplateMetricType.PLANAMT) continue;
                result.setId(data.getId());
                result.setDimValList(new ArrayList<Object>(data.getDimValList()));
                result.setDimList(new ArrayList<TemplateDim>(data.getDimList()));
            }
            result.setDirty(dirty);
            newReportDataList.add(result);
        }
        report.setReportDataList(newReportDataList);
    }

    public static void updateSDKReportDataDiffAmt(List<TemplateMetricType> metricTypeList, ReportData targetData, BatchSaveSDKReportData sourceData) {
        for (TemplateMetricType metricType : metricTypeList) {
            switch (metricType) {
                case PLANAMT: {
                    BigDecimal addAmt = sourceData.getPlanAmt().subtract(sourceData.getOldPlanAmt());
                    targetData.addPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
                case LOCKAMT: {
                    BigDecimal addAmt = sourceData.getLockAmt().subtract(sourceData.getOldLockAmt());
                    targetData.addLockAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                }
                case ACTMAT: {
                    BigDecimal addAmt = sourceData.getActAmt().subtract(sourceData.getOldActAmt());
                    targetData.addActAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
                case REPORTPLANAMT: {
                    BigDecimal addAmt = sourceData.getReportPlanAmt().subtract(sourceData.getOldReportPlanAmt());
                    targetData.addReportPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
                case ORIGINALPLANAMT: {
                    BigDecimal addAmt = sourceData.getOriginalPlanAmt().subtract(sourceData.getOldOriginalPlanAmt());
                    targetData.addOriginalPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
                case PLANREFERENCEAMT: {
                    BigDecimal addAmt = sourceData.getPlanReferenceAmt().subtract(sourceData.getOldPlanReferenceAmt());
                    targetData.addPlanReferenceAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
            }
        }
    }

    public static void incrementalUpdateReportDataAmt(List<TemplateMetricType> metricTypeList, ReportData targetData, ReportData sourceData) {
        for (TemplateMetricType metricType : metricTypeList) {
            switch (metricType) {
                case PLANAMT: {
                    BigDecimal addAmt = sourceData.getPlanAmt();
                    targetData.addPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
                case LOCKAMT: {
                    BigDecimal addAmt = sourceData.getLockAmt();
                    targetData.addLockAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                }
                case ACTMAT: {
                    BigDecimal addAmt = sourceData.getActAmt();
                    targetData.addActAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
                case REPORTPLANAMT: {
                    BigDecimal addAmt = sourceData.getReportPlanAmt();
                    targetData.addReportPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
                case ORIGINALPLANAMT: {
                    BigDecimal addAmt = sourceData.getOriginalPlanAmt();
                    targetData.addOriginalPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
                case PLANREFERENCEAMT: {
                    BigDecimal addAmt = sourceData.getPlanReferenceAmt();
                    targetData.addPlanReferenceAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetData.getAmountUnit().getNumber()), (BigDecimal)addAmt));
                    break;
                }
            }
        }
    }

    public static BigDecimal transferScaleIfPercent(boolean isPercent, BigDecimal amt) {
        if (isPercent && Objects.nonNull(amt)) {
            return amt.divide(BigDecimal.ONE, 4, RoundingMode.HALF_UP);
        }
        return amt;
    }

    public static List<MetricMember> listAllBaseMetricMember(FundPlanSystem fundPlanSystem) {
        Dimension metricDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.METRIC);
        return metricDim.getAllDimMemberList().stream().map(item -> (MetricMember)item).filter(item -> item.getTemplateMetricType() == TemplateMetricType.PLANREFERENCEAMT || item.getTemplateMetricType() == TemplateMetricType.PLANAMT || item.getTemplateMetricType() == TemplateMetricType.REPORTPLANAMT || item.getTemplateMetricType() == TemplateMetricType.ORIGINALPLANAMT || item.getTemplateMetricType() == TemplateMetricType.LOCKAMT || item.getTemplateMetricType() == TemplateMetricType.ACTMAT).collect(Collectors.toList());
    }
}

