/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class ReportHelper {
    public static String getLoggerInfo(Report report, FundPlanSystem system) {
        LinkedHashMap<String, Object> logInfoMap = new LinkedHashMap<String, Object>(10);
        logInfoMap.put("id", report.getId());
        logInfoMap.put("name", report.getName());
        Map<Long, DimMember> memberMap = null;
        if (system != null) {
            memberMap = system.getMainDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, o -> o, (a, b) -> a));
        }
        Map<Long, DimMember> finalMemberMap = memberMap;
        List<ReportData> reportDataList = report.getReportDataList();
        ArrayList reportDataLogInfoList = new ArrayList(reportDataList.size());
        reportDataList.stream().forEach(item -> {
            HashMap<String, Object> logInfo = new HashMap<String, Object>(3);
            List<TemplateDim> dimList = item.getDimList();
            List<Object> dimValList = item.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                Object valObj = dimValList.get(i);
                if (templateDim.getDimType() != DimensionType.DETAILDIM && finalMemberMap != null) {
                    valObj = valObj == null ? null : (finalMemberMap.get(Long.valueOf(valObj.toString())) == null ? "" : ((DimMember)finalMemberMap.get(Long.valueOf(valObj.toString()))).getName());
                }
                logInfo.put(templateDim.getDimensionName(), valObj);
            }
            logInfo.put("value", item.getPlanAmt());
            reportDataLogInfoList.add(logInfo);
        });
        logInfoMap.put("reportData", reportDataLogInfoList);
        return JSON.toJSONString(logInfoMap);
    }

    public static String getLoggerInfo(Report report) {
        return ReportHelper.getLoggerInfo(report, null);
    }

    public static String getLoggerInfo(List<ReportData> reportDataList, FundPlanSystem system) {
        Map<Long, DimMember> memberMap = null;
        if (system != null) {
            memberMap = system.getMainDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, o -> o, (a, b) -> a));
        }
        Map<Long, DimMember> finalMemberMap = memberMap;
        ArrayList reportDataLogInfoList = new ArrayList(reportDataList.size());
        reportDataList.stream().forEach(item -> {
            HashMap<String, Object> logInfo = new HashMap<String, Object>(3);
            List<TemplateDim> dimList = item.getDimList();
            List<Object> dimValList = item.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                Object valObj = dimValList.get(i);
                if (templateDim.getDimType() != DimensionType.DETAILDIM && finalMemberMap != null) {
                    valObj = valObj == null ? null : ((DimMember)finalMemberMap.get(Long.valueOf(valObj.toString()))).getName();
                }
                logInfo.put(templateDim.getDimensionName(), valObj);
            }
            logInfo.put("value", item.getPlanAmt());
            logInfo.put("col", item.getCol());
            logInfo.put("row", item.getRow());
            logInfo.put("isChangeReportData", ReportChangeData.class.isInstance(item));
            reportDataLogInfoList.add(logInfo);
        });
        return JSON.toJSONString(reportDataLogInfoList);
    }
}

