/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.ReportWorkCalendar;

public class WorkCalenderLoadUtils {
    public static final String BD_WORK_CALENDAR = "bd_workcalendar";

    public static boolean existCalendar(Long orgId) {
        QFilter[] qf = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return TmcDataServiceHelper.exists((String)BD_WORK_CALENDAR, (QFilter[])qf);
    }

    public static ReportWorkCalendar loadWorkCalendar(DimMember org, Date dateFrom, Date dateTo) {
        HashMap<String, Long> orgMap = new HashMap<String, Long>();
        orgMap.put("org", org.getSourceId());
        orgMap.put("dataOrg", org.getSourceId());
        return WorkCalenderLoadUtils.load(orgMap, dateFrom, dateTo);
    }

    private static ReportWorkCalendar load(Map<String, Long> orgMap, Date dateFrom, Date dateTo) {
        String orderBys;
        QFilter[] qf;
        String selectFields;
        Long dataOrg = orgMap.get("dataOrg");
        ORM orm = ORM.create();
        DynamicObjectCollection obj = orm.query(BD_WORK_CALENDAR, selectFields = "id,number,org,dateentry.id,dateentry.workdate,dateentry.datetype", qf = new QFilter[]{new QFilter("org", "=", (Object)dataOrg), new QFilter("isindividuation", "=", (Object)"0"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)}, orderBys = "dateentry.workdate asc");
        if (obj != null && obj.size() > 0) {
            return WorkCalenderLoadUtils.handleQueryResult(orgMap.get("org"), dateFrom, dateTo, obj);
        }
        Long parentId = WorkCalenderLoadUtils.getOrgPrentId(dataOrg);
        if (parentId != null) {
            orgMap.put("dataOrg", parentId);
            return WorkCalenderLoadUtils.load(orgMap, dateFrom, dateTo);
        }
        return new ReportWorkCalendar();
    }

    private static ReportWorkCalendar handleQueryResult(Long orgId, Date dateFrom, Date dateTo, DynamicObjectCollection obj) {
        Map<Date, Integer> markDateMap = WorkCalenderLoadUtils.getMarkDateMap(orgId, dateFrom, dateTo);
        HashSet<Date> workCalendarSet = new HashSet<Date>();
        Date startDate = null;
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        for (DynamicObject workDate : entry) {
            Date date = workDate.getDate("workdate");
            int type = markDateMap.containsKey(date) ? markDateMap.get(date).intValue() : workDate.getInt("datetype");
            if (type == 1 || type == 2) {
                workCalendarSet.add(date);
            }
            if (startDate != null && startDate.compareTo(date) <= 0) continue;
            startDate = date;
        }
        ReportWorkCalendar reportWorkCalendar = new ReportWorkCalendar();
        reportWorkCalendar.setCalendarSet(workCalendarSet);
        reportWorkCalendar.setStartDate(startDate);
        return reportWorkCalendar;
    }

    public static Map<Date, Integer> getMarkDateMap(Long orgId, Date dateFrom, Date dateTo) {
        HashMap<Date, Integer> markDateMap = new HashMap<Date, Integer>();
        if (orgId != null && dateFrom != null && dateTo != null) {
            WorkCalenderLoadUtils.findAllMarkDate(markDateMap, orgId, dateFrom, dateTo);
        }
        return markDateMap;
    }

    private static void findAllMarkDate(Map<Date, Integer> markDateMap, Long orgId, Date dateFrom, Date dateTo) {
        Long parentId;
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)"1"), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)BD_WORK_CALENDAR, (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            for (DynamicObject date : entityList) {
                Date dateKey = date.getDate(1);
                if (markDateMap.containsKey(dateKey)) continue;
                int type = date.getInt(2);
                markDateMap.put(dateKey, type);
            }
        }
        if ((parentId = WorkCalenderLoadUtils.getOrgPrentId(orgId)) != null && parentId != 0L) {
            WorkCalenderLoadUtils.findAllMarkDate(markDateMap, parentId, dateFrom, dateTo);
        }
    }

    private static Long getOrgPrentId(Long id) {
        QFilter[] qf = new QFilter[]{new QFilter("view.isdefault", "=", (Object)"1"), new QFilter("view.treetype", "=", (Object)"01"), new QFilter("org", "=", (Object)id)};
        DynamicObject parentObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent", (QFilter[])qf);
        return parentObj == null ? null : Long.valueOf(parentObj.getLong("parent"));
    }

    public static Date getMidnightDateTime() {
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

